/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.editor;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ClientFactory;
import name.abuchen.portfolio.ui.editor.ClientInput;
import name.abuchen.portfolio.ui.editor.LoadClientThread;
import name.abuchen.portfolio.ui.editor.ProgressProvider;
import name.abuchen.portfolio.ui.selection.SelectionService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;

@Creatable
@Singleton
public class ClientInputFactory {
    private Map<ClientInput, AtomicInteger> cache = new HashMap<ClientInput, AtomicInteger>();
    @Inject
    private IEclipseContext context;
    @Inject
    private IEventBroker broker;
    @Inject
    private SelectionService selectionService;

    public synchronized ClientInput lookup(File clientFile) {
        Optional<ClientInput> input = this.cache.keySet().stream().filter(i -> clientFile.equals(i.getFile())).findAny();
        if (input.isPresent()) {
            return input.get();
        }
        ClientInput answer = new ClientInput(clientFile.getName(), clientFile);
        ContextInjectionFactory.inject((Object)answer, (IEclipseContext)this.context);
        this.cache.put(answer, new AtomicInteger());
        if (!ClientFactory.isEncrypted((File)clientFile)) {
            new LoadClientThread(answer, this.broker, new ProgressProvider(answer), null).start();
        }
        return answer;
    }

    public synchronized ClientInput create(String label, Client client) {
        ClientInput answer = new ClientInput(label, null);
        ContextInjectionFactory.inject((Object)answer, (IEclipseContext)this.context);
        answer.setClient(client);
        answer.touch();
        this.cache.put(answer, new AtomicInteger());
        return answer;
    }

    public synchronized void incrementEditorCount(ClientInput clientInput) {
        this.cache.computeIfAbsent(clientInput, i -> new AtomicInteger()).incrementAndGet();
    }

    public synchronized void decrementEditorCount(ClientInput clientInput) {
        int newCount = this.cache.computeIfAbsent(clientInput, i -> new AtomicInteger()).decrementAndGet();
        if (newCount <= 0) {
            this.cache.remove(clientInput);
            clientInput.dispose();
            this.selectionService.getSelection(clientInput.getClient()).ifPresent(s -> this.selectionService.setSelection(null));
        }
    }
}

