/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.editor;

import name.abuchen.portfolio.ui.editor.ClientInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;

class ProgressProvider {
    private final ClientInput clientInput;
    private volatile int totalWork;
    private volatile int worked;

    public ProgressProvider(ClientInput clientInput) {
        this.clientInput = clientInput;
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    public int getWorked() {
        return this.worked;
    }

    public IProgressMonitor createMonitor() {
        return new NullProgressMonitor(){

            public void beginTask(String name, int totalWork) {
                ProgressProvider.this.totalWork = totalWork;
            }

            public void worked(int work) {
                ProgressProvider.this.worked += work;
                Display.getDefault().asyncExec(() -> ProgressProvider.this.clientInput.notifyListeners(l -> l.onLoading(ProgressProvider.this.totalWork, ProgressProvider.this.worked)));
            }
        };
    }
}

