/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.editor;

import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

class ToolBarPlusChevronLayout
extends Layout
implements IMenuListener {
    private ImageHyperlink chevron;
    private Menu chevronMenu;
    private List<ContributionItem> invisible = new ArrayList<ContributionItem>();

    public ToolBarPlusChevronLayout(Composite host) {
        this.chevron = new ImageHyperlink(host, 8);
        this.chevron.setImage(Images.CHEVRON.image());
        this.chevron.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ImageHyperlink item = (ImageHyperlink)e.widget;
                if (ToolBarPlusChevronLayout.this.chevronMenu == null) {
                    MenuManager menuMgr = new MenuManager("#PopupMenu");
                    menuMgr.setRemoveAllWhenShown(true);
                    menuMgr.addMenuListener((IMenuListener)ToolBarPlusChevronLayout.this);
                    ToolBarPlusChevronLayout.this.chevronMenu = menuMgr.createContextMenu((Control)item.getParent());
                }
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                ToolBarPlusChevronLayout.this.chevronMenu.setLocation(pt.x, pt.y + rect.height);
                ToolBarPlusChevronLayout.this.chevronMenu.setVisible(true);
                item.addDisposeListener(event -> ToolBarPlusChevronLayout.this.chevronMenu.dispose());
            }
        });
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        ToolBar toolBar = this.getToolBar(composite);
        return toolBar.computeSize(wHint, hHint, flushCache);
    }

    protected void layout(Composite composite, boolean flushCache) {
        ToolBar toolBar = this.getToolBar(composite);
        Rectangle availableBounds = composite.getBounds();
        Point chevronSize = this.chevron.computeSize(-1, -1);
        this.invisible = new ArrayList<ContributionItem>();
        int width = 0;
        ToolItem[] items = toolBar.getItems();
        int index = 0;
        while (index < items.length) {
            ToolItem ti = items[index];
            Rectangle itemBounds = ti.getBounds();
            if (width + itemBounds.width > availableBounds.width || index + 1 < items.length && width + itemBounds.width + chevronSize.x > availableBounds.width) {
                int jj = index;
                while (jj < items.length) {
                    this.invisible.add((ContributionItem)items[jj].getData());
                    ++jj;
                }
                break;
            }
            width += itemBounds.width;
            ++index;
        }
        if (this.invisible.isEmpty()) {
            if (this.chevron.isVisible()) {
                this.chevron.setVisible(false);
            }
        } else {
            this.chevron.setBounds(availableBounds.width - chevronSize.x, (availableBounds.height - chevronSize.y) / 2, chevronSize.x, chevronSize.y);
            if (!this.chevron.isVisible()) {
                this.chevron.setVisible(true);
            }
            availableBounds.width -= chevronSize.x;
        }
        toolBar.setBounds(availableBounds.width - width, 0, width, availableBounds.height);
    }

    private ToolBar getToolBar(Composite composite) {
        ToolBar toolBar = null;
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ToolBar) {
                toolBar = (ToolBar)child;
                break;
            }
            ++n2;
        }
        if (toolBar == null) {
            throw new IllegalArgumentException();
        }
        return toolBar;
    }

    public void menuAboutToShow(IMenuManager manager) {
        for (ContributionItem item : this.invisible) {
            if (item instanceof DropDown) {
                DropDown dropDown = (DropDown)item;
                MenuManager subMenu = new MenuManager(dropDown.getLabel());
                subMenu.setImageDescriptor(dropDown.getImage().descriptor());
                dropDown.getMenuListener().menuAboutToShow((IMenuManager)subMenu);
                manager.add((IContributionItem)subMenu);
                continue;
            }
            if (item instanceof ActionContributionItem) {
                ActionContributionItem action = (ActionContributionItem)item;
                String label = action.getAction().getText();
                if (label == null || label.isEmpty()) {
                    label = action.getAction().getToolTipText();
                }
                manager.add((IAction)new SimpleAction(label, action.getAction().getImageDescriptor(), a -> action.getAction().run()));
                continue;
            }
            manager.add((IAction)new LabelOnly(item.toString()));
        }
    }
}

