/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Named;
import name.abuchen.portfolio.datatransfer.Extractor;
import name.abuchen.portfolio.datatransfer.IBFlexStatementExtractor;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.wizards.datatransfer.ImportExtractedItemsWizard;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImportIBHandler {
    @CanExecute
    boolean isVisible(@Named(value="e4ActivePart") MPart part) {
        return MenuHelper.isClientPartActive(part);
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell) {
        MenuHelper.getActiveClient(part).ifPresent(client -> this.runImport(part, shell, (Client)client));
    }

    private void runImport(MPart part, Shell shell, Client client) {
        try {
            IBFlexStatementExtractor extractor = new IBFlexStatementExtractor(client);
            FileDialog fileDialog = new FileDialog(shell, 4098);
            fileDialog.setText(extractor.getLabel());
            fileDialog.setFilterNames(new String[]{MessageFormat.format("{0} ({1})", extractor.getLabel(), "*.xml")});
            fileDialog.setFilterExtensions(new String[]{"*.xml"});
            fileDialog.open();
            String[] filenames = fileDialog.getFileNames();
            if (filenames.length == 0) {
                return;
            }
            ArrayList<Extractor.InputFile> files = new ArrayList<Extractor.InputFile>();
            String[] stringArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                files.add(new Extractor.InputFile(new File(fileDialog.getFilterPath(), filename)));
                ++n2;
            }
            ArrayList errors = new ArrayList();
            List items = extractor.extract(files, errors);
            HashMap<Extractor, List<Extractor.Item>> result = new HashMap<Extractor, List<Extractor.Item>>();
            result.put((Extractor)extractor, items);
            HashMap<File, List<Exception>> e = new HashMap<File, List<Exception>>();
            if (!errors.isEmpty()) {
                e.put(((Extractor.InputFile)files.get(0)).getFile(), errors);
            }
            IPreferenceStore preferences = ((PortfolioPart)part.getObject()).getPreferenceStore();
            ImportExtractedItemsWizard wizard = new ImportExtractedItemsWizard(client, preferences, result, e);
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
        }
        catch (IllegalArgumentException e) {
            PortfolioPlugin.log(e);
            MessageDialog.openError((Shell)shell, (String)Messages.LabelError, (String)e.getMessage());
        }
    }
}

