/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.inject.Named;
import name.abuchen.portfolio.model.Bookmark;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;
import name.abuchen.portfolio.ui.util.DesktopAPI;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class OpenBookmarksHandler {
    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, @Named(value="activeShell") Shell shell, SelectionService selectionService) {
        MenuHelper.getActiveClient(part).ifPresent(client -> this.openPopup(shell, selectionService, (Client)client));
    }

    private void openPopup(Shell shell, SelectionService selectionService, Client client) {
        Optional<SecuritySelection> selection = selectionService.getSelection(client);
        if (!selection.isPresent()) {
            return;
        }
        Security security = selection.get().getSecurity();
        ArrayList bookmarks = new ArrayList();
        client.getSettings().getBookmarks().stream().filter(b -> !b.isSeparator()).forEach(bookmarks::add);
        security.getCustomBookmarks().forEach(bookmarks::add);
        BookmarkPopup<Bookmark> popup = new BookmarkPopup<Bookmark>(shell, security.getName(), bookmarks, Bookmark::getLabel, bm -> DesktopAPI.browse(bm.constructURL(client, security)));
        popup.open();
    }

    public static class BookmarkPopup<T>
    extends PopupDialog {
        private List<T> items;
        private Function<T, String> label;
        private Consumer<T> action;

        public BookmarkPopup(Shell shell, String title, List<T> items, Function<T, String> label, Consumer<T> action) {
            super(shell, 8, true, false, false, false, false, title, null);
            this.items = items;
            this.label = label;
            this.action = action;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            boolean isWin32 = "win32".equals(SWT.getPlatform());
            GridLayoutFactory.fillDefaults().extendedMargins(isWin32 ? 0 : 3, 3, 2, 2).applyTo(composite);
            Composite tableComposite = new Composite(composite, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
            TableColumnLayout tableColumnLayout = new TableColumnLayout();
            tableComposite.setLayout((Layout)tableColumnLayout);
            TableViewer tableViewer = new TableViewer(tableComposite, 65556);
            tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            tableViewer.getTable().setHeaderVisible(false);
            tableViewer.getTable().setLinesVisible(false);
            TableViewerColumn tableColumn = new TableViewerColumn(tableViewer, 0);
            tableColumnLayout.setColumnData((Widget)tableColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(200));
            tableColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return label.apply(element);
                }
            });
            tableViewer.getTable().addSelectionListener(SelectionListener.widgetDefaultSelectedAdapter(e -> this.handleSelection(tableViewer.getStructuredSelection())));
            tableViewer.setInput(this.items);
            tableViewer.setSelection((ISelection)new StructuredSelection(this.items.get(0)));
            return composite;
        }

        protected void handleSelection(IStructuredSelection selection) {
            Object item = selection.getFirstElement();
            if (item != null) {
                this.action.accept(item);
            }
            this.close();
        }
    }
}

