/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.io.File;
import javax.inject.Named;
import name.abuchen.portfolio.ui.Messages;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class OpenFileHandler {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell, @Optional @Named(value="e4ActivePart") MPart activePart, MApplication app, EPartService partService, EModelService modelService) {
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterExtensions(new String[]{"*.xml;*.zip;*.portfolio", "*.*"});
        dialog.setFilterNames(new String[]{Messages.LabelPortfolioPerformanceFile, Messages.LabelAllFiles});
        String fileSelected = dialog.open();
        if (fileSelected != null) {
            MPart part = partService.createPart("name.abuchen.portfolio.ui.part.portfolio");
            part.setLabel(new File(fileSelected).getName());
            part.setTooltip(fileSelected);
            part.getPersistedState().put("file", fileSelected);
            if (activePart != null) {
                activePart.getParent().getChildren().add(part);
            } else {
                ((MPartStack)modelService.find("name.abuchen.portfolio.ui.partstack.main", (MUIElement)app)).getChildren().add(part);
            }
            part.setVisible(true);
            part.getParent().setVisible(true);
            partService.showPart(part, EPartService.PartState.ACTIVATE);
        }
    }
}

