/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import javax.inject.Named;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.preferences.AlphaVantagePreferencePage;
import name.abuchen.portfolio.ui.preferences.CalendarPreferencePage;
import name.abuchen.portfolio.ui.preferences.DivvyDiaryPreferencePage;
import name.abuchen.portfolio.ui.preferences.FinnhubPreferencePage;
import name.abuchen.portfolio.ui.preferences.FormattingPreferencePage;
import name.abuchen.portfolio.ui.preferences.GeneralPreferencePage;
import name.abuchen.portfolio.ui.preferences.LanguagePreferencePage;
import name.abuchen.portfolio.ui.preferences.PresentationPreferencePage;
import name.abuchen.portfolio.ui.preferences.ProxyPreferencePage;
import name.abuchen.portfolio.ui.preferences.QuandlPreferencePage;
import name.abuchen.portfolio.ui.preferences.ThemePreferencePage;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class OpenPreferenceDialogHandler {
    @Execute
    public void execute(@Named(value="activeShell") Shell shell, IThemeEngine themeEngine) {
        PreferenceManager pm = new PreferenceManager('/');
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new GeneralPreferencePage()));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("presentation", (IPreferencePage)new PresentationPreferencePage()));
        pm.addTo("presentation", (IPreferenceNode)new PreferenceNode("language", (IPreferencePage)new LanguagePreferencePage()));
        pm.addTo("presentation", (IPreferenceNode)new PreferenceNode("theme", (IPreferencePage)new ThemePreferencePage(themeEngine)));
        pm.addTo("presentation", (IPreferenceNode)new PreferenceNode("formatting", (IPreferencePage)new FormattingPreferencePage()));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("calendar", (IPreferencePage)new CalendarPreferencePage()));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("api", (IPreferencePage)new APIKeyPreferencePage()));
        pm.addTo("api", (IPreferenceNode)new PreferenceNode("alphavantage", (IPreferencePage)new AlphaVantagePreferencePage()));
        pm.addTo("api", (IPreferenceNode)new PreferenceNode("quandl", (IPreferencePage)new QuandlPreferencePage()));
        pm.addTo("api", (IPreferenceNode)new PreferenceNode("finnhub", (IPreferencePage)new FinnhubPreferencePage()));
        pm.addTo("api", (IPreferenceNode)new PreferenceNode("divvydiary", (IPreferencePage)new DivvyDiaryPreferencePage()));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("proxy", (IPreferencePage)new ProxyPreferencePage()));
        PreferenceDialog dialog = new PreferenceDialog(shell, pm){

            protected void configureShell(Shell newShell) {
                super.configureShell(newShell);
                newShell.setText(Messages.LabelSettings);
            }
        };
        dialog.setSelectedNode(null);
        dialog.setPreferenceStore(PortfolioPlugin.getDefault().getPreferenceStore());
        dialog.create();
        dialog.getTreeViewer().expandAll();
        dialog.open();
    }

    public static class APIKeyPreferencePage
    extends PreferencePage {
        public APIKeyPreferencePage() {
            this.setTitle(Messages.PrefTitleAPIKeys);
        }

        protected Control createContents(Composite parent) {
            return new Composite(parent, 0);
        }
    }
}

