/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.handlers;

import java.util.LinkedList;
import java.util.Optional;
import javax.inject.Named;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.handlers.MenuHelper;
import name.abuchen.portfolio.ui.util.swt.SashLayout;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ShowHideSidebarHandler {
    @CanExecute
    boolean canExecute(@Named(value="e4ActivePart") MPart part, MMenuItem menuItem) {
        Optional<SashLayout> sash = this.findChildWithSash(part);
        if (!sash.isPresent()) {
            return false;
        }
        menuItem.setLabel(sash.get().isHidden() ? Messages.MenuShowSidebar : Messages.MenuHideSidebar);
        return true;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        this.findChildWithSash(part).ifPresent(SashLayout::flip);
    }

    private Optional<SashLayout> findChildWithSash(MPart part) {
        if (!MenuHelper.getActiveClientInput(part, false).isPresent()) {
            return Optional.empty();
        }
        Object widget = part.getWidget();
        if (!(widget instanceof Composite)) {
            return Optional.empty();
        }
        LinkedList<Composite> stack = new LinkedList<Composite>();
        stack.add((Composite)widget);
        while (!stack.isEmpty()) {
            Composite subject = (Composite)stack.removeFirst();
            Layout layout = subject.getLayout();
            if (layout instanceof SashLayout) {
                return Optional.of((SashLayout)layout);
            }
            Control[] controlArray = subject.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control instanceof Composite) {
                    stack.add((Composite)control);
                }
                ++n2;
            }
        }
        return Optional.empty();
    }
}

