/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.jobs;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.checks.Checker;
import name.abuchen.portfolio.checks.Issue;
import name.abuchen.portfolio.checks.QuickFix;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.jobs.AbstractClientJob;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ConsistencyChecksJob
extends AbstractClientJob {
    private final boolean reportSuccess;

    public ConsistencyChecksJob(Client client, boolean reportSuccess) {
        super(client, Messages.JobMsgRunningConsistencyChecks);
        this.reportSuccess = reportSuccess;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.JobMsgRunningConsistencyChecks, 1);
        List issues = Checker.runAll((Client)this.getClient());
        if (issues.isEmpty()) {
            if (this.reportSuccess) {
                Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.LabelInfo, (String)Messages.MsgNoIssuesFound));
            }
        } else {
            Display.getDefault().asyncExec(() -> {
                SelectQuickFixDialog dialog = new SelectQuickFixDialog(Display.getCurrent().getActiveShell(), this.getClient(), issues);
                dialog.open();
            });
        }
        return Status.OK_STATUS;
    }

    public static class ReportedIssue {
        private Issue delegate;
        private List<QuickFix> fixes;
        private String fixedMessage;

        public ReportedIssue(Issue delegate) {
            this.delegate = delegate;
            this.fixes = delegate.getAvailableFixes();
        }

        public LocalDate getDate() {
            return this.delegate.getDate();
        }

        public Object getEntity() {
            return this.delegate.getEntity();
        }

        public Long getAmount() {
            return this.delegate.getAmount();
        }

        public String getLabel() {
            return this.delegate.getLabel();
        }

        public List<QuickFix> getAvailableFixes() {
            return this.fixes;
        }

        public void setFixedMessage(String message) {
            this.fixedMessage = message;
        }

        protected String getFixedMessage() {
            return this.fixedMessage;
        }

        public boolean isFixed() {
            return this.fixedMessage != null;
        }
    }

    private static class SelectQuickFixDialog
    extends TitleAreaDialog {
        private final Client client;
        private final List<ReportedIssue> issues;
        private Menu contextMenu;
        private TableViewer tableViewer;
        private ReportedIssue currentIssue;

        public SelectQuickFixDialog(Shell shell, Client client, List<Issue> issues) {
            super(shell);
            this.setTitleImage(Images.BANNER.image());
            this.client = client;
            this.issues = new ArrayList<ReportedIssue>();
            for (Issue issue : issues) {
                this.issues.add(new ReportedIssue(issue));
            }
        }

        protected void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle & 0xFFFEFFFF | 0x10);
            this.setBlockOnOpen(false);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 8, Messages.LabelRefresh, false);
        }

        protected Control createContents(Composite parent) {
            Control contents = super.createContents(parent);
            this.setTitle(Messages.DialogConsistencyChecksTitle);
            this.setMessage(Messages.DialogConssitencyChecksMessage);
            return contents;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.addDisposeListener(e -> this.widgetDisposed());
            Composite tableArea = new Composite(composite, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableArea);
            tableArea.setLayout((Layout)new FillLayout());
            TableColumnLayout layout = new TableColumnLayout();
            tableArea.setLayout((Layout)layout);
            this.tableViewer = new TableViewer(tableArea, 67584);
            final Table table = this.tableViewer.getTable();
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            TableViewerColumn col = new TableViewerColumn(this.tableViewer, 0);
            col.getColumn().setText(Messages.ColumnDate);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    LocalDate date = ((ReportedIssue)element).getDate();
                    return date != null ? Values.Date.format((Object)date) : null;
                }
            });
            layout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnPixelData(80));
            ColumnViewerSorter.create(ReportedIssue.class, "date").attachTo((ColumnViewer)this.tableViewer, (ViewerColumn)col, true);
            col = new TableViewerColumn(this.tableViewer, 0);
            col.getColumn().setText(Messages.ColumnEntity);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Object entity = ((ReportedIssue)element).getEntity();
                    if (entity instanceof Client) {
                        return Messages.LabelPortfolioPerformanceFile;
                    }
                    return entity.toString();
                }

                public Image getImage(Object element) {
                    ReportedIssue issue = (ReportedIssue)element;
                    return LogoManager.instance().getDefaultColumnImage(issue.getEntity(), client.getSettings());
                }
            });
            layout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnPixelData(100));
            ColumnViewerSorter.create(ReportedIssue.class, "entity").attachTo((ColumnViewer)this.tableViewer, (ViewerColumn)col);
            col = new TableViewerColumn(this.tableViewer, 131072);
            col.getColumn().setText(Messages.ColumnAmount);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    Long amount = ((ReportedIssue)element).getAmount();
                    return amount != null ? Values.Amount.format((Object)amount) : null;
                }
            });
            layout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnPixelData(80));
            ColumnViewerSorter.create(ReportedIssue.class, "amount").attachTo((ColumnViewer)this.tableViewer, (ViewerColumn)col);
            col = new TableViewerColumn(this.tableViewer, 0);
            col.getColumn().setText(Messages.ColumnIssue);
            col.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){

                protected void measure(Event event, Object element) {
                    ReportedIssue line = (ReportedIssue)element;
                    Point size = event.gc.textExtent(line.getLabel());
                    event.width = table.getColumn(event.index).getWidth();
                    event.width = size.x + 1;
                    event.height = size.y;
                }

                protected void paint(Event event, Object element) {
                    ReportedIssue entry = (ReportedIssue)element;
                    event.gc.drawText(entry.getLabel(), event.x, event.y, true);
                }
            });
            layout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnPixelData(300));
            ColumnViewerSorter.create(ReportedIssue.class, "label").attachTo((ColumnViewer)this.tableViewer, (ViewerColumn)col);
            col = new TableViewerColumn(this.tableViewer, 0);
            col.getColumn().setText(Messages.ColumnFix);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    ReportedIssue issue = (ReportedIssue)element;
                    return issue.isFixed() ? issue.getFixedMessage() : null;
                }

                public Image getImage(Object element) {
                    ReportedIssue issue = (ReportedIssue)element;
                    return issue.isFixed() ? Images.CHECK.image() : Images.QUICKFIX.image();
                }
            });
            layout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnPixelData(100));
            table.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    ReportedIssue issue;
                    Point point = new Point(e.x, e.y);
                    TableItem item = table.getItem(point);
                    if (item != null && item.getBounds(4).contains(point) && !(issue = (ReportedIssue)item.getData()).isFixed()) {
                        this.showContextMenu(issue);
                    }
                }
            });
            this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.tableViewer.setInput(this.issues);
            return composite;
        }

        protected void widgetDisposed() {
            if (this.contextMenu != null) {
                this.contextMenu.dispose();
            }
        }

        private void showContextMenu(ReportedIssue issue) {
            this.currentIssue = issue;
            if (this.contextMenu == null) {
                MenuManager menuMgr = new MenuManager("#PopupMenu");
                menuMgr.setRemoveAllWhenShown(true);
                menuMgr.addMenuListener(manager -> {
                    for (final QuickFix fix : this.currentIssue.getAvailableFixes()) {
                        if (fix == QuickFix.SEPARATOR) {
                            manager.add((IContributionItem)new Separator());
                            continue;
                        }
                        manager.add((IAction)new Action(fix.getLabel()){

                            public void run() {
                                fix.execute();
                                currentIssue.setFixedMessage(fix.getDoneLabel());
                                if (client != null) {
                                    client.markDirty();
                                }
                                tableViewer.refresh((Object)currentIssue);
                            }
                        });
                    }
                });
                this.contextMenu = menuMgr.createContextMenu((Control)this.getShell());
            }
            this.contextMenu.setVisible(true);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 8) {
                List list = Checker.runAll((Client)this.client);
                this.issues.clear();
                for (Issue issue : list) {
                    this.issues.add(new ReportedIssue(issue));
                }
                this.tableViewer.setInput(this.issues);
            } else {
                super.buttonPressed(buttonId);
            }
        }
    }
}

