/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.preferences;

import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.util.TradeCalendar;
import name.abuchen.portfolio.util.TradeCalendarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class CalendarPreferencePage
extends FieldEditorPreferencePage {
    private Label infoLabel;

    public CalendarPreferencePage() {
        super(1);
        this.setTitle(Messages.PrefTitleCalendar);
        this.setDescription(Messages.PrefMsgCalendar);
    }

    public void createFieldEditors() {
        List calendar = TradeCalendarManager.getAvailableCalendar().sorted().collect(Collectors.toList());
        String[][] entryNamesAndValues = new String[calendar.size()][2];
        int i = 0;
        for (TradeCalendar cal : calendar) {
            entryNamesAndValues[i] = this.getLabelAndValue(cal);
            ++i;
        }
        this.addField((FieldEditor)new ComboFieldEditor("CALENDAR", Messages.PrefTitleCalendar, entryNamesAndValues, this.getFieldEditorParent()));
        this.createInfo(this.getFieldEditorParent());
    }

    private String[] getLabelAndValue(TradeCalendar calendar) {
        return new String[]{calendar.getDescription(), calendar.getCode()};
    }

    protected void createInfo(Composite composite) {
        this.infoLabel = new Label(composite, 64);
        this.infoLabel.setText(this.createHolidayText(TradeCalendarManager.getDefaultInstance().getCode()));
        this.infoLabel.setFont(this.getFieldEditorParent().getFont());
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.infoLabel);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getProperty().equals("field_editor_value")) {
            String newCode = (String)event.getNewValue();
            this.infoLabel.setText(this.createHolidayText(newCode));
            this.infoLabel.getParent().getParent().layout(true);
        }
    }

    private String createHolidayText(String calendarCode) {
        TradeCalendar calendar = TradeCalendarManager.getInstance((String)calendarCode);
        if (calendar == null) {
            return "";
        }
        Collection holidays = calendar.getHolidays(LocalDate.now().getYear());
        StringBuilder buffer = new StringBuilder();
        holidays.stream().sorted((r, l) -> r.getDate().compareTo(l.getDate())).forEach(h -> {
            StringBuilder stringBuilder2 = buffer.append(Values.Date.format((Object)h.getDate())).append(" ").append(h.getLabel()).append("\n");
        });
        return buffer.toString();
    }
}

