/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.preferences;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Properties;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class LanguagePreferencePage
extends PreferencePage {
    private static final String OSGI_NL = "osgi.nl";
    private Properties userProperties = new Properties();
    private ComboViewer viewer;

    public LanguagePreferencePage() {
        this.setTitle(Messages.PrefTitleLanguage);
        this.setDescription(Messages.PrefMsgLanguageConfig);
        this.loadUserPreferences();
    }

    protected Control createContents(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(area);
        Label label = new Label(area, 0);
        label.setText(Messages.LabelLanguage);
        this.viewer = new ComboViewer(area, 8);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setInput((Object)Language.values());
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)Language.valueOfLocale(this.userProperties.getProperty(OSGI_NL))));
        return area;
    }

    public boolean performOk() {
        if (this.viewer == null) {
            return true;
        }
        Language language = (Language)((Object)((IStructuredSelection)this.viewer.getSelection()).getFirstElement());
        switch (language) {
            case AUTOMATIC: {
                this.userProperties.remove(OSGI_NL);
                break;
            }
            default: {
                this.userProperties.setProperty(OSGI_NL, language.getCode());
            }
        }
        this.storeUserPreferences();
        return true;
    }

    protected void performDefaults() {
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)Language.valueOfLocale(this.userProperties.getProperty(OSGI_NL))));
        super.performDefaults();
    }

    private Path getUserConfigFile() throws URISyntaxException {
        URL configArea = Platform.getConfigurationLocation().getURL();
        URI uri = new URI(configArea.toExternalForm().replace(" ", "%20"));
        return Paths.get(uri).resolve("config.ini");
    }

    private void loadUserPreferences() {
        block11: {
            try {
                Path userConfigFile = this.getUserConfigFile();
                if (!Files.exists(userConfigFile, new LinkOption[0])) break block11;
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream input = new FileInputStream(userConfigFile.toFile());){
                    this.userProperties.load(input);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | URISyntaxException e) {
                PortfolioPlugin.log(e);
            }
        }
    }

    private void storeUserPreferences() {
        try {
            Path userConfigFile = this.getUserConfigFile();
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream out = new FileOutputStream(userConfigFile.toFile());){
                this.userProperties.store(out, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.LabelError, (String)MessageFormat.format(Messages.MsgErrorSavingIniFile, e.getMessage()));
        }
    }

    public static enum Language {
        AUTOMATIC(null, Messages.LabelLanguageAutomatic),
        GERMAN("de", "Deutsch"),
        ENGLISH("en", "English"),
        SPANISH("es", "Espa\u00f1ol"),
        FRENCH("fr", "Fran\u00e7ais"),
        DUTCH("nl", "Nederlands"),
        PORTUGUESE("pt", "Portugu\u00eas");

        private String code;
        private String label;

        private Language(String code, String label) {
            this.code = code;
            this.label = label;
        }

        public String getCode() {
            return this.code;
        }

        public static Language valueOfLocale(String locale) {
            if (locale == null) {
                return AUTOMATIC;
            }
            String code = locale.substring(0, 2);
            Language[] languageArray = Language.values();
            int n = languageArray.length;
            int n2 = 0;
            while (n2 < n) {
                Language language = languageArray[n2];
                if (code.equals(language.getCode())) {
                    return language;
                }
                ++n2;
            }
            return AUTOMATIC;
        }

        public String toString() {
            return this.label;
        }
    }
}

