/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.theme;

import name.abuchen.portfolio.ui.util.chart.ScatterChart;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.ILegend;
import org.swtchart.ITitle;
import org.w3c.dom.css.CSSValue;

public class ChartCSSHandler
extends AbstractCSSPropertySWTHandler
implements ICSSPropertyHandler {
    private static final String BACKGROUND_COLOR = "background-color";
    private static final String AXIS_COLOR = "axis-color";
    private static final String GRID_COLOR = "grid-color";
    private static final String HIGHLIGHT_COLOR = "highlight-color";

    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof Chart)) {
            return;
        }
        Chart chart = (Chart)control;
        if (AXIS_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            ILegend legend;
            Color newColor = (Color)engine.convert(value, Color.class, (Object)control.getDisplay());
            IAxis[] iAxisArray = chart.getAxisSet().getAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                axis.getTitle().setForeground(newColor);
                axis.getTick().setForeground(newColor);
                ++n2;
            }
            ITitle title = chart.getTitle();
            if (title != null) {
                title.setForeground(newColor);
            }
            if ((legend = chart.getLegend()) != null) {
                legend.setForeground(newColor);
            }
        } else if (GRID_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)control.getDisplay());
            IAxis[] iAxisArray = chart.getAxisSet().getAxes();
            int n = iAxisArray.length;
            int legend = 0;
            while (legend < n) {
                IAxis axis = iAxisArray[legend];
                axis.getGrid().setForeground(newColor);
                ++legend;
            }
        } else if (chart instanceof ScatterChart && HIGHLIGHT_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            Color newColor = (Color)engine.convert(value, Color.class, (Object)control.getDisplay());
            ((ScatterChart)chart).setHighlightColor(newColor);
        } else if (BACKGROUND_COLOR.equalsIgnoreCase(property) && value.getCssValueType() == 1) {
            ILegend legend;
            Color newColor = (Color)engine.convert(value, Color.class, (Object)control.getDisplay());
            chart.setBackground(newColor);
            Composite plotArea = chart.getPlotArea();
            if (plotArea != null) {
                plotArea.setBackground(newColor);
            }
            if ((legend = chart.getLegend()) != null) {
                legend.setBackground(newColor);
            }
        }
    }

    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof Chart)) {
            return null;
        }
        Chart chart = (Chart)control;
        if (AXIS_COLOR.equalsIgnoreCase(property)) {
            ICSSValueConverter cssValueConverter = engine.getCSSValueConverter(String.class);
            return cssValueConverter.convert((Object)chart.getTitle().getForeground(), engine, null);
        }
        if (GRID_COLOR.equalsIgnoreCase(property)) {
            ICSSValueConverter cssValueConverter = engine.getCSSValueConverter(String.class);
            return cssValueConverter.convert((Object)chart.getAxisSet().getAxes()[0].getGrid().getForeground(), engine, null);
        }
        if (HIGHLIGHT_COLOR.equalsIgnoreCase(property) && chart instanceof ScatterChart) {
            ICSSValueConverter cssValueConverter = engine.getCSSValueConverter(String.class);
            return cssValueConverter.convert((Object)((ScatterChart)chart).getHighlightColor(), engine, null);
        }
        if (BACKGROUND_COLOR.equalsIgnoreCase(property)) {
            ICSSValueConverter cssValueConverter = engine.getCSSValueConverter(String.class);
            return cssValueConverter.convert((Object)chart.getPlotArea().getBackground(), engine, null);
        }
        return null;
    }
}

