/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.update;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;

class NewVersion {
    private static final String VERSION_MARKER = "-- ";
    private String version;
    private String minimumJavaVersionRequired;
    private String header;
    private List<Release> releases = new ArrayList<Release>();
    private List<ConditionalMessage> preventUpdateIf = new ArrayList<ConditionalMessage>();

    public NewVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String get32BitWarning() {
        boolean is64bit;
        if (!"win32".equals(Platform.getOS())) {
            return null;
        }
        if ("x86_64".equals(Platform.getOSArch())) {
            return null;
        }
        boolean bl = is64bit = System.getenv("ProgramFiles(x86)") != null;
        if (!is64bit) {
            return null;
        }
        return Messages.MsgUpdateRunning32BitOn64BitOS;
    }

    public void setVersionHistory(String history) {
        if (history == null) {
            return;
        }
        String[] lines = history.split("\\r?\\n");
        Release release = new Release(null);
        ConditionalMessage conditionalMessage = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(VERSION_MARKER)) {
                try {
                    Version v = new Version(line.substring(VERSION_MARKER.length()));
                    release = new Release(v);
                    conditionalMessage = null;
                    this.releases.add(release);
                }
                catch (IllegalArgumentException e) {
                    PortfolioPlugin.log(e);
                    release = new Release(new Version(99, 0, 0));
                    this.releases.add(release);
                }
            } else if (line.startsWith("~~ (")) {
                try {
                    String condition = line.substring(3);
                    conditionalMessage = new ConditionalMessage(condition);
                    release.messages.add(conditionalMessage);
                }
                catch (RuntimeException e) {
                    PortfolioPlugin.log(e);
                }
            } else if (line.startsWith("~~")) {
                String text = line.substring(Math.min(3, line.length()));
                if (conditionalMessage != null) {
                    conditionalMessage.lines.add(text);
                } else {
                    release.lines.add(text);
                }
            } else {
                release.lines.add(line);
            }
            ++n2;
        }
        Collections.sort(this.releases, (r, l) -> l.version.compareTo(r.version));
    }

    public List<Release> getReleases() {
        return this.releases;
    }

    public void setMinimumJavaVersionRequired(String minimumJavaVersionRequired) {
        this.minimumJavaVersionRequired = minimumJavaVersionRequired;
    }

    public boolean requiresNewJavaVersion() {
        if (this.minimumJavaVersionRequired == null) {
            return false;
        }
        Bundle[] bundles = PortfolioPlugin.getDefault().getBundle().getBundleContext().getBundles();
        int ii = 0;
        while (ii < bundles.length) {
            if (bundles[ii].getSymbolicName().startsWith("name.abuchen.zulu.jre")) {
                return false;
            }
            ++ii;
        }
        double current = Double.parseDouble(System.getProperty("java.specification.version"));
        double required = Double.parseDouble(this.minimumJavaVersionRequired);
        return required > current;
    }

    public void addPreventUpdateCondition(String condition) {
        try {
            this.preventUpdateIf.add(new ConditionalMessage(condition));
        }
        catch (RuntimeException e) {
            PortfolioPlugin.log(e);
        }
    }

    public boolean doPreventUpdate() {
        if (this.preventUpdateIf.isEmpty()) {
            return false;
        }
        for (ConditionalMessage test : this.preventUpdateIf) {
            if (!test.isApplicable()) continue;
            return true;
        }
        return false;
    }

    static class ConditionalMessage {
        private List<Expression> expressions = new ArrayList<Expression>();
        private List<String> lines = new ArrayList<String>();

        public ConditionalMessage(String condition) {
            String[] all;
            String[] stringArray = all = condition.substring(1, condition.length() - 1).split("&");
            int n = all.length;
            int n2 = 0;
            while (n2 < n) {
                String expr = stringArray[n2];
                int p = expr.indexOf(61);
                if (p > 0) {
                    this.expressions.add(new Expression(expr.substring(0, p), expr.substring(p + 1)));
                } else {
                    PortfolioPlugin.log(MessageFormat.format("Invalid update expression ''{0}'' in condition ''{1}''", expr, condition));
                }
                ++n2;
            }
            if (this.expressions.isEmpty()) {
                throw new IllegalArgumentException(MessageFormat.format("No update expressions found for ''{0}''", condition));
            }
        }

        public boolean isApplicable() {
            if (this.expressions.isEmpty()) {
                return false;
            }
            for (Expression e : this.expressions) {
                if (e.isApplicable()) continue;
                return false;
            }
            return true;
        }

        public List<String> getLines() {
            return this.lines;
        }
    }

    static class Expression {
        private String property;
        private Pattern pattern;

        public Expression(String property, String pattern) {
            this.property = property;
            this.pattern = Pattern.compile(pattern);
        }

        public boolean isApplicable() {
            if ("$bundle.list".equals(this.property)) {
                Bundle[] bundleArray = PortfolioPlugin.getDefault().getBundle().getBundleContext().getBundles();
                int n = bundleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Bundle bundle = bundleArray[n2];
                    if (this.pattern.matcher(bundle.getSymbolicName()).matches()) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            if ("$version".equals(this.property)) {
                String value = FrameworkUtil.getBundle(NewVersion.class).getVersion().toString();
                return this.pattern.matcher(value).matches();
            }
            String value = System.getProperty(this.property);
            if (value == null) {
                return false;
            }
            return this.pattern.matcher(value).matches();
        }
    }

    static class Release {
        private Version version;
        private List<String> lines = new ArrayList<String>();
        private List<ConditionalMessage> messages = new ArrayList<ConditionalMessage>();

        public Release(Version version) {
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }

        public List<String> getLines() {
            return this.lines;
        }

        public List<ConditionalMessage> getMessages() {
            return this.messages;
        }
    }
}

