/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.util.function.Consumer;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.ClientFilterMenu;
import name.abuchen.portfolio.ui.util.DropDown;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;

public final class ClientFilterDropDown
extends DropDown
implements IMenuListener {
    private ClientFilterMenu menu;

    public ClientFilterDropDown(Client client, IPreferenceStore preferences, String prefKey, Consumer<ClientFilter> listener) {
        super(Messages.MenuChooseClientFilter, Images.FILTER_OFF, 0);
        this.setMenuListener(this);
        this.menu = new ClientFilterMenu(client, preferences, listener);
        this.menu.addListener(filter -> this.setImage(this.menu.hasActiveFilter() ? Images.FILTER_ON : Images.FILTER_OFF));
        String selection = preferences.getString(String.valueOf(prefKey) + "-client-filter");
        if (selection != null) {
            this.menu.getAllItems().filter(item -> item.getUUIDs().equals(selection)).findAny().ifPresent(item -> {
                this.menu.select((ClientFilterMenu.Item)item);
                this.setImage(this.menu.hasActiveFilter() ? Images.FILTER_ON : Images.FILTER_OFF);
            });
        }
        this.addDisposeListener(e -> preferences.putValue(String.valueOf(prefKey) + "-client-filter", this.menu.getSelectedItem().getUUIDs()));
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.menu.menuAboutToShow(manager);
    }

    public ClientFilter getSelectedFilter() {
        return this.menu.getSelectedFilter();
    }

    public boolean hasActiveFilter() {
        return this.menu.hasActiveFilter();
    }
}

