/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.ConfigurationSet;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.ConfirmAction;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.SimpleAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;

public class ConfigurationStore {
    private static final String KEY_ACTIVE = "$picked";
    private final String identifier;
    private final Client client;
    private final IPreferenceStore preferences;
    private final List<ConfigurationStoreOwner> listeners = new ArrayList<ConfigurationStoreOwner>();
    private final ConfigurationSet configSet;
    private ConfigurationSet.Configuration active;

    public ConfigurationStore(String identifier, Client client, IPreferenceStore preferences, ConfigurationStoreOwner listener) {
        this.identifier = identifier;
        this.client = client;
        this.preferences = preferences;
        this.listeners.add(listener);
        this.configSet = client.getSettings().getConfigurationSet(identifier);
        this.active = this.configSet.lookup(preferences.getString(String.valueOf(identifier) + KEY_ACTIVE)).orElseGet(() -> this.configSet.getConfigurations().findFirst().orElseGet(() -> {
            ConfigurationSet.Configuration defaultConfig = new ConfigurationSet.Configuration(Messages.ConfigurationStandard, null);
            this.configSet.add(defaultConfig);
            return defaultConfig;
        }));
        preferences.setValue(String.valueOf(identifier) + KEY_ACTIVE, this.active.getUUID());
    }

    public void setToolBarManager(final ToolBarManager toolBar) {
        this.createToolBarItems(toolBar);
        toolBar.update(true);
        this.listeners.add(new ConfigurationStoreOwner(){

            @Override
            public void onConfigurationPicked(String data) {
                this.onConfigurationSetUpdated();
            }

            @Override
            public void beforeConfigurationPicked() {
            }

            @Override
            public void onConfigurationSetUpdated() {
                if (toolBar.getControl().isDisposed()) {
                    return;
                }
                toolBar.removeAll();
                ConfigurationStore.this.createToolBarItems(toolBar);
                toolBar.update(true);
            }
        });
    }

    private void createToolBarItems(ToolBarManager toolBar) {
        this.configSet.getConfigurations().forEach(config -> {
            DropDown item = new DropDown(config.getName(), config.equals(this.active) ? Images.VIEW_SELECTED : Images.VIEW);
            item.setMenuListener(manager -> {
                if (!config.equals(this.active)) {
                    manager.add((IAction)new SimpleAction(Messages.MenuShow, a -> this.activate((ConfigurationSet.Configuration)config)));
                    manager.add((IContributionItem)new Separator());
                }
                manager.add((IAction)new SimpleAction(Messages.ConfigurationDuplicate, a -> this.createNew((ConfigurationSet.Configuration)config)));
                manager.add((IAction)new SimpleAction(Messages.ConfigurationRename, a -> this.rename((ConfigurationSet.Configuration)config)));
                manager.add((IAction)new ConfirmAction(Messages.ConfigurationDelete, MessageFormat.format(Messages.ConfigurationDeleteConfirm, config.getName()), a -> this.delete((ConfigurationSet.Configuration)config)));
                int index = this.configSet.indexOf(config);
                if (index > 0) {
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new SimpleAction(Messages.ChartBringToFront, a -> {
                        this.configSet.remove(config);
                        this.configSet.add(0, config);
                        toolBar.removeAll();
                        this.createToolBarItems(toolBar);
                        toolBar.update(true);
                    }));
                }
            });
            item.setDefaultAction((IAction)new SimpleAction(a -> this.activate((ConfigurationSet.Configuration)config)));
            toolBar.add((IContributionItem)item);
        });
        SimpleAction createNew = new SimpleAction(a -> this.createNew(null));
        createNew.setImageDescriptor(Images.VIEW_PLUS.descriptor());
        createNew.setToolTipText(Messages.ConfigurationNew);
        toolBar.add((IAction)createNew);
    }

    private void createNew(ConfigurationSet.Configuration template) {
        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ConfigurationNew, Messages.ChartSeriesPickerDialogMsg, template != null ? template.getName() : null, (IInputValidator)new InputValidator());
        if (dlg.open() != 0) {
            return;
        }
        String name = dlg.getValue();
        this.listeners.forEach(ConfigurationStoreOwner::beforeConfigurationPicked);
        this.active = new ConfigurationSet.Configuration(name, template != null ? template.getData() : null);
        this.configSet.add(this.active);
        this.client.touch();
        this.preferences.setValue(String.valueOf(this.identifier) + KEY_ACTIVE, this.active.getUUID());
        this.listeners.forEach(l -> l.onConfigurationPicked(this.active.getData()));
    }

    private void rename(ConfigurationSet.Configuration config) {
        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ConfigurationRename, Messages.ChartSeriesPickerDialogMsg, config.getName(), (IInputValidator)new InputValidator());
        if (dlg.open() != 0) {
            return;
        }
        config.setName(dlg.getValue());
        this.client.touch();
        this.listeners.forEach(ConfigurationStoreOwner::onConfigurationSetUpdated);
    }

    private void delete(ConfigurationSet.Configuration config) {
        this.configSet.remove(config);
        if (this.active != config) {
            this.listeners.forEach(ConfigurationStoreOwner::onConfigurationSetUpdated);
            return;
        }
        this.listeners.forEach(ConfigurationStoreOwner::beforeConfigurationPicked);
        this.active = this.configSet.getConfigurations().findAny().orElseGet(() -> {
            ConfigurationSet.Configuration defaultConfig = new ConfigurationSet.Configuration(Messages.ConfigurationStandard, null);
            this.configSet.add(defaultConfig);
            return defaultConfig;
        });
        this.preferences.setValue(String.valueOf(this.identifier) + KEY_ACTIVE, this.active.getUUID());
        this.listeners.forEach(l -> l.onConfigurationPicked(this.active.getData()));
    }

    private void activate(ConfigurationSet.Configuration config) {
        this.listeners.forEach(ConfigurationStoreOwner::beforeConfigurationPicked);
        this.active = config;
        this.preferences.setValue(String.valueOf(this.identifier) + KEY_ACTIVE, this.active.getUUID());
        this.listeners.forEach(l -> l.onConfigurationPicked(config.getData()));
    }

    public void updateActive(String data) {
        if (!Objects.equals(data, this.active.getData())) {
            this.active.setData(data);
            this.client.touch();
        }
    }

    public String getActive() {
        return this.active.getData();
    }

    public String getActiveName() {
        return this.active.getName();
    }

    public String getActiveUUID() {
        return this.active.getUUID();
    }

    public void insertMigratedConfiguration(String data) {
        this.active = new ConfigurationSet.Configuration(Messages.ConfigurationStandard, data);
        this.configSet.add(this.active);
        this.preferences.setValue(String.valueOf(this.identifier) + KEY_ACTIVE, this.active.getUUID());
        this.client.touch();
    }

    public static interface ConfigurationStoreOwner {
        public void beforeConfigurationPicked();

        public void onConfigurationPicked(String var1);

        default public void onConfigurationSetUpdated() {
        }
    }

    private static final class InputValidator
    implements IInputValidator {
        private InputValidator() {
        }

        public String isValid(String newText) {
            return newText == null || newText.trim().isEmpty() ? Messages.ConfigurationErrorMissingValue : null;
        }
    }
}

