/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ConfirmActionWithSelection
extends Action {
    private final String singleSelectionMessage;
    private final String multiSelectionMessage;
    private final IStructuredSelection selection;
    private final Runnable runnable;

    public ConfirmActionWithSelection(String title, String singleSelectionMessage, String multiSelectionMessage, IStructuredSelection selection, Runnable runnable) {
        super(title);
        this.singleSelectionMessage = singleSelectionMessage;
        this.multiSelectionMessage = multiSelectionMessage;
        this.selection = selection;
        this.runnable = runnable;
    }

    public void run() {
        if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)this.getText(), (String)this.getMessageForSelection())) {
            this.runnable.run(this.selection, this);
        }
    }

    private String getMessageForSelection() {
        return this.selection.size() > 1 ? MessageFormat.format((String)this.multiSelectionMessage, (Object[])new Object[]{this.selection.size()}) : this.singleSelectionMessage;
    }

    @FunctionalInterface
    public static interface Runnable {
        public void run(IStructuredSelection var1, Action var2);
    }
}

