/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class FormDataFactory {
    private Control reference;

    public static FormDataFactory startingWith(Control reference, Label label) {
        FormDataFactory factory = new FormDataFactory(reference);
        factory.label(label);
        FormData data = factory.from(reference);
        data.left = new FormAttachment((Control)label, 5);
        return factory;
    }

    public static FormDataFactory startingWith(Control reference) {
        return new FormDataFactory(reference);
    }

    private FormDataFactory(Control reference) {
        this.reference = reference;
    }

    public FormDataFactory thenBelow(Control control) {
        return this.thenBelow(control, 5);
    }

    public FormDataFactory thenBelow(Control control, int offset) {
        FormData data = this.from(control);
        data.top = new FormAttachment(this.reference, offset);
        data.left = new FormAttachment(this.reference, 0, 16384);
        return new FormDataFactory(control);
    }

    public FormDataFactory thenUp(Control control) {
        return this.thenUp(control, 5);
    }

    public FormDataFactory thenUp(Control control, int offset) {
        FormData data = this.from(control);
        data.bottom = new FormAttachment(this.reference, -offset);
        data.left = new FormAttachment(this.reference, 0, 16384);
        return new FormDataFactory(control);
    }

    public FormDataFactory thenRight(Control control) {
        return this.thenRight(control, 5);
    }

    public FormDataFactory thenRight(Control control, int offset) {
        FormData data = this.from(control);
        data.top = new FormAttachment(this.reference, 0, 0x1000000);
        data.left = new FormAttachment(this.reference, offset);
        return new FormDataFactory(control);
    }

    public FormDataFactory thenLeft(Control control) {
        FormData data = this.from(control);
        data.top = new FormAttachment(this.reference, 0, 0x1000000);
        data.right = new FormAttachment(this.reference, -5);
        return new FormDataFactory(control);
    }

    public FormDataFactory label(Label label) {
        FormData data = this.from((Control)label);
        data.top = new FormAttachment(this.reference, 0, 0x1000000);
        data.right = new FormAttachment(this.reference, -5);
        return this;
    }

    public FormDataFactory suffix(Label label) {
        return this.suffix(label, -1);
    }

    public FormDataFactory suffix(Label label, int width) {
        FormData data = this.from((Control)label);
        data.top = new FormAttachment(this.reference, 0, 0x1000000);
        data.left = new FormAttachment(this.reference, 5);
        data.right = new FormAttachment(100);
        data.width = width;
        return this;
    }

    public FormDataFactory suffix(Control suffix) {
        FormData data = this.from(suffix);
        data.top = new FormAttachment(this.reference, 0, 0x1000000);
        data.left = new FormAttachment(this.reference, 5);
        return this;
    }

    public FormDataFactory width(int width) {
        FormData data = this.from(this.reference);
        data.width = width;
        return this;
    }

    public FormDataFactory height(int height) {
        FormData data = this.from(this.reference);
        data.height = height;
        return this;
    }

    public FormDataFactory top(FormAttachment attachment) {
        FormData data = this.from(this.reference);
        data.top = attachment;
        return this;
    }

    public FormDataFactory left(Control control) {
        FormData data = this.from(this.reference);
        data.left = new FormAttachment(control, 0, 16384);
        return this;
    }

    public FormDataFactory left(FormAttachment attachment) {
        FormData data = this.from(this.reference);
        data.left = attachment;
        return this;
    }

    public FormDataFactory right(Control control) {
        FormData data = this.from(this.reference);
        data.right = new FormAttachment(control, 0, 131072);
        return this;
    }

    public FormDataFactory right(FormAttachment attachment) {
        FormData data = this.from(this.reference);
        data.right = attachment;
        return this;
    }

    public FormDataFactory bottom(FormAttachment attachment) {
        FormData data = this.from(this.reference);
        data.bottom = attachment;
        return this;
    }

    private FormData from(Control control) {
        FormData layoutData = (FormData)control.getLayoutData();
        if (layoutData == null) {
            layoutData = new FormData();
            control.setLayoutData((Object)layoutData);
        }
        return layoutData;
    }
}

