/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.util.Optional;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.ClientSettings;
import name.abuchen.portfolio.model.ImageManager;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Images;
import org.eclipse.swt.graphics.Image;

public final class LogoManager {
    private static LogoManager instance = new LogoManager();

    public static LogoManager instance() {
        return instance;
    }

    private LogoManager() {
    }

    public Image getDefaultColumnImage(Object object, ClientSettings settings) {
        Image logo = this.getLogoImage(object, settings);
        return logo != null ? logo : this.getFallbackColumnImage(object);
    }

    private Image getLogoImage(Object object, ClientSettings settings) {
        if (object instanceof Attributable) {
            Attributable target = (Attributable)object;
            Optional logoAttr = settings.getOptionalLogoAttributeType(target.getClass());
            Image logo = logoAttr.isPresent() ? ImageManager.instance().getImage(target, (AttributeType)logoAttr.get()) : null;
            return logo;
        }
        return null;
    }

    private Image getFallbackColumnImage(Object object) {
        if (object instanceof Account) {
            return Images.ACCOUNT.image();
        }
        if (object instanceof Security) {
            return ((Security)object).isRetired() ? Images.SECURITY_RETIRED.image() : Images.SECURITY.image();
        }
        if (object instanceof Portfolio) {
            return Images.PORTFOLIO.image();
        }
        if (object instanceof InvestmentPlan) {
            return Images.INVESTMENTPLAN.image();
        }
        if (object instanceof Classification) {
            return Images.CATEGORY.image();
        }
        return null;
    }
}

