/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;

public class SimpleDateTimeDateSelectionProperty
extends WidgetValueProperty<Control, LocalDate> {
    public SimpleDateTimeDateSelectionProperty() {
        super(13);
    }

    public Object getValueType() {
        return LocalDate.class;
    }

    protected LocalDate doGetValue(Control source) {
        if (source instanceof DateTime) {
            DateTime dateTime = (DateTime)source;
            return LocalDate.of(dateTime.getYear(), dateTime.getMonth() + 1, dateTime.getDay());
        }
        if (source instanceof CDateTime) {
            Date date = ((CDateTime)source).getSelection();
            LocalDate now = LocalDate.now();
            if (date == null) {
                this.doSetValue(source, now);
                return now;
            }
            return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).toLocalDate();
        }
        throw new UnsupportedOperationException();
    }

    protected void doSetValue(Control source, LocalDate date) {
        if (source instanceof DateTime) {
            DateTime dateTime = (DateTime)source;
            dateTime.setDate(date.getYear(), date.getMonthValue() - 1, date.getDayOfMonth());
        } else if (source instanceof CDateTime) {
            CDateTime dateTime = (CDateTime)source;
            dateTime.setSelection(Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

