/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import com.ibm.icu.util.Calendar;
import java.time.LocalTime;
import java.util.Date;
import org.eclipse.jface.databinding.swt.WidgetValueProperty;
import org.eclipse.nebula.widgets.cdatetime.CDateTime;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;

public class SimpleDateTimeTimeSelectionProperty
extends WidgetValueProperty<Control, LocalTime> {
    public SimpleDateTimeTimeSelectionProperty() {
        super(13);
    }

    public Object getValueType() {
        return LocalTime.class;
    }

    protected LocalTime doGetValue(Control source) {
        if (source instanceof DateTime) {
            DateTime dateTime = (DateTime)source;
            return LocalTime.of(dateTime.getHours(), dateTime.getMinutes(), dateTime.getSeconds());
        }
        if (source instanceof CDateTime) {
            CDateTime dateTime = (CDateTime)source;
            Date date = dateTime.getSelection();
            if (date == null) {
                this.doSetValue(source, LocalTime.MIDNIGHT);
                return LocalTime.MIDNIGHT;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return LocalTime.of(calendar.get(11), calendar.get(12));
        }
        throw new UnsupportedOperationException();
    }

    protected void doSetValue(Control source, LocalTime date) {
        if (source instanceof DateTime) {
            DateTime dateTime = (DateTime)source;
            dateTime.setTime(date.getHour(), date.getMinute(), date.getSecond());
        } else if (source instanceof CDateTime) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, date.getHour());
            calendar.set(12, date.getMinute());
            calendar.set(13, 0);
            CDateTime dateTime = (CDateTime)source;
            dateTime.setSelection(calendar.getTime());
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

