/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.IValidatingConverter;

public class StringToCurrencyConverter
implements IValidatingConverter<String, Long> {
    private final Pattern pattern;
    private final NumberFormat full;
    private final int factor;

    public StringToCurrencyConverter(Values<?> type) {
        this(type, false);
    }

    public StringToCurrencyConverter(Values<?> type, boolean acceptNegativeValues) {
        this.factor = type.factor();
        StringBuilder patternString = new StringBuilder();
        patternString.append("^(");
        if (acceptNegativeValues) {
            patternString.append("-?");
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        patternString.append("[\\d").append(symbols.getGroupingSeparator()).append("]*)(").append(symbols.getDecimalSeparator()).append("(\\d*))?$");
        this.pattern = Pattern.compile(patternString.toString());
        this.full = new DecimalFormat("#,###");
    }

    public Object getFromType() {
        return String.class;
    }

    public Object getToType() {
        return Long.TYPE;
    }

    public Long convert(String fromObject) {
        String value = fromObject.trim();
        try {
            long result = 0L;
            String[] stringArray = value.split("\\+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                result += this.convertToLong(part.trim());
                ++n2;
            }
            return result;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private long convertToLong(String part) throws ParseException {
        Matcher m = this.pattern.matcher(String.valueOf(part));
        if (!m.matches()) {
            throw new IllegalArgumentException(String.format(Messages.CellEditor_NotANumber, part));
        }
        String strBefore = m.group(1);
        Long before = strBefore.trim().length() > 0 ? (Number)this.full.parse(strBefore) : (Number)0L;
        boolean isNegative = strBefore.contains("-");
        String strAfter = m.group(3);
        long after = 0L;
        if (strAfter != null && strAfter.length() > 0) {
            int length = (int)Math.log10(this.factor);
            if (strAfter.length() > length) {
                strAfter = strAfter.substring(0, length);
            }
            after = Long.parseLong(strAfter);
            int ii = strAfter.length();
            while (ii < length) {
                after *= 10L;
                ++ii;
            }
        }
        return before * (long)this.factor + (isNegative ? -after : after);
    }
}

