/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.util.Comparator;
import java.util.List;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.swt.widgets.Shell;

public class Column {
    private String id;
    private String label;
    private int style;
    private int defaultWidth;
    private boolean isVisible = true;
    private boolean isRemovable = true;
    private ColumnViewerSorter sorter;
    private Integer defaultSortDirection;
    private CellLabelProvider labelProvider;
    private Images image;
    private Options<Object> options;
    private String groupLabel;
    private String menuLabel;
    private String description;
    private ColumnEditingSupport editingSupport;

    public Column(String label, int style, int defaultWidth) {
        this(null, label, style, defaultWidth);
    }

    public Column(String id, String label, int style, int defaultWidth) {
        this.id = id;
        this.label = label;
        this.style = style;
        this.defaultWidth = defaultWidth;
    }

    String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void setRemovable(boolean isRemovable) {
        this.isRemovable = isRemovable;
    }

    public void setSorter(ColumnViewerSorter sorter) {
        this.sorter = sorter;
    }

    public void setComparator(Comparator<Object> comparator) {
        this.sorter = ColumnViewerSorter.create(comparator);
    }

    public void setSorter(ColumnViewerSorter sorter, int direction) {
        this.setSorter(sorter);
        this.defaultSortDirection = direction;
    }

    public void setLabelProvider(CellLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void setImage(Images image) {
        this.image = image;
    }

    public void setOptions(Options<?> options) {
        this.options = options;
    }

    public void setGroupLabel(String groupLabel) {
        this.groupLabel = groupLabel;
    }

    public void setMenuLabel(String menuLabel) {
        this.menuLabel = menuLabel;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEditingSupport(ColumnEditingSupport editingSupport) {
        this.editingSupport = editingSupport;
    }

    String getLabel() {
        return this.label;
    }

    String getMenuLabel() {
        return this.menuLabel != null ? this.menuLabel : this.label;
    }

    String getDescription() {
        return this.description;
    }

    int getStyle() {
        return this.style;
    }

    protected void setStyle(int style) {
        this.style = style;
    }

    int getDefaultWidth() {
        return this.defaultWidth;
    }

    boolean isVisible() {
        return this.isVisible;
    }

    boolean isRemovable() {
        return this.isRemovable;
    }

    public ColumnViewerSorter getSorter() {
        return this.sorter;
    }

    Integer getDefaultSortDirection() {
        return this.defaultSortDirection;
    }

    public CellLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    Images getImage() {
        return this.image;
    }

    boolean hasOptions() {
        return this.options != null;
    }

    Options<Object> getOptions() {
        return this.options;
    }

    String getGroupLabel() {
        return this.groupLabel;
    }

    public ColumnEditingSupport getEditingSupport() {
        return this.editingSupport;
    }

    public static interface Options<E> {
        public List<E> getOptions();

        public E valueOf(String var1);

        public String toString(E var1);

        public String getColumnLabel(E var1);

        public String getMenuLabel(E var1);

        public String getDescription(E var1);

        public boolean canCreateNewOptions();

        public E createNewOption(Shell var1);
    }
}

