/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.ui.util.viewers.Column;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.widgets.Composite;

public abstract class ColumnEditingSupport {
    private List<ModificationListener> listeners;

    public CellEditor createEditor(Composite composite) {
        return new TextCellEditor(composite);
    }

    public boolean canEdit(Object element) {
        return true;
    }

    public void prepareEditor(Object element) {
    }

    public abstract Object getValue(Object var1) throws Exception;

    public abstract void setValue(Object var1, Object var2) throws Exception;

    public final ColumnEditingSupport addListener(ModificationListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ModificationListener>();
        }
        this.listeners.add(listener);
        return this;
    }

    public final void attachTo(Column column) {
        column.setEditingSupport(this);
    }

    protected final void notify(Object element, Object newValue, Object oldValue) {
        if (this.listeners != null) {
            for (ModificationListener listener : this.listeners) {
                listener.onModified(element, newValue, oldValue);
            }
        }
    }

    public static void prepare(ColumnViewer viewer) {
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy(viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        int feature = 58;
        if (viewer instanceof TableViewer) {
            TableViewerEditor.create((TableViewer)((TableViewer)viewer), null, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)feature);
        } else if (viewer instanceof TreeViewer) {
            TreeViewerEditor.create((TreeViewer)((TreeViewer)viewer), (ColumnViewerEditorActivationStrategy)activationStrategy, (int)feature);
        }
    }

    @FunctionalInterface
    public static interface ModificationListener {
        public void onModified(Object var1, Object var2, Object var3);
    }

    public static class TouchClientListener
    implements ModificationListener {
        private final Client client;

        public TouchClientListener(Client client) {
            this.client = client;
        }

        @Override
        public void onModified(Object element, Object newValue, Object oldValue) {
            this.client.touch();
        }
    }
}

