/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.io.IOException;
import name.abuchen.portfolio.model.AttributeType;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.viewers.AttributeEditingSupport;
import name.abuchen.portfolio.util.ImageUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImageAttributeEditingSupport
extends AttributeEditingSupport {
    public ImageAttributeEditingSupport(AttributeType attribute) {
        super(attribute);
        if (!(attribute.getConverter() instanceof AttributeType.ImageConverter)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public CellEditor createEditor(Composite composite) {
        return new FileDialogCellEditor(composite);
    }

    static class FileDialogCellEditor
    extends DialogCellEditor {
        public FileDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected void updateContents(Object value) {
        }

        protected Button createButton(Composite parent) {
            Button button = super.createButton(parent);
            button.setText("...");
            return button;
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            FileDialog dial = new FileDialog(Display.getCurrent().getActiveShell());
            String filename = dial.open();
            if (filename != null) {
                try {
                    return ImageUtil.loadAndPrepare((String)filename, (int)64, (int)64);
                }
                catch (IOException ex) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.LabelInfo, (String)ex.getMessage());
                }
            }
            return null;
        }
    }
}

