/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.util.Optional;
import java.util.function.Function;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.trail.Trail;
import name.abuchen.portfolio.snapshot.trail.TrailProvider;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.util.Colors;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public final class MoneyColorLabelProvider
extends ColumnLabelProvider {
    private final Function<Object, Money> valueProvider;
    private final Function<Object, String> toolTipProvider;
    private final Client client;

    public MoneyColorLabelProvider(Function<Object, Money> valueProvider, Client client) {
        this(valueProvider, null, client);
    }

    public MoneyColorLabelProvider(Function<Object, Money> valueProvider, Function<Object, String> toolTipProvider, Client client) {
        this.valueProvider = valueProvider;
        this.toolTipProvider = toolTipProvider;
        this.client = client;
    }

    public Color getForeground(Object element) {
        Money money = this.valueProvider.apply(element);
        if (money == null || money.isZero()) {
            return null;
        }
        return money.getAmount() >= 0L ? Colors.theme().greenForeground() : Colors.theme().redForeground();
    }

    public Image getImage(Object element) {
        Money money = this.valueProvider.apply(element);
        if (money == null || money.isZero()) {
            return null;
        }
        return money.getAmount() >= 0L ? Images.GREEN_ARROW.image() : Images.RED_ARROW.image();
    }

    public String getText(Object element) {
        Money money = this.valueProvider.apply(element);
        if (money == null) {
            return null;
        }
        return Values.Money.format(money, this.client.getBaseCurrency());
    }

    public String getToolTipText(Object element) {
        if (this.toolTipProvider == null) {
            return null;
        }
        String tooltip = this.toolTipProvider.apply(element);
        if (!(element instanceof TrailProvider)) {
            return tooltip;
        }
        TrailProvider t = (TrailProvider)element;
        Optional trail = t.explain(tooltip);
        if (!trail.isPresent() || ((Trail)trail.get()).getRecord().isEmpty()) {
            return null;
        }
        return tooltip;
    }
}

