/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.time.Month;
import java.time.format.TextStyle;
import java.util.Locale;
import name.abuchen.portfolio.ui.util.viewers.PropertyEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class MonthEditingSupport
extends PropertyEditingSupport {
    private String[] options;

    public MonthEditingSupport(Class<?> subjectType, String attributeName) {
        super(subjectType, attributeName);
        Class<?> propertyType = this.descriptor().getPropertyType();
        if (!Integer.TYPE.isAssignableFrom(propertyType)) {
            throw new UnsupportedOperationException(String.format("Property %s needs to be of type int to serve as month", attributeName));
        }
        Month[] months = Month.values();
        this.options = new String[months.length];
        int ii = 0;
        while (ii < months.length) {
            this.options[ii] = months[ii].getDisplayName(TextStyle.FULL, Locale.getDefault());
            ++ii;
        }
    }

    @Override
    public CellEditor createEditor(Composite composite) {
        return new ComboBoxCellEditor(composite, this.options, 8);
    }

    @Override
    public final Object getValue(Object element) throws Exception {
        return (Integer)this.descriptor().getReadMethod().invoke(this.adapt(element), new Object[0]) - 1;
    }

    @Override
    public final void setValue(Object element, Object value) throws Exception {
        Integer oldValue;
        Object subject = this.adapt(element);
        Integer newValue = (Integer)value + 1;
        if (!newValue.equals(oldValue = (Integer)this.descriptor().getReadMethod().invoke(subject, new Object[0]))) {
            this.descriptor().getWriteMethod().invoke(subject, newValue);
            this.notify(element, newValue, oldValue);
        }
    }
}

