/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.function.Predicate;
import name.abuchen.portfolio.model.Adaptor;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;

public abstract class PropertyEditingSupport
extends ColumnEditingSupport {
    private Class<?> subjectType;
    private PropertyDescriptor descriptor;
    private Predicate<Object> canEditCheck;

    public PropertyEditingSupport(Class<?> subjectType, String attributeName) {
        this.subjectType = subjectType;
        this.descriptor = this.descriptorFor(subjectType, attributeName);
    }

    public PropertyEditingSupport setCanEditCheck(Predicate<Object> canEditCheck) {
        this.canEditCheck = canEditCheck;
        return this;
    }

    protected PropertyDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public boolean canEdit(Object element) {
        return this.adapt(element) != null && (this.canEditCheck == null || this.canEditCheck.test(element));
    }

    protected Object adapt(Object element) {
        return Adaptor.adapt(this.subjectType, (Object)element);
    }

    protected PropertyDescriptor descriptorFor(Class<?> subjectType, String attributeName) {
        try {
            PropertyDescriptor[] properties;
            PropertyDescriptor[] propertyDescriptorArray = properties = Introspector.getBeanInfo(subjectType).getPropertyDescriptors();
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor p = propertyDescriptorArray[n2];
                if (attributeName.equals(p.getName())) {
                    return p;
                }
                ++n2;
            }
            throw new IllegalArgumentException(String.format("%s has no property named %s", subjectType.getName(), attributeName));
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

