/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.CrossEntry;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class TransactionOwnerListEditingSupport
extends ColumnEditingSupport {
    private final Client client;
    private final EditMode editMode;
    private ComboBoxCellEditor editor;
    private List<TransactionOwner<?>> comboBoxItems;

    public TransactionOwnerListEditingSupport(Client client, EditMode editMode) {
        this.client = client;
        this.editMode = editMode;
    }

    private Transaction getTransaction(Object element) {
        if (element instanceof Transaction) {
            return (Transaction)element;
        }
        if (element instanceof TransactionPair) {
            return ((TransactionPair)element).getTransaction();
        }
        return null;
    }

    private CrossEntry getCrossEntry(Object element) {
        Transaction t = this.getTransaction(element);
        return t != null ? t.getCrossEntry() : null;
    }

    @Override
    public boolean canEdit(Object element) {
        return this.getCrossEntry(element) != null;
    }

    @Override
    public final CellEditor createEditor(Composite composite) {
        this.editor = new ComboBoxCellEditor(composite, new String[0], 8);
        return this.editor;
    }

    @Override
    public final void prepareEditor(Object element) {
        TransactionOwner skipTransfer;
        CrossEntry crossEntry;
        Transaction transaction;
        block12: {
            block11: {
                transaction = this.getTransaction(element);
                if (transaction == null) {
                    return;
                }
                crossEntry = transaction.getCrossEntry();
                if (crossEntry == null) {
                    return;
                }
                if (!crossEntry.getOwner(transaction).getClass().equals(crossEntry.getCrossOwner(transaction).getClass())) break block11;
                switch (this.editMode) {
                    case OWNER: {
                        skipTransfer = crossEntry.getCrossOwner(transaction);
                        break block12;
                    }
                    case CROSSOWNER: {
                        skipTransfer = crossEntry.getOwner(transaction);
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            skipTransfer = null;
        }
        TransactionOwner<Transaction> ownerToEdit = this.editMode.getOwner(crossEntry, transaction);
        if (ownerToEdit instanceof Account) {
            String ownerCurrencyCode = ((Account)ownerToEdit).getCurrencyCode();
            this.comboBoxItems = this.client.getAccounts().stream().filter(a -> !a.equals(skipTransfer)).filter(a -> a.getCurrencyCode().equals(ownerCurrencyCode)).collect(Collectors.toList());
        } else if (ownerToEdit instanceof Portfolio) {
            this.comboBoxItems = this.client.getPortfolios().stream().filter(p -> !p.equals(skipTransfer)).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException();
        }
        String[] names = new String[this.comboBoxItems.size()];
        int index = 0;
        for (TransactionOwner<?> item : this.comboBoxItems) {
            String string = names[index++] = item == null ? "" : item.toString();
        }
        this.editor.setItems(names);
    }

    @Override
    public final Object getValue(Object element) throws Exception {
        Transaction transaction = this.getTransaction(element);
        if (transaction == null) {
            throw new IllegalArgumentException();
        }
        CrossEntry crossEntry = transaction.getCrossEntry();
        if (crossEntry == null) {
            throw new IllegalArgumentException();
        }
        TransactionOwner<Transaction> owner = this.editMode.getOwner(crossEntry, transaction);
        return this.comboBoxItems.indexOf(owner);
    }

    @Override
    public final void setValue(Object element, Object value) throws Exception {
        TransactionOwner<Transaction> oldValue;
        int index = (Integer)value;
        if (index < 0 || index >= this.comboBoxItems.size()) {
            return;
        }
        Transaction transaction = this.getTransaction(element);
        if (transaction == null) {
            throw new IllegalArgumentException();
        }
        CrossEntry crossEntry = transaction.getCrossEntry();
        if (crossEntry == null) {
            throw new IllegalArgumentException();
        }
        TransactionOwner<?> newValue = this.comboBoxItems.get(index);
        if (newValue.equals(oldValue = this.editMode.getOwner(crossEntry, transaction))) {
            return;
        }
        TransactionOwner transactionOwner = crossEntry.getOwner(transaction);
        transactionOwner.deleteTransaction(transaction, this.client);
        this.editMode.setOwner(crossEntry, transaction, newValue);
        crossEntry.insert();
        this.notify(element, newValue, oldValue);
    }

    public static enum EditMode {
        OWNER((e, t) -> e.getOwner(t), (e, t, o) -> e.setOwner(t, o)),
        CROSSOWNER((e, t) -> e.getCrossOwner(t), (e, t, o) -> e.setOwner(e.getCrossTransaction(t), o));

        private final BiFunction<CrossEntry, Transaction, TransactionOwner<?>> getter;
        private final TriConsumer<CrossEntry, Transaction, TransactionOwner<?>> setter;

        private EditMode(BiFunction<CrossEntry, Transaction, TransactionOwner<?>> getter, TriConsumer<CrossEntry, Transaction, TransactionOwner<?>> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public TransactionOwner<Transaction> getOwner(CrossEntry crossEntry, Transaction transaction) {
            return this.getter.apply(crossEntry, transaction);
        }

        public void setOwner(CrossEntry crossEntry, Transaction transaction, TransactionOwner<?> owner) {
            this.setter.accept(crossEntry, transaction, owner);
        }
    }

    static interface TriConsumer<T, U, V> {
        public void accept(T var1, U var2, V var3);
    }
}

