/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.util.viewers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.views.actions.ConvertBuySellToDeliveryAction;
import name.abuchen.portfolio.ui.views.actions.ConvertDeliveryToBuySellAction;
import name.abuchen.portfolio.ui.views.actions.RevertBuySellAction;
import name.abuchen.portfolio.ui.views.actions.RevertDeliveryAction;
import name.abuchen.portfolio.ui.views.actions.RevertDepositRemovalAction;
import name.abuchen.portfolio.ui.views.actions.RevertInterestAction;
import name.abuchen.portfolio.ui.views.actions.RevertTransferAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.widgets.Composite;

public class TransactionTypeEditingSupport
extends ColumnEditingSupport {
    private static final Object[] TRANSITIONS = new Object[]{PortfolioTransaction.Type.BUY, PortfolioTransaction.Type.SELL, new Class[]{RevertBuySellAction.class}, PortfolioTransaction.Type.BUY, PortfolioTransaction.Type.DELIVERY_INBOUND, new Class[]{ConvertBuySellToDeliveryAction.class}, PortfolioTransaction.Type.BUY, PortfolioTransaction.Type.DELIVERY_OUTBOUND, new Class[]{RevertBuySellAction.class, ConvertBuySellToDeliveryAction.class}, PortfolioTransaction.Type.SELL, PortfolioTransaction.Type.BUY, new Class[]{RevertBuySellAction.class}, PortfolioTransaction.Type.SELL, PortfolioTransaction.Type.DELIVERY_OUTBOUND, new Class[]{ConvertBuySellToDeliveryAction.class}, PortfolioTransaction.Type.SELL, PortfolioTransaction.Type.DELIVERY_INBOUND, new Class[]{RevertBuySellAction.class, ConvertBuySellToDeliveryAction.class}, PortfolioTransaction.Type.DELIVERY_INBOUND, PortfolioTransaction.Type.DELIVERY_OUTBOUND, new Class[]{RevertDeliveryAction.class}, PortfolioTransaction.Type.DELIVERY_INBOUND, PortfolioTransaction.Type.BUY, new Class[]{ConvertDeliveryToBuySellAction.class}, PortfolioTransaction.Type.DELIVERY_INBOUND, PortfolioTransaction.Type.SELL, new Class[]{RevertDeliveryAction.class, ConvertDeliveryToBuySellAction.class}, PortfolioTransaction.Type.DELIVERY_OUTBOUND, PortfolioTransaction.Type.DELIVERY_INBOUND, new Class[]{RevertDeliveryAction.class}, PortfolioTransaction.Type.DELIVERY_OUTBOUND, PortfolioTransaction.Type.SELL, new Class[]{ConvertDeliveryToBuySellAction.class}, PortfolioTransaction.Type.DELIVERY_OUTBOUND, PortfolioTransaction.Type.BUY, new Class[]{RevertDeliveryAction.class, ConvertDeliveryToBuySellAction.class}, AccountTransaction.Type.SELL, AccountTransaction.Type.BUY, new Class[]{RevertBuySellAction.class}, AccountTransaction.Type.BUY, AccountTransaction.Type.SELL, new Class[]{RevertBuySellAction.class}, AccountTransaction.Type.TRANSFER_IN, AccountTransaction.Type.TRANSFER_OUT, new Class[]{RevertTransferAction.class}, AccountTransaction.Type.TRANSFER_OUT, AccountTransaction.Type.TRANSFER_IN, new Class[]{RevertTransferAction.class}, AccountTransaction.Type.DEPOSIT, AccountTransaction.Type.REMOVAL, new Class[]{RevertDepositRemovalAction.class}, AccountTransaction.Type.REMOVAL, AccountTransaction.Type.DEPOSIT, new Class[]{RevertDepositRemovalAction.class}, AccountTransaction.Type.INTEREST, AccountTransaction.Type.INTEREST_CHARGE, new Class[]{RevertInterestAction.class}, AccountTransaction.Type.INTEREST_CHARGE, AccountTransaction.Type.INTEREST, new Class[]{RevertInterestAction.class}};
    private final Client client;
    private ComboBoxCellEditor editor;
    private List<Object> comboBoxItems;

    public TransactionTypeEditingSupport(Client client) {
        this.client = client;
    }

    private Account lookupOwner(AccountTransaction t) {
        return this.client.getAccounts().stream().filter(a -> a.getTransactions().contains(t)).findAny().orElseThrow(IllegalArgumentException::new);
    }

    private Portfolio lookupOwner(PortfolioTransaction t) {
        return this.client.getPortfolios().stream().filter(a -> a.getTransactions().contains(t)).findAny().orElseThrow(IllegalArgumentException::new);
    }

    private TransactionPair<?> getTransactionPair(Object element) {
        if (element instanceof TransactionPair) {
            return (TransactionPair)element;
        }
        Transaction t = this.getTransaction(element);
        if (t instanceof AccountTransaction) {
            return new TransactionPair((TransactionOwner)this.lookupOwner((AccountTransaction)t), (Transaction)((AccountTransaction)t));
        }
        if (t instanceof PortfolioTransaction) {
            return new TransactionPair((TransactionOwner)this.lookupOwner((PortfolioTransaction)t), (Transaction)((PortfolioTransaction)t));
        }
        throw new UnsupportedOperationException();
    }

    private Transaction getTransaction(Object element) {
        if (element instanceof Transaction) {
            return (Transaction)element;
        }
        if (element instanceof TransactionPair) {
            return ((TransactionPair)element).getTransaction();
        }
        throw new UnsupportedOperationException();
    }

    private Enum<?> getTypeValue(Transaction t) {
        if (t instanceof AccountTransaction) {
            return ((AccountTransaction)t).getType();
        }
        if (t instanceof PortfolioTransaction) {
            return ((PortfolioTransaction)t).getType();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean canEdit(Object element) {
        Transaction t = this.getTransaction(element);
        Enum<?> type = this.getTypeValue(t);
        int ii = 0;
        while (ii < TRANSITIONS.length) {
            if (TRANSITIONS[ii] == type) {
                return true;
            }
            ii += 3;
        }
        return false;
    }

    @Override
    public final CellEditor createEditor(Composite composite) {
        this.editor = new ComboBoxCellEditor(composite, new String[0], 8);
        return this.editor;
    }

    @Override
    public final void prepareEditor(Object element) {
        Transaction t = this.getTransaction(element);
        Enum<?> type = this.getTypeValue(t);
        this.comboBoxItems = new ArrayList<Object>();
        this.comboBoxItems.add(type);
        int ii = 0;
        while (ii < TRANSITIONS.length) {
            if (TRANSITIONS[ii] == type) {
                this.comboBoxItems.add(TRANSITIONS[ii + 1]);
            }
            ii += 3;
        }
        Collections.sort(this.comboBoxItems, (r, l) -> r.toString().compareTo(l.toString()));
        this.editor.setItems((String[])this.comboBoxItems.stream().map(Object::toString).toArray(String[]::new));
    }

    @Override
    public final Object getValue(Object element) throws Exception {
        Transaction t = this.getTransaction(element);
        Enum<?> type = this.getTypeValue(t);
        return this.comboBoxItems.indexOf(type);
    }

    @Override
    public final void setValue(Object element, Object value) throws Exception {
        Class<?>[] transition;
        int index = (Integer)value;
        if (index < 0 || index >= this.comboBoxItems.size()) {
            return;
        }
        Transaction t = this.getTransaction(element);
        Enum<?> oldValue = this.getTypeValue(t);
        Enum newValue = (Enum)this.comboBoxItems.get(index);
        if (newValue.equals(oldValue)) {
            return;
        }
        TransactionPair<?> pair = this.getTransactionPair(element);
        Class<?>[] classArray = transition = this.getTransition(oldValue, newValue);
        int n = transition.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> action = classArray[n2];
            ((Action)action.getDeclaredConstructor(Client.class, TransactionPair.class).newInstance(this.client, pair)).run();
            ++n2;
        }
        this.notify(element, newValue, oldValue);
    }

    private Class<?>[] getTransition(Enum<?> fromValue, Enum<?> toValue) {
        int ii = 0;
        while (ii < TRANSITIONS.length) {
            if (TRANSITIONS[ii] == fromValue && TRANSITIONS[ii + 1] == toValue) {
                return (Class[])TRANSITIONS[ii + 2];
            }
            ii += 3;
        }
        throw new IllegalArgumentException();
    }
}

