/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.util.EnumSet;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransferDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.OpenDialogAction;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransactionDialog;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;

public class AccountContextMenu {
    private AbstractFinanceView owner;

    public AccountContextMenu(AbstractFinanceView owner) {
        this.owner = owner;
    }

    public void menuAboutToShow(IMenuManager manager, Account account, Security security) {
        if (account == null) {
            return;
        }
        for (AccountTransaction.Type type : EnumSet.of(AccountTransaction.Type.DEPOSIT, new AccountTransaction.Type[]{AccountTransaction.Type.REMOVAL, AccountTransaction.Type.TAXES, AccountTransaction.Type.TAX_REFUND, AccountTransaction.Type.FEES, AccountTransaction.Type.FEES_REFUND, AccountTransaction.Type.INTEREST, AccountTransaction.Type.INTEREST_CHARGE})) {
            new OpenDialogAction(this.owner, String.valueOf(type.toString()) + "...").type(AccountTransactionDialog.class).parameters(type).with(account).with(security).addTo(manager);
        }
        manager.add((IContributionItem)new Separator());
        new OpenDialogAction(this.owner, Messages.AccountMenuTransfer).type(AccountTransferDialog.class).with(account).addTo(manager);
        manager.add((IContributionItem)new Separator());
        if (!this.owner.getClient().getActivePortfolios().isEmpty() && !this.owner.getClient().getSecurities().isEmpty()) {
            Portfolio[] portfolioArray = new Portfolio[1];
            for (Portfolio p : this.owner.getClient().getActivePortfolios()) {
                if (!p.getReferenceAccount().equals(account)) continue;
                portfolioArray[0] = p;
                break;
            }
            new OpenDialogAction(this.owner, String.valueOf(Messages.SecurityMenuBuy) + "...").type(SecurityTransactionDialog.class).parameters(PortfolioTransaction.Type.BUY).with(portfolioArray[0]).with(security).addTo(manager);
            new OpenDialogAction(this.owner, String.valueOf(Messages.SecurityMenuSell) + "...").type(SecurityTransactionDialog.class).parameters(PortfolioTransaction.Type.SELL).with(portfolioArray[0]).with(security).addTo(manager);
            new OpenDialogAction(this.owner, String.valueOf(Messages.SecurityMenuDividends) + "...").type(AccountTransactionDialog.class).parameters(AccountTransaction.Type.DIVIDENDS).with(account).with(security).addTo(manager);
        }
    }
}

