/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Attributable;
import name.abuchen.portfolio.model.InvestmentPlan;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.dialogs.transactions.InvestmentPlanDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.OpenDialogAction;
import name.abuchen.portfolio.ui.editor.PortfolioPart;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.viewers.BooleanEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.DateEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ListEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.util.viewers.ValueEditingSupport;
import name.abuchen.portfolio.ui.views.AbstractListView;
import name.abuchen.portfolio.ui.views.TransactionsViewer;
import name.abuchen.portfolio.ui.views.columns.AttributeColumn;
import name.abuchen.portfolio.ui.views.columns.NameColumn;
import name.abuchen.portfolio.ui.views.columns.NoteColumn;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class InvestmentPlanListView
extends AbstractListView
implements ColumnEditingSupport.ModificationListener {
    private TableViewer plans;
    private TransactionsViewer transactions;
    private ShowHideColumnHelper planColumns;
    @Inject
    private ExchangeRateProviderFactory factory;
    @Inject
    private PortfolioPart part;

    @Override
    protected String getDefaultTitle() {
        return Messages.LabelInvestmentPlans;
    }

    @Override
    protected int getSashStyle() {
        return 513;
    }

    @Override
    public void notifyModelUpdated() {
        this.plans.setInput((Object)this.getClient().getPlans());
        this.plans.setSelection(this.plans.getSelection());
    }

    @Override
    public void onModified(Object element, Object newValue, Object oldValue) {
        this.markDirty();
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        this.addNewInvestmentPlanButton(toolBar);
        this.addConfigButton(toolBar);
    }

    private void addNewInvestmentPlanButton(ToolBarManager toolBar) {
        toolBar.add((IContributionItem)new DropDown(Messages.InvestmentPlanMenuCreate, Images.PLUS, 0, manager -> {
            manager.add((IAction)new OpenDialogAction(this, Messages.InvestmentPlanTypeBuyDelivery).type(InvestmentPlanDialog.class).parameters(PortfolioTransaction.class));
            manager.add((IAction)new OpenDialogAction(this, Messages.InvestmentPlanTypeDeposit).type(InvestmentPlanDialog.class).parameters(AccountTransaction.class));
        }));
    }

    private void addConfigButton(ToolBarManager toolBar) {
        toolBar.add((IContributionItem)new DropDown(Messages.MenuShowHideColumns, Images.CONFIG, 0, manager -> {
            MenuManager m = new MenuManager(Messages.LabelInvestmentPlans);
            this.planColumns.menuAboutToShow((IMenuManager)m);
            manager.add((IContributionItem)m);
            m = new MenuManager(Messages.LabelTransactions);
            this.transactions.getColumnSupport().menuAboutToShow((IMenuManager)m);
            manager.add((IContributionItem)m);
        }));
    }

    @Override
    protected void createTopTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.plans = new TableViewer(container, 65536);
        ColumnEditingSupport.prepare((ColumnViewer)this.plans);
        this.planColumns = new ShowHideColumnHelper(String.valueOf(InvestmentPlanListView.class.getSimpleName()) + "@top", this.getPreferenceStore(), this.plans, layout);
        this.addColumns(this.planColumns);
        this.addAttributeColumns(this.planColumns);
        this.planColumns.createColumns();
        this.plans.getTable().setHeaderVisible(true);
        this.plans.getTable().setLinesVisible(true);
        this.plans.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.plans.setInput((Object)this.getClient().getPlans());
        this.plans.addSelectionChangedListener(event -> {
            InvestmentPlan plan = (InvestmentPlan)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (plan != null) {
                this.transactions.setInput(plan.getTransactions(this.getClient()));
            } else {
                this.transactions.setInput(null);
            }
            this.transactions.refresh();
        });
        this.hookContextMenu((Control)this.plans.getTable(), this::fillPlansContextMenu);
    }

    private Image MaybeGetLogo(Attributable object) {
        return LogoManager.instance().getDefaultColumnImage(object, this.getClient().getSettings());
    }

    private void addColumns(ShowHideColumnHelper support) {
        Column column = new NameColumn("0", Messages.ColumnName, 0, 100, this.part.getClient());
        column.getEditingSupport().addListener(this);
        support.addColumn(column);
        column = new Column(Messages.ColumnSecurity, 0, 250);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                InvestmentPlan plan = (InvestmentPlan)e;
                return plan.getSecurity() != null ? plan.getSecurity().getName() : null;
            }

            public Image getImage(Object e) {
                InvestmentPlan plan = (InvestmentPlan)e;
                return InvestmentPlanListView.this.MaybeGetLogo((Attributable)plan.getSecurity());
            }
        });
        ColumnViewerSorter.create(Security.class, "name").attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnPortfolio, 0, 120);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                InvestmentPlan plan = (InvestmentPlan)e;
                return plan.getPortfolio() != null ? plan.getPortfolio().getName() : Messages.InvestmentPlanOptionDeposit;
            }

            public Image getImage(Object e) {
                InvestmentPlan plan = (InvestmentPlan)e;
                return InvestmentPlanListView.this.MaybeGetLogo((Attributable)plan.getPortfolio());
            }
        });
        ColumnViewerSorter.create(InvestmentPlan.class, "portfolio").attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnAccount, 0, 120);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                InvestmentPlan plan = (InvestmentPlan)e;
                return plan.getAccount() != null ? plan.getAccount().getName() : Messages.InvestmentPlanOptionDelivery;
            }

            public Image getImage(Object e) {
                InvestmentPlan plan = (InvestmentPlan)e;
                return InvestmentPlanListView.this.MaybeGetLogo((Attributable)plan.getAccount());
            }
        });
        ColumnViewerSorter.create(Account.class, "name").attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnStartDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return Values.Date.format((Object)((InvestmentPlan)e).getStart());
            }
        });
        ColumnViewerSorter.create(InvestmentPlan.class, "start").attachTo(column);
        new DateEditingSupport(InvestmentPlan.class, "start").addListener(this).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnLastDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Optional lastDate = ((InvestmentPlan)e).getLastDate();
                return lastDate.map(arg_0 -> ((Values)Values.Date).format(arg_0)).orElseGet(() -> null);
            }
        });
        ColumnViewerSorter.create(InvestmentPlan.class, "LastDate").attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnNextDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return Values.Date.format((Object)((InvestmentPlan)e).getDateOfNextTransactionToBeGenerated());
            }
        });
        ColumnViewerSorter.create(InvestmentPlan.class, "DateOfNextTransactionToBeGenerated").attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnInterval, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return MessageFormat.format(Messages.InvestmentPlanIntervalLabel, ((InvestmentPlan)e).getInterval());
            }
        });
        ColumnViewerSorter.create(InvestmentPlan.class, "interval").attachTo(column);
        ArrayList<Integer> available = new ArrayList<Integer>();
        int ii = 1;
        while (ii <= 12) {
            available.add(ii);
            ++ii;
        }
        new ListEditingSupport(InvestmentPlan.class, "interval", available).addListener(this).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnAmount, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                InvestmentPlan plan = (InvestmentPlan)e;
                return Values.Money.format(Money.of((String)plan.getCurrencyCode(), (long)plan.getAmount()));
            }
        });
        ColumnViewerSorter.create(InvestmentPlan.class, "amount").attachTo(column);
        new ValueEditingSupport(InvestmentPlan.class, "amount", (Values<? extends Number>)Values.Amount).addListener(this).attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnFees, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                InvestmentPlan plan = (InvestmentPlan)e;
                return Values.Money.format(Money.of((String)plan.getCurrencyCode(), (long)plan.getFees()));
            }
        });
        ColumnViewerSorter.create(InvestmentPlan.class, "fees").attachTo(column);
        support.addColumn(column);
        column = new Column(Messages.ColumnAutoGenerate, 16384, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return "";
            }

            public Image getImage(Object e) {
                return ((InvestmentPlan)e).isAutoGenerate() ? Images.CHECK.image() : null;
            }
        });
        ColumnViewerSorter.create(InvestmentPlan.class, "autoGenerate").attachTo(column);
        new BooleanEditingSupport(InvestmentPlan.class, "autoGenerate").addListener(this).attachTo(column);
        support.addColumn(column);
        column = new NoteColumn();
        column.getEditingSupport().addListener(this);
        column.setVisible(false);
        support.addColumn(column);
    }

    private void addAttributeColumns(ShowHideColumnHelper support) {
        AttributeColumn.createFor(this.getClient(), InvestmentPlan.class).forEach(column -> {
            column.getEditingSupport().addListener(this);
            support.addColumn((Column)column);
        });
    }

    private void fillPlansContextMenu(IMenuManager manager) {
        final InvestmentPlan plan = (InvestmentPlan)((IStructuredSelection)this.plans.getSelection()).getFirstElement();
        if (plan == null) {
            return;
        }
        manager.add((IAction)new Action(Messages.InvestmentPlanMenuGenerateTransactions){

            public void run() {
                try {
                    CurrencyConverterImpl converter = new CurrencyConverterImpl(InvestmentPlanListView.this.factory, InvestmentPlanListView.this.getClient().getBaseCurrency());
                    List latest = plan.generateTransactions((CurrencyConverter)converter);
                    if (latest.isEmpty()) {
                        MessageDialog.openInformation((Shell)InvestmentPlanListView.this.getActiveShell(), (String)Messages.LabelInfo, (String)MessageFormat.format(Messages.InvestmentPlanInfoNoTransactionsGenerated, Values.Date.format((Object)plan.getDateOfNextTransactionToBeGenerated())));
                    } else {
                        InvestmentPlanListView.this.markDirty();
                        InvestmentPlanListView.this.plans.refresh();
                        InvestmentPlanListView.this.transactions.markTransactions(latest);
                        InvestmentPlanListView.this.transactions.setInput(plan.getTransactions(InvestmentPlanListView.this.getClient()));
                    }
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)InvestmentPlanListView.this.getActiveShell(), (String)Messages.LabelError, (String)e.getMessage());
                    PortfolioPlugin.log(e);
                }
            }
        });
        manager.add((IContributionItem)new Separator());
        new OpenDialogAction(this, Messages.MenuEditInvestmentPlan).type(InvestmentPlanDialog.class, d -> d.setPlan(plan)).parameters(plan.getPlanType()).addTo(manager);
        manager.add((IAction)new Action(Messages.InvestmentPlanMenuDelete){

            public void run() {
                InvestmentPlanListView.this.getClient().removePlan(plan);
                InvestmentPlanListView.this.markDirty();
                InvestmentPlanListView.this.plans.setInput((Object)InvestmentPlanListView.this.getClient().getPlans());
                InvestmentPlanListView.this.transactions.setInput(null);
            }
        });
    }

    @Override
    protected void createBottomTable(Composite parent) {
        this.transactions = new TransactionsViewer(parent, this);
        this.inject(this.transactions);
        this.transactions.setFullContextMenu(false);
        if (!this.getClient().getPlans().isEmpty()) {
            this.plans.setSelection((ISelection)new StructuredSelection(this.plans.getElementAt(0)), true);
        }
    }
}

