/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.google.common.primitives.Doubles;
import com.ibm.icu.text.MessageFormat;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityEvent;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.ClientSnapshot;
import name.abuchen.portfolio.snapshot.filter.ClientSecurityFilter;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyClient;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceIndicator;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceSnapshot;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.util.chart.TimelineChartToolTip;
import name.abuchen.portfolio.ui.views.BollingerBands;
import name.abuchen.portfolio.ui.views.ChartLineSeriesAxes;
import name.abuchen.portfolio.ui.views.ExponentialMovingAverage;
import name.abuchen.portfolio.ui.views.SimpleMovingAverage;
import name.abuchen.portfolio.util.Interval;
import name.abuchen.portfolio.util.TradeCalendar;
import name.abuchen.portfolio.util.TradeCalendarManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.swtchart.IAxis;
import org.swtchart.ILegend;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;
import org.swtchart.Range;

public class SecuritiesChart {
    private static final Color colorQuote = Colors.getColor(52, 70, 235);
    private static final Color colorEventPurchase = Colors.getColor(26, 173, 33);
    private static final Color colorEventSale = Colors.getColor(232, 51, 69);
    private static final Color colorEventDividend = Colors.getColor(128, 0, 128);
    private static final Color colorHigh = Colors.getColor(0, 102, 0);
    private static final Color colorLow = Colors.getColor(128, 0, 0);
    private static final Color colorFifoPurchasePrice = Colors.getColor(226, 122, 121);
    private static final Color colorMovingAveragePurchasePrice = Colors.getColor(150, 82, 81);
    private static final Color colorBollingerBands = Colors.getColor(201, 141, 68);
    private static final Color colorSMA1 = Colors.getColor(179, 107, 107);
    private static final Color colorSMA2 = Colors.getColor(179, 167, 107);
    private static final Color colorSMA3 = Colors.getColor(131, 179, 107);
    private static final Color colorSMA4 = Colors.getColor(107, 179, 143);
    private static final Color colorSMA5 = Colors.getColor(107, 155, 179);
    private static final Color colorSMA6 = Colors.getColor(119, 107, 179);
    private static final Color colorSMA7 = Colors.getColor(179, 107, 179);
    private static final Color colorEMA1 = Colors.getColor(200, 107, 107);
    private static final Color colorEMA2 = Colors.getColor(200, 167, 107);
    private static final Color colorEMA3 = Colors.getColor(131, 200, 107);
    private static final Color colorEMA4 = Colors.getColor(107, 200, 143);
    private static final Color colorEMA5 = Colors.getColor(107, 155, 200);
    private static final Color colorEMA6 = Colors.getColor(119, 107, 200);
    private static final Color colorEMA7 = Colors.getColor(200, 107, 200);
    private static final Color colorAreaPositive = Colors.getColor(90, 114, 226);
    private static final Color colorAreaNegative = Colors.getColor(226, 91, 90);
    private static final Color colorNonTradingDay = Colors.getColor(255, 137, 89);
    private static final String PREF_KEY = "security-chart-details";
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("d LLL");
    private Menu contextMenu;
    private Client client;
    private CurrencyConverter converter;
    private Security security;
    private TimelineChart chart;
    private Function<Security, ChartInterval> chartIntervalFunction;
    private EnumSet<ChartDetails> chartConfig = EnumSet.of(ChartDetails.INVESTMENT, ChartDetails.EVENTS, ChartDetails.SCALING_LINEAR);
    private List<PaintListener> customPaintListeners = new ArrayList<PaintListener>();
    private List<PaintListener> customBehindPaintListener = new ArrayList<PaintListener>();
    private List<Transaction> customTooltipEvents = new ArrayList<Transaction>();
    private int swtAntialias = 1;

    public SecuritiesChart(Composite parent, Client client, CurrencyConverter converter) {
        this.client = client;
        this.converter = converter;
        this.readChartConfig(client);
        this.chart = new TimelineChart(parent);
        this.chart.getTitle().setText("...");
        this.chart.getPlotArea().addPaintListener(event -> this.customPaintListeners.forEach(l -> l.paintControl(event)));
        this.chart.getPlotArea().addPaintListener(event -> this.customBehindPaintListener.forEach(l -> l.paintControl(event)));
        this.setupTooltip();
        ILegend legend = this.chart.getLegend();
        legend.setPosition(1024);
        legend.setVisible(true);
        Composite buttons = new Composite(parent, 0);
        buttons.setBackground(Colors.WHITE);
        RowLayoutFactory.fillDefaults().type(512).spacing(2).margins(2, 2).fill(true).wrap(true).applyTo(buttons);
        this.addConfigButton(buttons);
        Function<TemporalAmount, ChartInterval> nowMinus = temporalAmount -> {
            LocalDate now = LocalDate.now();
            return new ChartInterval(now.minus((TemporalAmount)temporalAmount), now);
        };
        this.addButton(buttons, Messages.SecurityTabChart1M, Messages.SecurityTabChart1MToolTip, s -> (ChartInterval)nowMinus.apply(Period.ofMonths(1)));
        this.addButton(buttons, Messages.SecurityTabChart2M, Messages.SecurityTabChart2MToolTip, s -> (ChartInterval)nowMinus.apply(Period.ofMonths(2)));
        this.addButton(buttons, Messages.SecurityTabChart6M, Messages.SecurityTabChart6MToolTip, s -> (ChartInterval)nowMinus.apply(Period.ofMonths(6)));
        this.addButton(buttons, Messages.SecurityTabChart1Y, Messages.SecurityTabChart1YToolTip, s -> (ChartInterval)nowMinus.apply(Period.ofYears(1)));
        this.addButton(buttons, Messages.SecurityTabChart2Y, Messages.SecurityTabChart2YToolTip, s -> (ChartInterval)nowMinus.apply(Period.ofYears(2)));
        this.addButton(buttons, Messages.SecurityTabChart3Y, Messages.SecurityTabChart3YToolTip, s -> (ChartInterval)nowMinus.apply(Period.ofYears(3)));
        this.addButton(buttons, Messages.SecurityTabChart5Y, Messages.SecurityTabChart5YToolTip, s -> (ChartInterval)nowMinus.apply(Period.ofYears(5)));
        this.addButton(buttons, Messages.SecurityTabChart10Y, Messages.SecurityTabChart10YToolTip, s -> (ChartInterval)nowMinus.apply(Period.ofYears(10)));
        this.addButton(buttons, Messages.SecurityTabChartYTD, Messages.SecurityTabChartYTDToolTip, s -> (ChartInterval)nowMinus.apply(Period.ofDays(LocalDate.now().getDayOfYear() - 1)));
        this.addButton(buttons, Messages.SecurityTabChartHoldingPeriod, Messages.SecurityTabChartHoldingPeriodToolTip, s -> {
            List tx = s.getTransactions(client);
            if (tx.isEmpty()) {
                return null;
            }
            Collections.sort(tx, new TransactionPair.ByDate());
            boolean hasHoldings = ClientSnapshot.create((Client)client, (CurrencyConverter)converter, (LocalDate)LocalDate.now()).getPositionsByVehicle().containsKey(s);
            return new ChartInterval(((TransactionPair)tx.get(0)).getTransaction().getDateTime().toLocalDate(), hasHoldings ? LocalDate.now() : ((TransactionPair)tx.get(tx.size() - 1)).getTransaction().getDateTime().toLocalDate());
        });
        this.addButton(buttons, Messages.SecurityTabChartAll, Messages.SecurityTabChartAllToolTip, s -> {
            List prices = s.getPricesIncludingLatest();
            return prices.isEmpty() ? null : new ChartInterval(((SecurityPrice)prices.get(0)).getDate(), ((SecurityPrice)prices.get(prices.size() - 1)).getDate());
        });
        parent.setLayout((Layout)new CustomLayout(this.chart, buttons));
    }

    private void setupTooltip() {
        TimelineChartToolTip toolTip = this.chart.getToolTip();
        toolTip.showToolTipOnlyForDatesInDataSeries(Messages.ColumnQuote);
        toolTip.setValueFormat(new DecimalFormat(Values.Quote.pattern()));
        toolTip.addSeriesExclude(String.valueOf(Messages.LabelChartDetailChartDevelopment) + "Positive");
        toolTip.addSeriesExclude(String.valueOf(Messages.LabelChartDetailChartDevelopment) + "Negative");
        toolTip.addSeriesExclude(String.valueOf(Messages.LabelChartDetailChartDevelopment) + "Zero");
        toolTip.addSeriesExclude(Messages.SecurityMenuBuy);
        toolTip.addSeriesExclude(String.valueOf(Messages.SecurityMenuBuy) + "1");
        toolTip.addSeriesExclude(String.valueOf(Messages.SecurityMenuBuy) + "2");
        toolTip.addSeriesExclude(Messages.SecurityMenuSell);
        toolTip.addSeriesExclude(String.valueOf(Messages.SecurityMenuSell) + "1");
        toolTip.addSeriesExclude(String.valueOf(Messages.SecurityMenuSell) + "2");
        toolTip.addSeriesExclude(Messages.LabelChartDetailMarkerDividends);
        toolTip.addSeriesExclude(String.valueOf(Messages.LabelChartDetailMarkerDividends) + "1");
        toolTip.addSeriesExclude(String.valueOf(Messages.LabelChartDetailMarkerDividends) + "2");
        toolTip.addSeriesExclude(Messages.LabelChartDetailIndicatorBollingerBands);
        toolTip.addExtraInfo((composite, focus) -> {
            if (focus instanceof Date) {
                Instant instant = ((Date)focus).toInstant();
                ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
                LocalDate date = zdt.toLocalDate();
                Interval displayInterval = Interval.of((LocalDate)date.minusDays(5L), (LocalDate)date.plusDays(5L));
                this.customTooltipEvents.stream().filter(t -> displayInterval.contains(t.getDateTime())).forEach(t -> {
                    if (t instanceof AccountTransaction) {
                        this.addDividendTooltip((Composite)composite, (AccountTransaction)t);
                    } else if (t instanceof PortfolioTransaction) {
                        this.addInvestmentTooltip((Composite)composite, (PortfolioTransaction)t);
                    }
                });
            }
        });
    }

    private void addInvestmentTooltip(Composite composite, PortfolioTransaction t) {
        Label label = new Label(composite, 0);
        label.setText(MessageFormat.format((String)Messages.LabelToolTipTransactionSummary, (Object[])new Object[]{t.getType().toString(), this.dateTimeFormatter.format(t.getDateTime().toLocalDate()), t.getMonetaryAmount().toString()}));
        label = new Label(composite, 0);
        label.setText(MessageFormat.format((String)Messages.LabelToolTipInvestmentDetails, (Object[])new Object[]{Values.Share.format((Object)t.getShares()), Values.Quote.format(t.getGrossPricePerShare(this.converter.with(t.getSecurity().getCurrencyCode())))}));
    }

    private void addDividendTooltip(Composite composite, AccountTransaction t) {
        Label label = new Label(composite, 0);
        String amount = t.getMonetaryAmount().toString();
        label.setText(MessageFormat.format((String)Messages.LabelToolTipTransactionSummary, (Object[])new Object[]{t.getType().toString(), this.dateTimeFormatter.format(t.getDateTime().toLocalDate()), amount}));
        if (t.getShares() == 0L) {
            label = new Label(composite, 0);
            label.setText("\u2211 " + t.getGrossValue().toString());
        } else {
            Optional grossValue = t.getUnit(Transaction.Unit.Type.GROSS_VALUE);
            long gross = grossValue.isPresent() ? ((Transaction.Unit)grossValue.get()).getForex().getAmount() : t.getGrossValueAmount();
            String currency = grossValue.isPresent() ? ((Transaction.Unit)grossValue.get()).getForex().getCurrencyCode() : t.getCurrencyCode();
            String grossAmount = Money.of((String)currency, (long)gross).toString();
            String grossValueAmount = Money.of((String)t.getCurrencyCode(), (long)t.getGrossValueAmount()).toString();
            if (!grossValueAmount.equals(grossAmount)) {
                label = new Label(composite, 0);
                label.setText(MessageFormat.format((String)Messages.LabelToolTipDividendDetailsGross, (Object[])new Object[]{grossValueAmount}));
            }
            if (!grossAmount.equals(amount)) {
                label = new Label(composite, 0);
                label.setText(MessageFormat.format((String)Messages.LabelToolTipDividendDetailsGross, (Object[])new Object[]{grossAmount}));
            }
            label = new Label(composite, 0);
            label.setText(MessageFormat.format((String)Messages.LabelToolTipDividendDetails, (Object[])new Object[]{Values.Share.format((Object)t.getShares()), currency, Values.Quote.format(Long.valueOf(Math.round((double)gross * Values.Share.divider() * (double)Values.Quote.factorToMoney() / (double)t.getShares())))}));
        }
    }

    private void configureSeriesPainter(ILineSeries series, Date[] dates, double[] values, Color color, int lineWidth, LineStyle lineStyle, boolean enableArea, boolean visibleInLegend) {
        if (lineWidth != 0) {
            series.setLineWidth(lineWidth);
        }
        series.setLineStyle(lineStyle);
        series.setXDateSeries(dates);
        series.enableArea(enableArea);
        series.setYSeries(values);
        series.setAntialias(this.swtAntialias);
        if (color != null) {
            series.setLineColor(color);
        }
        series.setVisibleInLegend(visibleInLegend);
    }

    private final void readChartConfig(Client client) {
        String pref = ReadOnlyClient.unwrap((Client)client).getProperty(PREF_KEY);
        if (pref == null) {
            return;
        }
        this.chartConfig.clear();
        String[] stringArray = pref.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            try {
                this.chartConfig.add(ChartDetails.valueOf(key));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private void addConfigButton(final Composite buttons) {
        Button b = new Button(buttons, 0x800000);
        b.setImage(Images.CONFIG.image());
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SecuritiesChart.this.contextMenu == null) {
                    MenuManager menuMgr = new MenuManager("#PopupMenu");
                    menuMgr.setRemoveAllWhenShown(true);
                    menuMgr.addMenuListener(arg_0 -> SecuritiesChart.access$0(SecuritiesChart.this, arg_0));
                    SecuritiesChart.this.contextMenu = menuMgr.createContextMenu((Control)buttons.getShell());
                    buttons.addDisposeListener(event -> SecuritiesChart.this.contextMenu.dispose());
                }
                SecuritiesChart.this.contextMenu.setVisible(true);
            }
        });
    }

    private void chartConfigAboutToShow(IMenuManager manager) {
        MenuManager subMenuChartScaling = new MenuManager(Messages.LabelChartDetailChartScaling, null);
        MenuManager subMenuChartDevelopment = new MenuManager(Messages.LabelChartDetailChartDevelopment, null);
        MenuManager subMenuChartMarker = new MenuManager(Messages.LabelChartDetailMarker, null);
        MenuManager subMenuChartIndicator = new MenuManager(Messages.LabelChartDetailIndicator, null);
        MenuManager subMenuChartMovingAverage = new MenuManager(Messages.LabelChartDetailMovingAverage, null);
        MenuManager subMenuChartMovingAverageSMA = new MenuManager(Messages.LabelChartDetailMovingAverageSMA, null);
        MenuManager subMenuChartMovingAverageEMA = new MenuManager(Messages.LabelChartDetailMovingAverageEMA, null);
        MenuManager subMenuChartSettings = new MenuManager(Messages.LabelChartDetailSettings, null);
        subMenuChartScaling.add((IAction)this.addMenuAction(ChartDetails.SCALING_LINEAR));
        subMenuChartScaling.add((IAction)this.addMenuAction(ChartDetails.SCALING_LOG));
        subMenuChartDevelopment.add((IAction)this.addMenuAction(ChartDetails.CLOSING));
        subMenuChartDevelopment.add((IAction)this.addMenuAction(ChartDetails.PURCHASEPRICE));
        subMenuChartMarker.add((IAction)this.addMenuAction(ChartDetails.INVESTMENT));
        subMenuChartMarker.add((IAction)this.addMenuAction(ChartDetails.DIVIDENDS));
        subMenuChartMarker.add((IAction)this.addMenuAction(ChartDetails.EVENTS));
        subMenuChartMarker.add((IAction)this.addMenuAction(ChartDetails.EXTREMES));
        subMenuChartMarker.add((IAction)this.addMenuAction(ChartDetails.FIFOPURCHASE));
        subMenuChartMarker.add((IAction)this.addMenuAction(ChartDetails.FLOATINGAVGPURCHASE));
        subMenuChartIndicator.add((IAction)this.addMenuAction(ChartDetails.BOLLINGERBANDS));
        subMenuChartMovingAverageSMA.add((IAction)this.addMenuAction(ChartDetails.SMA_5DAYS));
        subMenuChartMovingAverageSMA.add((IAction)this.addMenuAction(ChartDetails.SMA_20DAYS));
        subMenuChartMovingAverageSMA.add((IAction)this.addMenuAction(ChartDetails.SMA_30DAYS));
        subMenuChartMovingAverageSMA.add((IAction)this.addMenuAction(ChartDetails.SMA_38DAYS));
        subMenuChartMovingAverageSMA.add((IAction)this.addMenuAction(ChartDetails.SMA_50DAYS));
        subMenuChartMovingAverageSMA.add((IAction)this.addMenuAction(ChartDetails.SMA_90DAYS));
        subMenuChartMovingAverageSMA.add((IAction)this.addMenuAction(ChartDetails.SMA_100DAYS));
        subMenuChartMovingAverageSMA.add((IAction)this.addMenuAction(ChartDetails.SMA_200DAYS));
        subMenuChartMovingAverageEMA.add((IAction)this.addMenuAction(ChartDetails.EMA_5DAYS));
        subMenuChartMovingAverageEMA.add((IAction)this.addMenuAction(ChartDetails.EMA_20DAYS));
        subMenuChartMovingAverageEMA.add((IAction)this.addMenuAction(ChartDetails.EMA_30DAYS));
        subMenuChartMovingAverageEMA.add((IAction)this.addMenuAction(ChartDetails.EMA_38DAYS));
        subMenuChartMovingAverageEMA.add((IAction)this.addMenuAction(ChartDetails.EMA_50DAYS));
        subMenuChartMovingAverageEMA.add((IAction)this.addMenuAction(ChartDetails.EMA_90DAYS));
        subMenuChartMovingAverageEMA.add((IAction)this.addMenuAction(ChartDetails.EMA_100DAYS));
        subMenuChartMovingAverageEMA.add((IAction)this.addMenuAction(ChartDetails.EMA_200DAYS));
        subMenuChartSettings.add((IAction)this.addMenuAction(ChartDetails.SHOW_MARKER_LINES));
        subMenuChartSettings.add((IAction)this.addMenuAction(ChartDetails.SHOW_DATA_LABELS));
        subMenuChartSettings.add((IAction)this.addMenuAction(ChartDetails.SHOW_MISSING_TRADING_DAYS));
        manager.add((IContributionItem)subMenuChartScaling);
        manager.add((IContributionItem)subMenuChartDevelopment);
        manager.add((IContributionItem)subMenuChartMarker);
        manager.add((IContributionItem)subMenuChartIndicator);
        manager.add((IContributionItem)subMenuChartMovingAverage);
        subMenuChartMovingAverage.add((IContributionItem)subMenuChartMovingAverageSMA);
        subMenuChartMovingAverage.add((IContributionItem)subMenuChartMovingAverageEMA);
        manager.add((IContributionItem)subMenuChartSettings);
    }

    private Action addMenuAction(ChartDetails detail) {
        SimpleAction action = new SimpleAction(detail.toString(), a -> {
            boolean isActive = this.chartConfig.contains((Object)detail);
            if (isActive) {
                this.chartConfig.remove((Object)detail);
            } else {
                this.chartConfig.add(detail);
            }
            if (!isActive) {
                switch (detail) {
                    case SCALING_LINEAR: {
                        this.chartConfig.remove((Object)ChartDetails.SCALING_LOG);
                        break;
                    }
                    case SCALING_LOG: {
                        this.chartConfig.remove((Object)ChartDetails.SCALING_LINEAR);
                        this.chartConfig.remove((Object)ChartDetails.PURCHASEPRICE);
                        this.chartConfig.remove((Object)ChartDetails.CLOSING);
                        break;
                    }
                    case CLOSING: {
                        this.chartConfig.remove((Object)ChartDetails.PURCHASEPRICE);
                        this.chartConfig.remove((Object)ChartDetails.SCALING_LOG);
                        break;
                    }
                    case PURCHASEPRICE: {
                        this.chartConfig.remove((Object)ChartDetails.CLOSING);
                        this.chartConfig.remove((Object)ChartDetails.SCALING_LOG);
                        break;
                    }
                }
            }
            if (!this.chartConfig.contains((Object)ChartDetails.SCALING_LINEAR) && !this.chartConfig.contains((Object)ChartDetails.SCALING_LOG)) {
                this.chartConfig.add(ChartDetails.SCALING_LINEAR);
            }
            ReadOnlyClient.unwrap((Client)this.client).setProperty(PREF_KEY, String.join((CharSequence)",", this.chartConfig.stream().map(Enum::name).collect(Collectors.toList())));
            this.updateChart();
        });
        action.setChecked(this.chartConfig.contains((Object)detail));
        return action;
    }

    private void addButton(Composite buttons, String label, String toolTip, Function<Security, ChartInterval> interval) {
        Button b = new Button(buttons, 0x800000);
        b.setText(label);
        b.setToolTipText(toolTip);
        b.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            this.chartIntervalFunction = interval;
            this.updateChart();
        }));
    }

    public void setClient(Client client) {
        this.client = client;
        this.updateChart();
    }

    public void updateChart(Security security) {
        this.security = security;
        this.updateChart();
    }

    private void updateChart() {
        this.chart.setRedraw(false);
        try {
            List prices;
            ChartRange range;
            ISeries[] series;
            ISeries[] iSeriesArray = series = this.chart.getSeriesSet().getSeries();
            int n = series.length;
            int n2 = 0;
            while (n2 < n) {
                ISeries s = iSeriesArray[n2];
                this.chart.getSeriesSet().deleteSeries(s.getId());
                ++n2;
            }
            this.chart.clearMarkerLines();
            this.chart.clearNonTradingDayMarker();
            this.customPaintListeners.clear();
            this.customBehindPaintListener.clear();
            this.customTooltipEvents.clear();
            if (this.security == null || this.security.getPrices().isEmpty()) {
                this.chart.getTitle().setText(this.security == null ? "..." : this.security.getName());
                this.chart.redraw();
                return;
            }
            this.chart.getTitle().setText(this.security.getName());
            boolean showAreaRelativeToFirstQuote = this.chartConfig.contains((Object)ChartDetails.CLOSING) || this.chartConfig.contains((Object)ChartDetails.PURCHASEPRICE);
            ChartInterval chartInterval = null;
            if (this.chartIntervalFunction != null) {
                chartInterval = this.chartIntervalFunction.apply(this.security);
            }
            if (chartInterval == null) {
                chartInterval = new ChartInterval(LocalDate.now().minusYears(2L), LocalDate.now());
            }
            if ((range = ChartRange.createFor(prices = this.security.getPricesIncludingLatest(), chartInterval)) == null) {
                this.chart.redraw();
                return;
            }
            LocalDate[] dates = new LocalDate[range.size];
            double[] values = new double[range.size];
            double[] valuesRelative = new double[range.size];
            double[] valuesRelativePositive = new double[range.size];
            double[] valuesRelativeNegative = new double[range.size];
            double[] valuesZeroLine = new double[range.size];
            double firstQuote = 0.0;
            int n3 = this.swtAntialias = range.size > 1000 ? 0 : 1;
            if (!this.chartConfig.contains((Object)ChartDetails.PURCHASEPRICE)) {
                SecurityPrice p2 = (SecurityPrice)prices.get(range.start);
                firstQuote = (double)p2.getValue() / Values.Quote.divider();
            } else {
                Optional<Double> purchasePrice = this.getLatestPurchasePrice();
                if (purchasePrice.isPresent()) {
                    firstQuote = purchasePrice.get();
                } else {
                    showAreaRelativeToFirstQuote = false;
                }
            }
            this.addChartMarkerBackground(chartInterval);
            int ii = 0;
            while (ii < range.size) {
                SecurityPrice p = (SecurityPrice)prices.get(ii + range.start);
                dates[ii] = p.getDate();
                values[ii] = (double)p.getValue() / Values.Quote.divider();
                if (showAreaRelativeToFirstQuote) {
                    valuesRelative[ii] = (double)p.getValue() / Values.Quote.divider() - firstQuote;
                    valuesZeroLine[ii] = 0.0;
                    if (valuesRelative[ii] >= 0.0) {
                        valuesRelativePositive[ii] = valuesRelative[ii];
                        valuesRelativeNegative[ii] = 0.0;
                    } else {
                        valuesRelativePositive[ii] = 0.0;
                        valuesRelativeNegative[ii] = valuesRelative[ii];
                    }
                }
                ++ii;
            }
            Date[] javaDates = TimelineChart.toJavaUtilDate(dates);
            if (showAreaRelativeToFirstQuote) {
                ILineSeries lineSeries2ndNegative = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(Messages.LabelChartDetailChartDevelopmentClosing) + "Negative");
                lineSeries2ndNegative.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                lineSeries2ndNegative.setYAxisId(1);
                this.configureSeriesPainter(lineSeries2ndNegative, javaDates, valuesRelativeNegative, colorAreaNegative, 1, LineStyle.SOLID, true, false);
                ILineSeries lineSeries2ndPositive = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(Messages.LabelChartDetailChartDevelopmentClosing) + "Positive");
                lineSeries2ndPositive.setSymbolType(ILineSeries.PlotSymbolType.NONE);
                lineSeries2ndPositive.setYAxisId(1);
                this.configureSeriesPainter(lineSeries2ndPositive, javaDates, valuesRelativePositive, colorAreaPositive, 1, LineStyle.SOLID, true, false);
            }
            ILineSeries lineSeries = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, Messages.ColumnQuote);
            lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            this.configureSeriesPainter(lineSeries, javaDates, values, colorQuote, 2, LineStyle.SOLID, !showAreaRelativeToFirstQuote, false);
            this.chart.adjustRange();
            this.addChartMarkerForeground(chartInterval);
            this.chart.adjustRange();
            IAxis yAxis1st = this.chart.getAxisSet().getYAxis(0);
            IAxis yAxis2nd = this.chart.getAxisSet().getYAxis(1);
            yAxis2nd.setRange(new Range(yAxis1st.getRange().lower - firstQuote, yAxis1st.getRange().upper - firstQuote));
            yAxis1st.enableLogScale(this.chartConfig.contains((Object)ChartDetails.SCALING_LOG));
            yAxis2nd.enableLogScale(this.chartConfig.contains((Object)ChartDetails.SCALING_LOG));
            yAxis1st.getTick().setVisible(true);
            if (this.chartConfig.contains((Object)ChartDetails.SHOW_MISSING_TRADING_DAYS)) {
                TradeCalendar tradeCalendar = TradeCalendarManager.getInstance((Security)this.security);
                ArrayList<LocalDate> calendarDates = new ArrayList<LocalDate>();
                LocalDate calendarDate = dates[0];
                while (calendarDate.isBefore(dates[dates.length - 1])) {
                    calendarDates.add(calendarDate);
                    calendarDate = calendarDate.plusDays(1L);
                }
                LocalDate[] localDateArray = dates;
                int n4 = dates.length;
                int n5 = 0;
                while (n5 < n4) {
                    LocalDate pricingDate = localDateArray[n5];
                    calendarDates.remove(pricingDate);
                    ++n5;
                }
                for (LocalDate targetDate : calendarDates) {
                    if (tradeCalendar.isHoliday(targetDate)) continue;
                    this.chart.addNonTradingDayMarker(targetDate, colorNonTradingDay);
                }
            }
        }
        finally {
            this.chart.setRedraw(true);
            this.chart.redraw();
        }
    }

    private void addChartMarkerBackground(ChartInterval chartInterval) {
        if (this.chartConfig.contains((Object)ChartDetails.BOLLINGERBANDS)) {
            this.addBollingerBandsMarkerLines(chartInterval, 20, 2.0);
        }
        if (this.chartConfig.contains((Object)ChartDetails.SMA_5DAYS)) {
            this.addSMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageSMA, Messages.LabelChartDetailMovingAverage_5days, 5, colorSMA1);
        }
        if (this.chartConfig.contains((Object)ChartDetails.SMA_20DAYS)) {
            this.addSMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageSMA, Messages.LabelChartDetailMovingAverage_20days, 20, colorSMA2);
        }
        if (this.chartConfig.contains((Object)ChartDetails.SMA_30DAYS)) {
            this.addSMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageSMA, Messages.LabelChartDetailMovingAverage_30days, 30, colorSMA3);
        }
        if (this.chartConfig.contains((Object)ChartDetails.SMA_38DAYS)) {
            this.addSMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageSMA, Messages.LabelChartDetailMovingAverage_38days, 38, colorSMA4);
        }
        if (this.chartConfig.contains((Object)ChartDetails.SMA_50DAYS)) {
            this.addSMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageSMA, Messages.LabelChartDetailMovingAverage_50days, 50, colorSMA4);
        }
        if (this.chartConfig.contains((Object)ChartDetails.SMA_90DAYS)) {
            this.addSMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageSMA, Messages.LabelChartDetailMovingAverage_90days, 90, colorSMA5);
        }
        if (this.chartConfig.contains((Object)ChartDetails.SMA_100DAYS)) {
            this.addSMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageSMA, Messages.LabelChartDetailMovingAverage_100days, 100, colorSMA6);
        }
        if (this.chartConfig.contains((Object)ChartDetails.SMA_200DAYS)) {
            this.addSMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageSMA, Messages.LabelChartDetailMovingAverage_200days, 200, colorSMA7);
        }
        if (this.chartConfig.contains((Object)ChartDetails.EMA_5DAYS)) {
            this.addEMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageEMA, Messages.LabelChartDetailMovingAverage_5days, 5, colorEMA1);
        }
        if (this.chartConfig.contains((Object)ChartDetails.EMA_20DAYS)) {
            this.addEMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageEMA, Messages.LabelChartDetailMovingAverage_20days, 20, colorEMA2);
        }
        if (this.chartConfig.contains((Object)ChartDetails.EMA_30DAYS)) {
            this.addEMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageEMA, Messages.LabelChartDetailMovingAverage_30days, 30, colorEMA3);
        }
        if (this.chartConfig.contains((Object)ChartDetails.EMA_38DAYS)) {
            this.addEMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageEMA, Messages.LabelChartDetailMovingAverage_38days, 38, colorEMA4);
        }
        if (this.chartConfig.contains((Object)ChartDetails.EMA_50DAYS)) {
            this.addEMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageEMA, Messages.LabelChartDetailMovingAverage_50days, 50, colorEMA4);
        }
        if (this.chartConfig.contains((Object)ChartDetails.EMA_90DAYS)) {
            this.addEMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageEMA, Messages.LabelChartDetailMovingAverage_90days, 90, colorEMA5);
        }
        if (this.chartConfig.contains((Object)ChartDetails.EMA_100DAYS)) {
            this.addEMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageEMA, Messages.LabelChartDetailMovingAverage_100days, 100, colorEMA6);
        }
        if (this.chartConfig.contains((Object)ChartDetails.EMA_200DAYS)) {
            this.addEMAMarkerLines(chartInterval, Messages.LabelChartDetailMovingAverageEMA, Messages.LabelChartDetailMovingAverage_200days, 200, colorEMA7);
        }
    }

    private void addChartMarkerForeground(ChartInterval chartInterval) {
        if (this.chartConfig.contains((Object)ChartDetails.FIFOPURCHASE)) {
            this.addFIFOPurchasePrice(chartInterval);
        }
        if (this.chartConfig.contains((Object)ChartDetails.FLOATINGAVGPURCHASE)) {
            this.addMovingAveragePurchasePrice(chartInterval);
        }
        if (this.chartConfig.contains((Object)ChartDetails.INVESTMENT)) {
            this.addInvestmentMarkerLines(chartInterval);
        }
        if (this.chartConfig.contains((Object)ChartDetails.DIVIDENDS)) {
            this.addDividendMarkerLines(chartInterval);
        }
        if (this.chartConfig.contains((Object)ChartDetails.EVENTS)) {
            this.addEventMarkerLines(chartInterval);
        }
        if (this.chartConfig.contains((Object)ChartDetails.EXTREMES)) {
            this.addExtremesMarkerLines(chartInterval);
        }
    }

    private void addSMAMarkerLines(ChartInterval chartInterval, String smaSeries, String smaDaysWording, int smaDays, Color smaColor) {
        ChartLineSeriesAxes smaLines = new SimpleMovingAverage(smaDays, this.security, chartInterval).getSMA();
        if (smaLines == null || smaLines.getValues() == null || smaLines.getDates() == null) {
            return;
        }
        String lineID = String.valueOf(smaSeries) + " (" + smaDaysWording + ")";
        ILineSeries lineSeriesSMA = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, lineID);
        lineSeriesSMA.setXDateSeries(smaLines.getDates());
        lineSeriesSMA.setLineWidth(2);
        lineSeriesSMA.enableArea(false);
        lineSeriesSMA.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeriesSMA.setYSeries(smaLines.getValues());
        lineSeriesSMA.setAntialias(this.swtAntialias);
        lineSeriesSMA.setLineColor(smaColor);
        lineSeriesSMA.setYAxisId(0);
        lineSeriesSMA.setVisibleInLegend(true);
    }

    private void addEMAMarkerLines(ChartInterval chartInterval, String emaSeries, String emaDaysWording, int emaDays, Color emaColor) {
        ChartLineSeriesAxes emaLines = new ExponentialMovingAverage(emaDays, this.security, chartInterval).getEMA();
        if (emaLines == null || emaLines.getValues() == null || emaLines.getDates() == null) {
            return;
        }
        String lineID = String.valueOf(emaSeries) + " (" + emaDaysWording + ")";
        ILineSeries lineSeriesEMA = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, lineID);
        lineSeriesEMA.setXDateSeries(emaLines.getDates());
        lineSeriesEMA.setLineWidth(2);
        lineSeriesEMA.enableArea(false);
        lineSeriesEMA.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeriesEMA.setYSeries(emaLines.getValues());
        lineSeriesEMA.setAntialias(this.swtAntialias);
        lineSeriesEMA.setLineColor(emaColor);
        lineSeriesEMA.setYAxisId(0);
        lineSeriesEMA.setVisibleInLegend(true);
    }

    private void addInvestmentMarkerLines(ChartInterval chartInterval) {
        List<PortfolioTransaction> purchase = this.client.getPortfolios().stream().flatMap(p -> p.getTransactions().stream()).filter(t -> t.getSecurity() == this.security).filter(t -> t.getType() == PortfolioTransaction.Type.BUY || t.getType() == PortfolioTransaction.Type.DELIVERY_INBOUND).filter(t -> chartInterval.contains(t.getDateTime())).sorted((Comparator<PortfolioTransaction>)new Transaction.ByDate()).collect(Collectors.toList());
        this.addInvestmentMarkers(purchase, Messages.SecurityMenuBuy, colorEventPurchase);
        List<PortfolioTransaction> sales = this.client.getPortfolios().stream().flatMap(p -> p.getTransactions().stream()).filter(t -> t.getSecurity() == this.security).filter(t -> t.getType() == PortfolioTransaction.Type.SELL || t.getType() == PortfolioTransaction.Type.DELIVERY_OUTBOUND).filter(t -> chartInterval.contains(t.getDateTime())).sorted((Comparator<PortfolioTransaction>)new Transaction.ByDate()).collect(Collectors.toList());
        this.addInvestmentMarkers(sales, Messages.SecurityMenuSell, colorEventSale);
    }

    private void addInvestmentMarkers(List<PortfolioTransaction> transactions, String seriesLabel, Color color) {
        if (transactions.isEmpty()) {
            return;
        }
        this.customTooltipEvents.addAll(transactions);
        if (this.chartConfig.contains((Object)ChartDetails.SHOW_MARKER_LINES)) {
            transactions.forEach(t -> {
                String label = Values.Share.format((Object)(t.getType().isPurchase() ? t.getShares() : -t.getShares()));
                double value = (double)t.getGrossPricePerShare(this.converter.with(t.getSecurity().getCurrencyCode())).getAmount() / Values.Quote.divider();
                this.chart.addMarkerLine(t.getDateTime().toLocalDate(), color, label, value);
            });
        } else {
            Date[] dates = transactions.stream().map(Transaction::getDateTime).map(d -> Date.from(d.atZone(ZoneId.systemDefault()).toInstant())).collect(Collectors.toList()).toArray(new Date[0]);
            double[] values = transactions.stream().mapToDouble(t -> (double)t.getGrossPricePerShare(this.converter.with(t.getSecurity().getCurrencyCode())).getAmount() / Values.Quote.divider()).toArray();
            ILineSeries border = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(seriesLabel) + "2");
            border.setYAxisId(0);
            border.setSymbolColor(Display.getDefault().getSystemColor(2));
            border.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
            border.setSymbolSize(7);
            this.configureSeriesPainter(border, dates, values, null, 0, LineStyle.NONE, false, false);
            ILineSeries background = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(seriesLabel) + "1");
            background.setYAxisId(0);
            background.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
            background.setSymbolSize(6);
            background.setSymbolColor(Display.getDefault().getSystemColor(1));
            this.configureSeriesPainter(background, dates, values, null, 0, LineStyle.NONE, false, false);
            ILineSeries inner = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, seriesLabel);
            inner.setYAxisId(0);
            inner.setSymbolType(ILineSeries.PlotSymbolType.DIAMOND);
            inner.setSymbolSize(4);
            inner.setSymbolColor(color);
            this.configureSeriesPainter(inner, dates, values, color, 0, LineStyle.NONE, false, true);
            if (this.chartConfig.contains((Object)ChartDetails.SHOW_DATA_LABELS)) {
                this.customPaintListeners.add(event -> {
                    IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
                    IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
                    int index = 0;
                    while (index < dates.length) {
                        int x = xAxis.getPixelCoordinate((double)dates[index].getTime());
                        int y = yAxis.getPixelCoordinate(values[index]);
                        PortfolioTransaction t = (PortfolioTransaction)transactions.get(index);
                        String label = Values.Share.format((Object)(t.getType().isPurchase() ? t.getShares() : -t.getShares()));
                        Point textExtent = event.gc.textExtent(label);
                        event.gc.setForeground(Colors.theme().defaultForeground());
                        event.gc.drawText(label, x - textExtent.x / 2, y + 10, true);
                        ++index;
                    }
                });
            }
        }
    }

    private void addDividendMarkerLines(ChartInterval chartInterval) {
        List<AccountTransaction> dividends = this.client.getAccounts().stream().flatMap(a -> a.getTransactions().stream()).filter(t -> t.getSecurity() == this.security).filter(t -> t.getType() == AccountTransaction.Type.DIVIDENDS).filter(t -> chartInterval.contains(t.getDateTime())).sorted((Comparator<AccountTransaction>)new Transaction.ByDate()).collect(Collectors.toList());
        if (dividends.isEmpty()) {
            return;
        }
        this.customTooltipEvents.addAll(dividends);
        if (this.chartConfig.contains((Object)ChartDetails.SHOW_MARKER_LINES)) {
            dividends.forEach(t -> this.chart.addMarkerLine(t.getDateTime().toLocalDate(), colorEventDividend, this.getDividendLabel((AccountTransaction)t)));
        } else {
            Date[] dates = dividends.stream().map(Transaction::getDateTime).map(d -> Date.from(d.atZone(ZoneId.systemDefault()).toInstant())).collect(Collectors.toList()).toArray(new Date[0]);
            IAxis yAxis1st = this.chart.getAxisSet().getYAxis(0);
            double yAxis1stAxisPrice = yAxis1st.getRange().lower;
            double[] values = new double[dates.length];
            Arrays.fill(values, yAxis1stAxisPrice);
            ILineSeries border = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(Messages.LabelChartDetailMarkerDividends) + "2");
            border.setYAxisId(0);
            border.setSymbolType(ILineSeries.PlotSymbolType.SQUARE);
            border.setSymbolSize(6);
            border.setSymbolColor(Display.getDefault().getSystemColor(2));
            this.configureSeriesPainter(border, dates, values, null, 0, LineStyle.NONE, false, false);
            ILineSeries background = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, String.valueOf(Messages.LabelChartDetailMarkerDividends) + "1");
            background.setYAxisId(0);
            background.setSymbolType(ILineSeries.PlotSymbolType.SQUARE);
            background.setSymbolSize(5);
            background.setSymbolColor(Display.getDefault().getSystemColor(1));
            this.configureSeriesPainter(background, dates, values, null, 0, LineStyle.NONE, false, false);
            ILineSeries inner = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, Messages.LabelChartDetailMarkerDividends);
            inner.setYAxisId(0);
            inner.setSymbolType(ILineSeries.PlotSymbolType.SQUARE);
            inner.setSymbolSize(3);
            inner.setSymbolColor(colorEventDividend);
            this.configureSeriesPainter(inner, dates, values, null, 0, LineStyle.NONE, false, true);
            if (this.chartConfig.contains((Object)ChartDetails.SHOW_DATA_LABELS)) {
                this.customPaintListeners.add(event -> {
                    IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
                    IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
                    int index = 0;
                    while (index < dates.length) {
                        int x = xAxis.getPixelCoordinate((double)dates[index].getTime());
                        int y = yAxis.getPixelCoordinate(values[index]);
                        String label = this.getDividendLabel((AccountTransaction)dividends.get(index));
                        Point textExtent = event.gc.textExtent(label);
                        event.gc.setForeground(Colors.theme().defaultForeground());
                        event.gc.drawText(label, x - textExtent.x / 2, y - 22, true);
                        ++index;
                    }
                });
            }
        }
    }

    private String getDividendLabel(AccountTransaction t) {
        if (t.getShares() == 0L) {
            return "\u2211 " + t.getGrossValue().toString();
        }
        Optional grossValue = t.getUnit(Transaction.Unit.Type.GROSS_VALUE);
        long gross = grossValue.isPresent() ? ((Transaction.Unit)grossValue.get()).getForex().getAmount() : t.getGrossValueAmount();
        long perShare = Math.round((double)gross * Values.Share.divider() * (double)Values.Quote.factorToMoney() / (double)t.getShares());
        return Values.Quote.format(Long.valueOf(perShare));
    }

    private void addEventMarkerLines(ChartInterval chartInterval) {
        this.security.getEvents().stream().filter(e -> chartInterval.contains(e.getDate())).filter(e -> e.getType() != SecurityEvent.Type.DIVIDEND_PAYMENT).forEach(e -> this.chart.addMarkerLine(e.getDate(), Display.getDefault().getSystemColor(16), e.getDetails()));
    }

    private void addExtremesMarkerLines(ChartInterval chartInterval) {
        Optional<SecurityPrice> max = this.security.getPricesIncludingLatest().stream().filter(p -> chartInterval.contains(p.getDate())).max(Comparator.comparing(SecurityPrice::getValue));
        Optional<SecurityPrice> min = this.security.getPricesIncludingLatest().stream().filter(p -> chartInterval.contains(p.getDate())).min(Comparator.comparing(SecurityPrice::getValue));
        max.ifPresent(high -> this.addExtremeMarker((SecurityPrice)high, ILineSeries.PlotSymbolType.TRIANGLE, 10, Messages.LabelChartDetailMarkerHigh, colorHigh));
        min.ifPresent(low -> this.addExtremeMarker((SecurityPrice)low, ILineSeries.PlotSymbolType.INVERTED_TRIANGLE, -25, Messages.LabelChartDetailMarkerLow, colorLow));
    }

    private void addExtremeMarker(SecurityPrice price, ILineSeries.PlotSymbolType plotSymbolType, int labelOffset, String seriesLabel, Color color) {
        LocalDate eventDate = price.getDate();
        String valueFormat = Values.Quote.format(Long.valueOf(price.getValue()));
        double value = (double)price.getValue() / Values.Quote.divider();
        if (this.chartConfig.contains((Object)ChartDetails.SHOW_MARKER_LINES)) {
            this.chart.addMarkerLine(eventDate, color, valueFormat);
        } else {
            Date zonedDate = Date.from(eventDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
            ILineSeries inner = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, seriesLabel);
            inner.setYAxisId(0);
            inner.setSymbolType(plotSymbolType);
            inner.setSymbolSize(6);
            inner.setSymbolColor(color);
            this.configureSeriesPainter(inner, new Date[]{zonedDate}, new double[]{value}, color, 0, LineStyle.NONE, false, true);
            if (this.chartConfig.contains((Object)ChartDetails.SHOW_DATA_LABELS)) {
                this.customPaintListeners.add(event -> {
                    IAxis xAxis = this.chart.getAxisSet().getXAxis(0);
                    IAxis yAxis = this.chart.getAxisSet().getYAxis(0);
                    int x = xAxis.getPixelCoordinate((double)zonedDate.getTime());
                    int y = yAxis.getPixelCoordinate(value);
                    Point textExtent = event.gc.textExtent(valueFormat);
                    event.gc.setForeground(Colors.theme().defaultForeground());
                    event.gc.drawText(valueFormat, x - textExtent.x / 2, y + labelOffset, true);
                });
            }
        }
    }

    private void addBollingerBandsMarkerLines(ChartInterval chartInterval, int bollingerBandsDays, double bollingerBandsFactor) {
        BollingerBands bands = new BollingerBands(bollingerBandsDays, bollingerBandsFactor, this.security, chartInterval);
        ChartLineSeriesAxes lowerBand = bands.getLowerBand();
        if (lowerBand == null || lowerBand.getValues() == null || lowerBand.getDates() == null) {
            return;
        }
        ILineSeries lineSeriesBollingerBandsLowerBand = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, Messages.LabelChartDetailIndicatorBollingerBandsLower);
        lineSeriesBollingerBandsLowerBand.setXDateSeries(lowerBand.getDates());
        lineSeriesBollingerBandsLowerBand.setLineStyle(LineStyle.SOLID);
        lineSeriesBollingerBandsLowerBand.setLineWidth(2);
        lineSeriesBollingerBandsLowerBand.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeriesBollingerBandsLowerBand.setYSeries(lowerBand.getValues());
        lineSeriesBollingerBandsLowerBand.setAntialias(this.swtAntialias);
        lineSeriesBollingerBandsLowerBand.setLineColor(colorBollingerBands);
        lineSeriesBollingerBandsLowerBand.setYAxisId(0);
        lineSeriesBollingerBandsLowerBand.setVisibleInLegend(false);
        ChartLineSeriesAxes middleBand = bands.getMiddleBand();
        ILineSeries lineSeriesBollingerBandsMiddleBand = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, Messages.LabelChartDetailIndicatorBollingerBands);
        lineSeriesBollingerBandsMiddleBand.setXDateSeries(middleBand.getDates());
        lineSeriesBollingerBandsMiddleBand.setLineWidth(2);
        lineSeriesBollingerBandsMiddleBand.setLineStyle(LineStyle.DOT);
        lineSeriesBollingerBandsMiddleBand.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeriesBollingerBandsMiddleBand.setYSeries(middleBand.getValues());
        lineSeriesBollingerBandsMiddleBand.setAntialias(this.swtAntialias);
        lineSeriesBollingerBandsMiddleBand.setLineColor(colorBollingerBands);
        lineSeriesBollingerBandsMiddleBand.setYAxisId(0);
        lineSeriesBollingerBandsMiddleBand.setVisibleInLegend(true);
        ChartLineSeriesAxes upperBand = bands.getUpperBand();
        ILineSeries lineSeriesBollingerBandsUpperBand = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, Messages.LabelChartDetailIndicatorBollingerBandsUpper);
        lineSeriesBollingerBandsUpperBand.setXDateSeries(upperBand.getDates());
        lineSeriesBollingerBandsUpperBand.setLineWidth(2);
        lineSeriesBollingerBandsUpperBand.setLineStyle(LineStyle.SOLID);
        lineSeriesBollingerBandsUpperBand.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeriesBollingerBandsUpperBand.setYSeries(upperBand.getValues());
        lineSeriesBollingerBandsUpperBand.setAntialias(this.swtAntialias);
        lineSeriesBollingerBandsUpperBand.setLineColor(colorBollingerBands);
        lineSeriesBollingerBandsUpperBand.setYAxisId(0);
        lineSeriesBollingerBandsUpperBand.setVisibleInLegend(false);
    }

    private void addFIFOPurchasePrice(ChartInterval chartInterval) {
        if (this.security.getCurrencyCode() == null) {
            return;
        }
        Client filteredClient = new ClientSecurityFilter(new Security[]{this.security}).filter(this.client);
        CurrencyConverter securityCurrency = this.converter.with(this.security.getCurrencyCode());
        List candidates = this.client.getPortfolios().stream().flatMap(p -> p.getTransactions().stream()).filter(t -> t.getSecurity().equals(this.security)).filter(t -> t.getType() != PortfolioTransaction.Type.TRANSFER_IN && t.getType() != PortfolioTransaction.Type.TRANSFER_OUT).filter(t -> !t.getDateTime().toLocalDate().isAfter(chartInterval.getEnd())).map(t -> chartInterval.contains(t.getDateTime()) ? t.getDateTime().toLocalDate() : chartInterval.getStart()).distinct().sorted().collect(Collectors.toList());
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        int seriesCounter = 0;
        for (LocalDate eventDate : candidates) {
            Optional<Double> purchasePrice = this.getPurchasePrice(filteredClient, securityCurrency, eventDate);
            if (purchasePrice.isPresent()) {
                dates.add(eventDate);
                values.add(purchasePrice.get());
                continue;
            }
            if (!dates.isEmpty()) {
                dates.add(eventDate);
                values.add((Double)values.get(values.size() - 1));
                this.createFIFOPurchaseLineSeries(values, dates, seriesCounter++);
                values.clear();
                dates.clear();
                continue;
            }
            dates.isEmpty();
        }
        this.getPurchasePrice(filteredClient, securityCurrency, chartInterval.getEnd()).ifPresent(price -> {
            dates.add(chartInterval.getEnd());
            values.add((Double)price);
        });
        if (!dates.isEmpty()) {
            this.createFIFOPurchaseLineSeries(values, dates, seriesCounter);
        }
    }

    private void createFIFOPurchaseLineSeries(List<Double> values, List<LocalDate> dates, int seriesCounter) {
        String label = seriesCounter == 0 ? Messages.LabelChartDetailMarkerPurchaseFIFO : MessageFormat.format((String)Messages.LabelChartDetailMarkerPurchaseFIFOHoldingPeriod, (Object[])new Object[]{seriesCounter + 1});
        ILineSeries series = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, label);
        series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        series.setYAxisId(0);
        series.enableStep(true);
        this.configureSeriesPainter(series, TimelineChart.toJavaUtilDate(dates.toArray(new LocalDate[0])), Doubles.toArray(values), colorFifoPurchasePrice, 2, LineStyle.SOLID, false, seriesCounter == 0);
    }

    private void addMovingAveragePurchasePrice(ChartInterval chartInterval) {
        if (this.security.getCurrencyCode() == null) {
            return;
        }
        Client filteredClient = new ClientSecurityFilter(new Security[]{this.security}).filter(this.client);
        CurrencyConverter securityCurrency = this.converter.with(this.security.getCurrencyCode());
        List candidates = this.client.getPortfolios().stream().flatMap(p -> p.getTransactions().stream()).filter(t -> t.getSecurity().equals(this.security)).filter(t -> t.getType() != PortfolioTransaction.Type.TRANSFER_IN && t.getType() != PortfolioTransaction.Type.TRANSFER_OUT).filter(t -> !t.getDateTime().toLocalDate().isAfter(chartInterval.getEnd())).map(t -> chartInterval.contains(t.getDateTime()) ? t.getDateTime().toLocalDate() : chartInterval.getStart()).distinct().sorted().collect(Collectors.toList());
        ArrayList<Double> values = new ArrayList<Double>();
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        int seriesCounter = 0;
        for (LocalDate eventDate : candidates) {
            Optional<Double> purchasePrice = this.getMovingAveragePurchasePrice(filteredClient, securityCurrency, eventDate);
            if (purchasePrice.isPresent()) {
                dates.add(eventDate);
                values.add(purchasePrice.get());
                continue;
            }
            if (!dates.isEmpty()) {
                dates.add(eventDate);
                values.add((Double)values.get(values.size() - 1));
                this.createMovingAveragePurchaseLineSeries(values, dates, seriesCounter++);
                values.clear();
                dates.clear();
                continue;
            }
            dates.isEmpty();
        }
        this.getMovingAveragePurchasePrice(filteredClient, securityCurrency, chartInterval.getEnd()).ifPresent(price -> {
            dates.add(chartInterval.getEnd());
            values.add((Double)price);
        });
        if (!dates.isEmpty()) {
            this.createMovingAveragePurchaseLineSeries(values, dates, seriesCounter);
        }
    }

    private void createMovingAveragePurchaseLineSeries(List<Double> values, List<LocalDate> dates, int seriesCounter) {
        String label = seriesCounter == 0 ? Messages.LabelChartDetailMarkerPurchaseMovingAverage : MessageFormat.format((String)Messages.LabelChartDetailMarkerPurchaseMovingAverageHoldingPeriod, (Object[])new Object[]{seriesCounter + 1});
        ILineSeries series = (ILineSeries)this.chart.getSeriesSet().createSeries(ISeries.SeriesType.LINE, label);
        series.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        series.setYAxisId(0);
        series.enableStep(true);
        this.configureSeriesPainter(series, TimelineChart.toJavaUtilDate(dates.toArray(new LocalDate[0])), Doubles.toArray(values), colorMovingAveragePurchasePrice, 2, LineStyle.SOLID, false, seriesCounter == 0);
    }

    private Optional<Double> getLatestPurchasePrice() {
        if (this.security.getCurrencyCode() == null) {
            return Optional.empty();
        }
        return this.getPurchasePrice(new ClientSecurityFilter(new Security[]{this.security}).filter(this.client), this.converter.with(this.security.getCurrencyCode()), LocalDate.now());
    }

    private Optional<Double> getPurchasePrice(Client filteredClient, CurrencyConverter currencyConverter, LocalDate date) {
        return SecurityPerformanceSnapshot.create((Client)filteredClient, (CurrencyConverter)currencyConverter, (Interval)Interval.of((LocalDate)LocalDate.MIN, (LocalDate)date), (Class[])new Class[]{SecurityPerformanceIndicator.Costs.class}).getRecord(this.security).filter(r -> !r.getFifoCostPerSharesHeld().isZero()).map(r -> (double)r.getFifoCostPerSharesHeld().getAmount() / Values.Quote.divider());
    }

    private Optional<Double> getMovingAveragePurchasePrice(Client filteredClient, CurrencyConverter currencyConverter, LocalDate date) {
        return SecurityPerformanceSnapshot.create((Client)filteredClient, (CurrencyConverter)currencyConverter, (Interval)Interval.of((LocalDate)LocalDate.MIN, (LocalDate)date), (Class[])new Class[]{SecurityPerformanceIndicator.Costs.class}).getRecord(this.security).filter(r -> !r.getFifoCostPerSharesHeld().isZero()).map(r -> (double)r.getMovingAverageCostPerSharesHeld().getAmount() / Values.Quote.divider());
    }

    static /* synthetic */ void access$0(SecuritiesChart securitiesChart, IMenuManager iMenuManager) {
        securitiesChart.chartConfigAboutToShow(iMenuManager);
    }

    private static enum ChartDetails {
        SCALING_LINEAR(Messages.LabelChartDetailChartScalingLinear),
        SCALING_LOG(Messages.LabelChartDetailChartScalingLog),
        CLOSING(Messages.LabelChartDetailChartDevelopmentClosing),
        PURCHASEPRICE(Messages.LabelChartDetailChartDevelopmentClosingFIFO),
        INVESTMENT(Messages.LabelChartDetailMarkerInvestments),
        DIVIDENDS(Messages.LabelChartDetailMarkerDividends),
        EVENTS(Messages.LabelChartDetailMarkerSplits),
        EXTREMES(Messages.LabelChartDetailMarkerHighLow),
        FIFOPURCHASE(Messages.LabelChartDetailMarkerPurchaseFIFO),
        FLOATINGAVGPURCHASE(Messages.LabelChartDetailMarkerPurchaseMovingAverage),
        BOLLINGERBANDS(Messages.LabelChartDetailIndicatorBollingerBands),
        SMA_5DAYS(Messages.LabelChartDetailMovingAverage_5days),
        SMA_20DAYS(Messages.LabelChartDetailMovingAverage_20days),
        SMA_30DAYS(Messages.LabelChartDetailMovingAverage_30days),
        SMA_38DAYS(Messages.LabelChartDetailMovingAverage_38days),
        SMA_50DAYS(Messages.LabelChartDetailMovingAverage_50days),
        SMA_90DAYS(Messages.LabelChartDetailMovingAverage_90days),
        SMA_100DAYS(Messages.LabelChartDetailMovingAverage_100days),
        SMA_200DAYS(Messages.LabelChartDetailMovingAverage_200days),
        EMA_5DAYS(Messages.LabelChartDetailMovingAverage_5days),
        EMA_20DAYS(Messages.LabelChartDetailMovingAverage_20days),
        EMA_30DAYS(Messages.LabelChartDetailMovingAverage_30days),
        EMA_38DAYS(Messages.LabelChartDetailMovingAverage_38days),
        EMA_50DAYS(Messages.LabelChartDetailMovingAverage_50days),
        EMA_90DAYS(Messages.LabelChartDetailMovingAverage_90days),
        EMA_100DAYS(Messages.LabelChartDetailMovingAverage_100days),
        EMA_200DAYS(Messages.LabelChartDetailMovingAverage_200days),
        SHOW_MARKER_LINES(Messages.LabelChartDetailSettingsShowMarkerLines),
        SHOW_DATA_LABELS(Messages.LabelChartDetailSettingsShowDataLabel),
        SHOW_MISSING_TRADING_DAYS(Messages.LabelChartDetailSettingsShowMissingTradingDays);

        private final String label;

        private ChartDetails(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class ChartInterval {
        private final LocalDate start;
        private final LocalDate end;

        public ChartInterval(LocalDate start, LocalDate end) {
            this.start = start;
            this.end = end;
        }

        public LocalDate getStart() {
            return this.start;
        }

        public LocalDate getEnd() {
            return this.end;
        }

        public boolean contains(LocalDate other) {
            return !other.isBefore(this.start) && !other.isAfter(this.end);
        }

        public boolean contains(LocalDateTime other) {
            return this.contains(other.toLocalDate());
        }
    }

    static class ChartRange {
        public final int start;
        public final int size;

        public ChartRange(int start, int end) {
            this.start = start;
            this.size = end - start;
        }

        public static ChartRange createFor(List<SecurityPrice> prices, ChartInterval chartInterval) {
            int start = Collections.binarySearch(prices, new SecurityPrice(chartInterval.getStart(), 0L), new SecurityPrice.ByDate());
            if (start < 0) {
                start = -start - 1;
            }
            if (start >= prices.size()) {
                return null;
            }
            int end = Collections.binarySearch(prices, new SecurityPrice(chartInterval.getEnd(), 0L), new SecurityPrice.ByDate());
            end = end < 0 ? -end - 1 : ++end;
            if (end <= start) {
                return null;
            }
            return new ChartRange(start, end);
        }
    }

    private static class CustomLayout
    extends Layout {
        private final TimelineChart chart;
        private final Composite buttons;

        public CustomLayout(TimelineChart chart, Composite buttons) {
            this.chart = chart;
            this.buttons = buttons;
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return new Point(wHint, hHint);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle area = composite.getClientArea();
            Point size = this.buttons.computeSize(-1, area.height);
            this.buttons.setBounds(area.x + area.width - size.x, area.y, size.x, area.height);
            this.chart.setBounds(area.x, area.y, area.width - size.x, area.height);
        }
    }
}

