/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.model.Transaction;
import name.abuchen.portfolio.model.TransactionOwner;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.SecurityPosition;
import name.abuchen.portfolio.snapshot.filter.ClientFilter;
import name.abuchen.portfolio.snapshot.security.CalculationLineItem;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceRecord;
import name.abuchen.portfolio.snapshot.security.SecurityPerformanceSnapshot;
import name.abuchen.portfolio.snapshot.trades.TradeCollector;
import name.abuchen.portfolio.snapshot.trades.TradeCollectorException;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.dnd.SecurityDragListener;
import name.abuchen.portfolio.ui.dnd.SecurityTransfer;
import name.abuchen.portfolio.ui.selection.SecuritySelection;
import name.abuchen.portfolio.ui.selection.SelectionService;
import name.abuchen.portfolio.ui.util.ClientFilterMenu;
import name.abuchen.portfolio.ui.util.DropDown;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.LogoManager;
import name.abuchen.portfolio.ui.util.ReportingPeriodDropDown;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.ui.util.TableViewerCSVExporter;
import name.abuchen.portfolio.ui.util.swt.SashLayout;
import name.abuchen.portfolio.ui.util.swt.SashLayoutData;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnEditingSupport;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.MoneyColorLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.MoneyTrailToolTipSupport;
import name.abuchen.portfolio.ui.util.viewers.NumberColorLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.SharesLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.views.AbstractListView;
import name.abuchen.portfolio.ui.views.SecuritiesChart;
import name.abuchen.portfolio.ui.views.SecurityContextMenu;
import name.abuchen.portfolio.ui.views.SecurityDetailsViewer;
import name.abuchen.portfolio.ui.views.TradesTableViewer;
import name.abuchen.portfolio.ui.views.columns.AttributeColumn;
import name.abuchen.portfolio.ui.views.columns.IsinColumn;
import name.abuchen.portfolio.ui.views.columns.NameColumn;
import name.abuchen.portfolio.ui.views.columns.NoteColumn;
import name.abuchen.portfolio.ui.views.columns.SymbolColumn;
import name.abuchen.portfolio.ui.views.columns.TaxonomyColumn;
import name.abuchen.portfolio.ui.views.columns.WknColumn;
import name.abuchen.portfolio.util.Interval;
import name.abuchen.portfolio.util.Pair;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class SecuritiesPerformanceView
extends AbstractListView
implements ReportingPeriodDropDown.ReportingPeriodListener {
    @Inject
    private SelectionService selectionService;
    @Inject
    private ExchangeRateProviderFactory factory;
    @Inject
    private IStylingEngine stylingEngine;
    private ShowHideColumnHelper recordColumns;
    private TableViewer records;
    private TableViewer transactions;
    private TradesTableViewer trades;
    private ReportingPeriodDropDown dropDown;
    private ClientFilter clientFilter;
    private List<Predicate<SecurityPerformanceRecord>> recordFilter = new ArrayList<Predicate<SecurityPerformanceRecord>>();
    private SecuritiesChart chart;
    private SecurityDetailsViewer latest;

    @Override
    protected String getDefaultTitle() {
        return this.recordColumns == null ? Messages.LabelSecurityPerformance : String.valueOf(Messages.LabelSecurityPerformance) + " (" + this.recordColumns.getConfigurationName() + ")";
    }

    @Override
    protected void addButtons(ToolBarManager toolBar) {
        this.dropDown = new ReportingPeriodDropDown(this.getPart(), this);
        toolBar.add((IContributionItem)this.dropDown);
        toolBar.add((IContributionItem)new FilterDropDown(this.getPreferenceStore()));
        this.addExportButton(toolBar);
        toolBar.add((IContributionItem)new DropDown(Messages.MenuShowHideColumns, Images.CONFIG, 0, manager -> this.recordColumns.menuAboutToShow(manager)));
    }

    private void addExportButton(ToolBarManager manager) {
        Action export = new Action(){

            public void run() {
                new TableViewerCSVExporter(SecuritiesPerformanceView.this.records).export(String.valueOf(SecuritiesPerformanceView.this.getTitle()) + ".csv");
            }
        };
        export.setImageDescriptor(Images.EXPORT.descriptor());
        export.setToolTipText(Messages.MenuExportData);
        manager.add((IContributionItem)new ActionContributionItem((IAction)export));
    }

    @Override
    protected void createTopTable(Composite parent) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.records = new TableViewer(container, 65536);
        this.recordColumns = new ShowHideColumnHelper(SecuritiesPerformanceView.class.getName(), this.getClient(), this.getPreferenceStore(), this.records, layout);
        this.updateTitle(this.getDefaultTitle());
        this.recordColumns.addListener(() -> this.updateTitle(this.getDefaultTitle()));
        this.recordColumns.setToolBarManager(this.getViewToolBarManager());
        MoneyTrailToolTipSupport.enableFor((ColumnViewer)this.records, 2);
        ColumnEditingSupport.prepare((ColumnViewer)this.records);
        this.createCommonColumns();
        this.createDividendColumns();
        this.addPerformanceColumns();
        this.addCapitalGainsColumns();
        this.createRiskColumns();
        this.createAdditionalColumns();
        this.recordColumns.createColumns();
        this.records.getTable().setHeaderVisible(true);
        this.records.getTable().setLinesVisible(true);
        this.records.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.records.addDragSupport(2, new Transfer[]{SecurityTransfer.getTransfer()}, (DragSourceListener)new SecurityDragListener((StructuredViewer)this.records));
        this.hookContextMenu((Control)this.records.getTable(), this::fillContextMenu);
        this.records.addSelectionChangedListener(event -> {
            SecurityPerformanceRecord record = (SecurityPerformanceRecord)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (record != null) {
                this.transactions.setInput((Object)record.getLineItems());
                this.transactions.refresh();
                this.chart.updateChart(record.getSecurity());
                Client filteredClient = this.clientFilter.filter(this.getClient());
                this.latest.setInput(record.getSecurity());
                try {
                    CurrencyConverterImpl converter = new CurrencyConverterImpl(this.factory, this.getClient().getBaseCurrency());
                    this.trades.setInput(new TradeCollector(filteredClient, (CurrencyConverter)converter).collect(record.getSecurity()));
                }
                catch (TradeCollectorException e) {
                    PortfolioPlugin.log(e);
                    this.trades.setInput(null);
                }
            } else {
                this.transactions.setInput(null);
                this.transactions.refresh();
                this.chart.updateChart(null);
                this.trades.setInput(null);
                this.latest.setInput(null);
            }
        });
        this.records.addSelectionChangedListener(event -> {
            SecurityPerformanceRecord record = (SecurityPerformanceRecord)((IStructuredSelection)event.getSelection()).getFirstElement();
            if (record != null) {
                this.selectionService.setSelection(new SecuritySelection(this.getClient(), record.getSecurity()));
            }
        });
        this.records.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (SecuritiesPerformanceView.this.recordFilter.isEmpty()) {
                    return true;
                }
                for (Predicate<SecurityPerformanceRecord> predicate : SecuritiesPerformanceView.this.recordFilter) {
                    if (predicate.test((SecurityPerformanceRecord)element)) continue;
                    return false;
                }
                return true;
            }
        });
        this.stylingEngine.style((Object)this.records.getTable());
    }

    private void createCommonColumns() {
        Column column = new Column("shares", Messages.ColumnSharesOwned, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new SharesLabelProvider(){

            @Override
            public Long getValue(Object e) {
                return ((SecurityPerformanceRecord)e).getSharesHeld();
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "sharesHeld"));
        this.recordColumns.addColumn(column);
        column = new NameColumn(this.getClient());
        column.getEditingSupport().addListener(new ColumnEditingSupport.TouchClientListener(this.getClient()));
        this.recordColumns.addColumn(column);
        column = new Column("pv", Messages.ColumnPurchaseValue, 131072, 75);
        column.setDescription(String.valueOf(Messages.ColumnPurchaseValue_Description) + "\n\n" + Messages.DescriptionDataRelativeToReportingPeriod);
        column.setImage(Images.INTERVAL);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Money.format(((SecurityPerformanceRecord)r).getFifoCost(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
            }

            public String getToolTipText(Object r) {
                return ((SecurityPerformanceRecord)r).explain("fifoCost").isPresent() ? "fifoCost" : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "fifoCost"));
        this.recordColumns.addColumn(column);
        column = new Column("pvmvavg", Messages.ColumnPurchaseValueMovingAverage, 131072, 75);
        column.setMenuLabel(Messages.ColumnPurchaseValueMovingAverage_MenuLabel);
        column.setDescription(String.valueOf(Messages.ColumnPurchaseValueMovingAverage_Description) + "\n\n" + Messages.DescriptionDataRelativeToReportingPeriod);
        column.setImage(Images.INTERVAL);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Money.format(((SecurityPerformanceRecord)r).getMovingAverageCost(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "movingAverageCost"));
        column.setVisible(false);
        this.recordColumns.addColumn(column);
        column = new Column("pp", Messages.ColumnPurchasePrice, 131072, 75);
        column.setDescription(String.valueOf(Messages.ColumnPurchasePrice_Description) + "\n\n" + Messages.DescriptionDataRelativeToReportingPeriod);
        column.setImage(Images.INTERVAL);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.CalculatedQuote.format(((SecurityPerformanceRecord)r).getFifoCostPerSharesHeld(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "fifoCostPerSharesHeld"));
        this.recordColumns.addColumn(column);
        column = new Column("ppmvavg", Messages.ColumnPurchasePriceMovingAverage, 131072, 75);
        column.setMenuLabel(Messages.ColumnPurchasePriceMovingAverage_MenuLabel);
        column.setDescription(String.valueOf(Messages.ColumnPurchasePriceMovingAverage_Description) + "\n\n" + Messages.DescriptionDataRelativeToReportingPeriod);
        column.setImage(Images.INTERVAL);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.CalculatedQuote.format(((SecurityPerformanceRecord)r).getMovingAverageCostPerSharesHeld(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "movingAverageCostPerSharesHeld"));
        column.setVisible(false);
        this.recordColumns.addColumn(column);
        column = new Column("quote", Messages.ColumnQuote, 131072, 75);
        column.setDescription(Messages.ColumnQuote_DescriptionEndOfReportingPeriod);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SecurityPerformanceRecord record = (SecurityPerformanceRecord)element;
                return Values.Quote.format(record.getQuote(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
            }

            public String getToolTipText(Object element) {
                SecurityPerformanceRecord record = (SecurityPerformanceRecord)element;
                return MessageFormat.format((String)Messages.TooltipQuoteAtDate, (Object[])new Object[]{this.getText(element), Values.Date.format((Object)record.getLatestSecurityPrice().getDate())});
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((SecurityPerformanceRecord)e).getQuote()));
        this.recordColumns.addColumn(column);
        column = new Column("5", Messages.ColumnChangeOnPrevious, 131072, 60);
        column.setMenuLabel(Messages.ColumnChangeOnPrevious_MenuLabel);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Double>(Values.Percent2, element -> {
            Optional previous = ((SecurityPerformanceRecord)element).getSecurity().getLatestTwoSecurityPrices();
            if (previous.isPresent()) {
                double latestQuote = ((SecurityPrice)((Pair)previous.get()).getLeft()).getValue();
                double previousQuote = ((SecurityPrice)((Pair)previous.get()).getRight()).getValue();
                return (latestQuote - previousQuote) / previousQuote;
            }
            return null;
        }, element -> {
            Optional previous = ((SecurityPerformanceRecord)element).getSecurity().getLatestTwoSecurityPrices();
            if (previous.isPresent()) {
                return String.valueOf(Messages.ColumnLatestPrice) + ": " + MessageFormat.format((String)Messages.TooltipQuoteAtDate, (Object[])new Object[]{Values.Quote.format(Long.valueOf(((SecurityPrice)((Pair)previous.get()).getLeft()).getValue())), Values.Date.format((Object)((SecurityPrice)((Pair)previous.get()).getLeft()).getDate())}) + "\n" + Messages.ColumnPreviousPrice + ": " + MessageFormat.format((String)Messages.TooltipQuoteAtDate, (Object[])new Object[]{Values.Quote.format(Long.valueOf(((SecurityPrice)((Pair)previous.get()).getRight()).getValue())), Values.Date.format((Object)((SecurityPrice)((Pair)previous.get()).getRight()).getDate())});
            }
            return null;
        }));
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            Optional previous1 = ((SecurityPerformanceRecord)o1).getSecurity().getLatestTwoSecurityPrices();
            Optional previous2 = ((SecurityPerformanceRecord)o2).getSecurity().getLatestTwoSecurityPrices();
            if (!previous1.isPresent() && !previous2.isPresent()) {
                return 0;
            }
            if (!previous1.isPresent() && previous2.isPresent()) {
                return -1;
            }
            if (previous1.isPresent() && !previous2.isPresent()) {
                return 1;
            }
            double latestQuote1 = ((SecurityPrice)((Pair)previous1.get()).getLeft()).getValue();
            double previousQuote1 = ((SecurityPrice)((Pair)previous1.get()).getRight()).getValue();
            double v1 = (latestQuote1 - previousQuote1) / previousQuote1;
            double latestQuote2 = ((SecurityPrice)((Pair)previous2.get()).getLeft()).getValue();
            double previousQuote2 = ((SecurityPrice)((Pair)previous2.get()).getRight()).getValue();
            double v2 = (latestQuote2 - previousQuote2) / previousQuote2;
            return Double.compare(v1, v2);
        }));
        this.recordColumns.addColumn(column);
        column = new Column("changeonpreviousamount", Messages.ColumnChangeOnPreviousAmount, 131072, 60);
        column.setMenuLabel(Messages.ColumnChangeOnPrevious_MenuLabelAmount);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Long>((Values<Long>)Values.CalculatedQuote, element -> {
            Optional previous = ((SecurityPerformanceRecord)element).getSecurity().getLatestTwoSecurityPrices();
            if (previous.isPresent()) {
                double latestQuote = ((SecurityPrice)((Pair)previous.get()).getLeft()).getValue();
                double previousQuote = ((SecurityPrice)((Pair)previous.get()).getRight()).getValue();
                return (long)(latestQuote - previousQuote);
            }
            return null;
        }, element -> {
            Optional previous = ((SecurityPerformanceRecord)element).getSecurity().getLatestTwoSecurityPrices();
            if (previous.isPresent()) {
                return String.valueOf(Messages.ColumnLatestPrice) + ": " + MessageFormat.format((String)Messages.TooltipQuoteAtDate, (Object[])new Object[]{Values.Quote.format(Long.valueOf(((SecurityPrice)((Pair)previous.get()).getLeft()).getValue())), Values.Date.format((Object)((SecurityPrice)((Pair)previous.get()).getLeft()).getDate())}) + "\n" + Messages.ColumnPreviousPrice + ": " + MessageFormat.format((String)Messages.TooltipQuoteAtDate, (Object[])new Object[]{Values.Quote.format(Long.valueOf(((SecurityPrice)((Pair)previous.get()).getRight()).getValue())), Values.Date.format((Object)((SecurityPrice)((Pair)previous.get()).getRight()).getDate())});
            }
            return null;
        }));
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            Optional previous1 = ((SecurityPerformanceRecord)o1).getSecurity().getLatestTwoSecurityPrices();
            Optional previous2 = ((SecurityPerformanceRecord)o2).getSecurity().getLatestTwoSecurityPrices();
            if (!previous1.isPresent() && !previous2.isPresent()) {
                return 0;
            }
            if (!previous1.isPresent() && previous2.isPresent()) {
                return -1;
            }
            if (previous1.isPresent() && !previous2.isPresent()) {
                return 1;
            }
            double latestQuote1 = ((SecurityPrice)((Pair)previous1.get()).getLeft()).getValue();
            double previousQuote1 = ((SecurityPrice)((Pair)previous1.get()).getRight()).getValue();
            double v1 = latestQuote1 - previousQuote1;
            double latestQuote2 = ((SecurityPrice)((Pair)previous2.get()).getLeft()).getValue();
            double previousQuote2 = ((SecurityPrice)((Pair)previous2.get()).getRight()).getValue();
            double v2 = latestQuote2 - previousQuote2;
            return Double.compare(v1, v2);
        }));
        this.recordColumns.addColumn(column);
        column = new Column("mv", Messages.ColumnMarketValue, 131072, 75);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Money.format(((SecurityPerformanceRecord)r).getMarketValue(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "marketValue"));
        this.recordColumns.addColumn(column);
        column = new Column("fees", Messages.ColumnFees, 131072, 80);
        column.setDescription(Messages.ColumnFees_Description);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Money.format(((SecurityPerformanceRecord)r).getFees(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "fees"));
        column.setVisible(false);
        this.recordColumns.addColumn(column);
        column = new Column("taxes", Messages.ColumnTaxes, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Money.format(((SecurityPerformanceRecord)r).getTaxes(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "taxes"));
        column.setVisible(false);
        this.recordColumns.addColumn(column);
        column = new IsinColumn();
        column.getEditingSupport().addListener(new ColumnEditingSupport.TouchClientListener(this.getClient()));
        column.setVisible(false);
        this.recordColumns.addColumn(column);
        column = new SymbolColumn();
        column.getEditingSupport().addListener(new ColumnEditingSupport.TouchClientListener(this.getClient()));
        column.setVisible(false);
        this.recordColumns.addColumn(column);
        column = new WknColumn();
        column.getEditingSupport().addListener(new ColumnEditingSupport.TouchClientListener(this.getClient()));
        column.setVisible(false);
        this.recordColumns.addColumn(column);
        column = new NoteColumn();
        column.getEditingSupport().addListener(new ColumnEditingSupport.TouchClientListener(this.getClient()));
        column.setVisible(false);
        this.recordColumns.addColumn(column);
    }

    private void addPerformanceColumns() {
        Column column = new Column("twror", Messages.ColumnTWROR, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setMenuLabel(Messages.ColumnTWROR_Description);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Double>(Values.Percent2, r -> ((SecurityPerformanceRecord)r).getTrueTimeWeightedRateOfReturn()));
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "trueTimeWeightedRateOfReturn"));
        this.recordColumns.addColumn(column);
        column = new Column("izf", Messages.ColumnIRR, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setMenuLabel(Messages.ColumnIRR_MenuLabel);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Double>(Values.Percent2, r -> ((SecurityPerformanceRecord)r).getIrr()));
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "irr"));
        this.recordColumns.addColumn(column);
        column = new Column("capitalgains", Messages.ColumnCapitalGains, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setDescription(Messages.ColumnCapitalGains_Description);
        column.setLabelProvider((CellLabelProvider)new MoneyColorLabelProvider(element -> ((SecurityPerformanceRecord)element).getCapitalGainsOnHoldings(), this.getClient()));
        column.setVisible(false);
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "capitalGainsOnHoldings"));
        this.recordColumns.addColumn(column);
        column = new Column("capitalgains%", Messages.ColumnCapitalGainsPercent, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setDescription(Messages.ColumnCapitalGainsPercent_Description);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Double>(Values.Percent2, r -> ((SecurityPerformanceRecord)r).getCapitalGainsOnHoldingsPercent()));
        column.setVisible(false);
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "capitalGainsOnHoldingsPercent"));
        this.recordColumns.addColumn(column);
        column = new Column("capitalgainsmvavg", Messages.ColumnCapitalGainsMovingAverage, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setMenuLabel(Messages.ColumnCapitalGainsMovingAverage_MenuLabel);
        column.setDescription(Messages.ColumnCapitalGainsMovingAverage_Description);
        column.setLabelProvider((CellLabelProvider)new MoneyColorLabelProvider(element -> ((SecurityPerformanceRecord)element).getCapitalGainsOnHoldingsMovingAverage(), this.getClient()));
        column.setVisible(false);
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "capitalGainsOnHoldingsMovingAverage"));
        this.recordColumns.addColumn(column);
        column = new Column("capitalgainsmvavg%", Messages.ColumnCapitalGainsMovingAveragePercent, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setMenuLabel(Messages.ColumnCapitalGainsMovingAveragePercent_MenuLabel);
        column.setDescription(Messages.ColumnCapitalGainsMovingAveragePercent_Description);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Double>(Values.Percent2, r -> ((SecurityPerformanceRecord)r).getCapitalGainsOnHoldingsMovingAveragePercent()));
        column.setVisible(false);
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "capitalGainsOnHoldingsMovingAveragePercent"));
        this.recordColumns.addColumn(column);
        column = new Column("delta", Messages.ColumnAbsolutePerformance, 131072, 80);
        column.setDescription(Messages.ColumnAbsolutePerformance_Description);
        column.setMenuLabel(Messages.ColumnAbsolutePerformance_MenuLabel);
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setLabelProvider((CellLabelProvider)new MoneyColorLabelProvider(element -> ((SecurityPerformanceRecord)element).getDelta(), this.getClient()));
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "delta"));
        this.recordColumns.addColumn(column);
        column = new Column("delta%", Messages.ColumnAbsolutePerformancePercent, 131072, 80);
        column.setDescription(Messages.ColumnAbsolutePerformancePercent_Description);
        column.setMenuLabel(Messages.ColumnAbsolutePerformancePercent_MenuLabel);
        column.setGroupLabel(Messages.GroupLabelPerformance);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Double>(Values.Percent2, r -> ((SecurityPerformanceRecord)r).getDeltaPercent()));
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "deltaPercent"));
        column.setVisible(false);
        this.recordColumns.addColumn(column);
    }

    private void addCapitalGainsColumns() {
        Column column = new Column("cg", Messages.ColumnRealizedCapitalGains, 131072, 80);
        column.setGroupLabel(Messages.LabelCapitalGains);
        column.setLabelProvider((CellLabelProvider)new MoneyColorLabelProvider(element -> ((SecurityPerformanceRecord)element).getRealizedCapitalGains().getCapitalGains(), element -> "realizedCapitalGains", this.getClient()));
        column.setVisible(false);
        column.setSorter(ColumnViewerSorter.create(element -> ((SecurityPerformanceRecord)element).getRealizedCapitalGains().getCapitalGains()));
        this.recordColumns.addColumn(column);
        column = new Column("cgforex", String.valueOf(Messages.ColumnCurrencyGains) + " / " + Messages.ColumnRealizedCapitalGains, 131072, 80);
        column.setGroupLabel(Messages.LabelCapitalGains);
        column.setLabelProvider((CellLabelProvider)new MoneyColorLabelProvider(element -> ((SecurityPerformanceRecord)element).getRealizedCapitalGains().getForexCaptialGains(), element -> "realizedCapitalGainsForex", this.getClient()));
        column.setVisible(false);
        column.setSorter(ColumnViewerSorter.create(element -> ((SecurityPerformanceRecord)element).getRealizedCapitalGains().getCapitalGains()));
        this.recordColumns.addColumn(column);
        column = new Column("ucg", Messages.ColumnUnrealizedCapitalGains, 131072, 80);
        column.setGroupLabel(Messages.LabelCapitalGains);
        column.setLabelProvider((CellLabelProvider)new MoneyColorLabelProvider(element -> ((SecurityPerformanceRecord)element).getUnrealizedCapitalGains().getCapitalGains(), element -> "unrealizedCapitalGains", this.getClient()));
        column.setVisible(false);
        column.setSorter(ColumnViewerSorter.create(element -> ((SecurityPerformanceRecord)element).getUnrealizedCapitalGains().getCapitalGains()));
        this.recordColumns.addColumn(column);
        column = new Column("ucgforex", String.valueOf(Messages.ColumnCurrencyGains) + " / " + Messages.ColumnUnrealizedCapitalGains, 131072, 80);
        column.setGroupLabel(Messages.LabelCapitalGains);
        column.setLabelProvider((CellLabelProvider)new MoneyColorLabelProvider(element -> ((SecurityPerformanceRecord)element).getUnrealizedCapitalGains().getForexCaptialGains(), element -> "unrealizedCapitalGainsForex", this.getClient()));
        column.setVisible(false);
        column.setSorter(ColumnViewerSorter.create(element -> ((SecurityPerformanceRecord)element).getUnrealizedCapitalGains().getCapitalGains()));
        this.recordColumns.addColumn(column);
    }

    private void createDividendColumns() {
        Column column = new Column("sumdiv", Messages.ColumnDividendSum, 131072, 80);
        column.setMenuLabel(Messages.ColumnDividendSum_MenuLabel);
        column.setGroupLabel(Messages.GroupLabelDividends);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Money.format(((SecurityPerformanceRecord)r).getSumOfDividends(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "sumOfDividends"));
        this.recordColumns.addColumn(column);
        column = new Column("d%", Messages.ColumnDividendTotalRateOfReturn, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelDividends);
        column.setDescription(Messages.ColumnDividendTotalRateOfReturn_Description);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Percent2.formatNonZero((Object)((SecurityPerformanceRecord)r).getTotalRateOfReturnDiv());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "totalRateOfReturnDiv"));
        this.recordColumns.addColumn(column);
        column = new Column("d%mvavg", Messages.ColumnDividendMovingAverageTotalRateOfReturn, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelDividends);
        column.setMenuLabel(Messages.ColumnDividendMovingAverageTotalRateOfReturn_MenuLabel);
        column.setDescription(Messages.ColumnDividendMovingAverageTotalRateOfReturn_Description);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Percent2.formatNonZero((Object)((SecurityPerformanceRecord)r).getTotalRateOfReturnDivMovingAverage());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "totalRateOfReturnDivMovingAverage"));
        this.recordColumns.addColumn(column);
        column = new Column("d%peryear", Messages.ColumnDividendRateOfReturnPerYear, 131072, 80);
        column.setGroupLabel(Messages.GroupLabelDividends);
        column.setDescription(Messages.ColumnDividendRateOfReturnPerYear_Description);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Percent2.formatNonZero((Object)((SecurityPerformanceRecord)r).getRateOfReturnPerYear());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "rateOfReturnPerYear"));
        this.recordColumns.addColumn(column);
        column = new Column("dcount", Messages.ColumnDividendPaymentCount, 131072, 25);
        column.setGroupLabel(Messages.GroupLabelDividends);
        column.setMenuLabel(Messages.ColumnDividendPaymentCount_MenuLabel);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Id.format((Object)((SecurityPerformanceRecord)r).getDividendEventCount());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "dividendEventCount"));
        this.recordColumns.addColumn(column);
        column = new Column("dlast", Messages.ColumnLastDividendPayment, 0, 75);
        column.setMenuLabel(Messages.ColumnLastDividendPayment_MenuLabel);
        column.setGroupLabel(Messages.GroupLabelDividends);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                LocalDate date = ((SecurityPerformanceRecord)r).getLastDividendPayment();
                return date != null ? Values.Date.format((Object)date) : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "lastDividendPayment"));
        this.recordColumns.addColumn(column);
        column = new Column("dperiod", Messages.ColumnDividendPeriodicity, 0, 100);
        column.setGroupLabel(Messages.GroupLabelDividends);
        column.setDescription(Messages.ColumnDividendPeriodicity_Description);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return ((SecurityPerformanceRecord)r).getPeriodicity().toString();
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "periodicitySort"));
        this.recordColumns.addColumn(column);
    }

    private void createRiskColumns() {
        Column column = new Column("mdd", Messages.ColumnMaxDrawdown, 131072, 60);
        column.setMenuLabel(Messages.LabelMaxDrawdown);
        column.setGroupLabel(Messages.LabelRiskIndicators);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Percent2.formatNonZero((Object)((SecurityPerformanceRecord)r).getMaxDrawdown());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "maxDrawdown"));
        this.recordColumns.addColumn(column);
        column = new Column("mddduration", Messages.ColumnMaxDrawdownDuration, 131072, 60);
        column.setMenuLabel(Messages.LabelMaxDrawdownDuration);
        column.setGroupLabel(Messages.LabelRiskIndicators);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return String.valueOf(((SecurityPerformanceRecord)r).getMaxDrawdownDuration());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "maxDrawdownDuration"));
        this.recordColumns.addColumn(column);
        column = new Column("vola", Messages.LabelVolatility, 131072, 80);
        column.setGroupLabel(Messages.LabelRiskIndicators);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Percent2.format((Object)((SecurityPerformanceRecord)r).getVolatility());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "volatility"));
        this.recordColumns.addColumn(column);
        column = new Column("semivola", Messages.LabelSemiVolatility, 131072, 80);
        column.setGroupLabel(Messages.LabelRiskIndicators);
        column.setVisible(false);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object r) {
                return Values.Percent2.format((Object)((SecurityPerformanceRecord)r).getSemiVolatility());
            }
        });
        column.setSorter(ColumnViewerSorter.create(SecurityPerformanceRecord.class, "semiVolatility"));
        this.recordColumns.addColumn(column);
    }

    private void createAdditionalColumns() {
        for (Taxonomy taxonomy : this.getClient().getTaxonomies()) {
            TaxonomyColumn column2 = new TaxonomyColumn(taxonomy);
            column2.setVisible(false);
            this.recordColumns.addColumn(column2);
        }
        AttributeColumn.createFor(this.getClient(), Security.class).forEach(column -> {
            column.setEditingSupport(null);
            this.recordColumns.addColumn((Column)column);
        });
    }

    @Override
    protected void createBottomTable(Composite parent) {
        Composite sash = new Composite(parent, 0);
        sash.setLayout((Layout)new SashLayout(sash, 0x1000108));
        CTabFolder folder = new CTabFolder(sash, 2048);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(Messages.SecurityTabChart);
        Composite chartComposite = new Composite((Composite)folder, 0);
        item.setControl((Control)chartComposite);
        this.chart = new SecuritiesChart(chartComposite, this.clientFilter.filter(this.getClient()), (CurrencyConverter)new CurrencyConverterImpl(this.factory, this.getClient().getBaseCurrency()));
        item = new CTabItem(folder, 0);
        item.setText(Messages.SecurityTabTransactions);
        Composite container = new Composite((Composite)folder, 0);
        item.setControl((Control)container);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.transactions = new TableViewer(container, 65536);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.transactions, (int)2);
        ShowHideColumnHelper support = new ShowHideColumnHelper(String.valueOf(SecuritiesPerformanceView.class.getSimpleName()) + "@bottom4", this.getPreferenceStore(), this.transactions, layout);
        this.createTransactionColumns(support);
        support.createColumns();
        this.transactions.getTable().setHeaderVisible(true);
        this.transactions.getTable().setLinesVisible(true);
        this.transactions.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        item = new CTabItem(folder, 0);
        item.setText(Messages.SecurityTabTrades);
        this.trades = new TradesTableViewer(this);
        item.setControl(this.trades.createViewControl((Composite)folder, TradesTableViewer.ViewMode.SINGLE_SECURITY));
        item.setData(manager -> this.trades.getShowHideColumnHelper().menuAboutToShow((IMenuManager)manager));
        folder.setSelection(0);
        this.setupTabFolderToolBar(folder);
        this.latest = new SecurityDetailsViewer(sash, 2048, this.getClient());
        this.latest.getControl().setLayoutData((Object)new SashLayoutData(SWTHelper.getPackedWidth(this.latest.getControl())));
        this.reportingPeriodUpdated();
    }

    private void setupTabFolderToolBar(CTabFolder folder) {
        ToolBarManager toolBarManager = new ToolBarManager(0x820000);
        toolBarManager.add((IContributionItem)new DropDown(Messages.MenuShowHideColumns, Images.CONFIG, 0, manager -> {
            CTabItem selection = folder.getSelection();
            if (selection == null) {
                return;
            }
            Consumer menu = (Consumer)selection.getData();
            if (menu == null) {
                return;
            }
            menu.accept(manager);
        }));
        ToolBar toolBar = toolBarManager.createControl((Composite)folder);
        toolBar.setBackground(folder.getBackground());
        CTabItem selection = folder.getSelection();
        toolBar.setVisible(selection != null && selection.getData() != null);
        folder.setTopRight((Control)toolBar);
        folder.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            CTabItem s = folder.getSelection();
            toolBar.setVisible(s != null && s.getData() != null);
        }));
    }

    private void createTransactionColumns(ShowHideColumnHelper support) {
        Column column = new Column(Messages.ColumnDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return Values.DateTime.format((Object)((CalculationLineItem)e).getDateTime());
            }
        });
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            CalculationLineItem c1 = (CalculationLineItem)o1;
            CalculationLineItem c2 = (CalculationLineItem)o2;
            return c1.getDateTime().compareTo(c2.getDateTime());
        }));
        support.addColumn(column);
        column = new Column(Messages.ColumnTransactionType, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return ((CalculationLineItem)e).getLabel();
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnShares, 0, 80);
        column.setLabelProvider((CellLabelProvider)new SharesLabelProvider(){

            @Override
            public Long getValue(Object e) {
                CalculationLineItem data = (CalculationLineItem)e;
                Optional position = data.getSecurityPosition();
                if (position.isPresent()) {
                    return ((SecurityPosition)position.get()).getShares();
                }
                Optional transaction = data.getTransaction();
                if (transaction.isPresent() && ((Transaction)transaction.get()).getShares() != 0L) {
                    return ((Transaction)transaction.get()).getShares();
                }
                return null;
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnDividendPayment, 131072, 80);
        column.setDescription(Messages.ColumnGrossDividend);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                CalculationLineItem item = (CalculationLineItem)e;
                if (item instanceof CalculationLineItem.DividendPayment) {
                    return Values.Money.format(((CalculationLineItem.DividendPayment)item).getGrossValue(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
                }
                return null;
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnDividendPerShare, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                CalculationLineItem item = (CalculationLineItem)e;
                if (item instanceof CalculationLineItem.DividendPayment) {
                    return Values.AmountFraction.formatNonZero((Object)((CalculationLineItem.DividendPayment)item).getDividendPerShare());
                }
                return null;
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnPersonalDividendYield, 131072, 80);
        column.setDescription(Messages.ColumnPersonalDividendYield_Description);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                CalculationLineItem item = (CalculationLineItem)e;
                if (item instanceof CalculationLineItem.DividendPayment) {
                    return Values.Percent2.formatNonZero((Object)((CalculationLineItem.DividendPayment)item).getPersonalDividendYield());
                }
                return null;
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnPersonalDividendYieldMovingAverage, 131072, 80);
        column.setDescription(Messages.ColumnPersonalDividendYieldMovingAverage_Description);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                CalculationLineItem item = (CalculationLineItem)e;
                if (item instanceof CalculationLineItem.DividendPayment) {
                    return Values.Percent2.formatNonZero((Object)((CalculationLineItem.DividendPayment)item).getPersonalDividendYieldMovingAverage());
                }
                return null;
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnAmount, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                CalculationLineItem item = (CalculationLineItem)e;
                if (item instanceof CalculationLineItem.DividendPayment) {
                    return null;
                }
                return Values.Money.format(item.getValue(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnQuote, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Optional tx = ((CalculationLineItem)e).getTransaction();
                if (tx.isPresent() && tx.get() instanceof PortfolioTransaction) {
                    PortfolioTransaction ptx = (PortfolioTransaction)tx.get();
                    return Values.CalculatedQuote.format(ptx.getGrossPricePerShare(), SecuritiesPerformanceView.this.getClient().getBaseCurrency());
                }
                return null;
            }
        });
        support.addColumn(column);
        column = new Column(Messages.ColumnAccount, 0, 120);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return String.valueOf(((CalculationLineItem)e).getOwner());
            }

            public Image getImage(Object e) {
                TransactionOwner owner = ((CalculationLineItem)e).getOwner();
                return LogoManager.instance().getDefaultColumnImage(owner, SecuritiesPerformanceView.this.getClient().getSettings());
            }
        });
        support.addColumn(column);
        column = new Column("note", Messages.ColumnNote, 16384, 22);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Optional transaction = ((CalculationLineItem)e).getTransaction();
                return transaction.isPresent() ? ((Transaction)transaction.get()).getNote() : null;
            }

            public Image getImage(Object e) {
                String note = this.getText(e);
                return note != null && note.length() > 0 ? Images.NOTE.image() : null;
            }
        });
        column.setSorter(ColumnViewerSorter.create((o1, o2) -> {
            String s2;
            Optional t1 = ((CalculationLineItem)o1).getTransaction();
            String s1 = t1.isPresent() ? ((Transaction)t1.get()).getNote() : "";
            Optional t2 = ((CalculationLineItem)o2).getTransaction();
            String string = s2 = t2.isPresent() ? ((Transaction)t2.get()).getNote() : "";
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareTo(s2);
        }));
        support.addColumn(column);
    }

    @Override
    public void notifyModelUpdated() {
        HashSet<Security> oldSelection = new HashSet<Security>();
        Iterator iter = this.records.getStructuredSelection().iterator();
        while (iter.hasNext()) {
            oldSelection.add(((SecurityPerformanceRecord)iter.next()).getSecurity());
        }
        this.reportingPeriodUpdated();
        this.updateTitle(this.getDefaultTitle());
        List newSelection = ((List)this.records.getInput()).stream().map(e -> (SecurityPerformanceRecord)e).filter(e -> oldSelection.contains(e.getSecurity())).collect(Collectors.toList());
        this.records.setSelection((ISelection)new StructuredSelection(newSelection));
    }

    @Override
    public void reportingPeriodUpdated() {
        Interval period = this.dropDown.getSelectedPeriod().toInterval(LocalDate.now());
        CurrencyConverterImpl converter = new CurrencyConverterImpl(this.factory, this.getClient().getBaseCurrency());
        Client filteredClient = this.clientFilter.filter(this.getClient());
        this.records.setInput((Object)SecurityPerformanceSnapshot.create((Client)filteredClient, (CurrencyConverter)converter, (Interval)period, (Class[])new Class[0]).getRecords());
        this.records.refresh();
        this.chart.setClient(filteredClient);
    }

    private void fillContextMenu(IMenuManager manager) {
        Object selection = ((IStructuredSelection)this.records.getSelection()).getFirstElement();
        if (!(selection instanceof SecurityPerformanceRecord)) {
            return;
        }
        Security security = ((SecurityPerformanceRecord)selection).getSecurity();
        new SecurityContextMenu(this).menuAboutToShow(manager, security);
    }

    private class FilterDropDown
    extends DropDown
    implements IMenuListener {
        private final Predicate<SecurityPerformanceRecord> sharesGreaterZero;
        private final Predicate<SecurityPerformanceRecord> sharesEqualZero;
        private ClientFilterMenu clientFilterMenu;

        public FilterDropDown(IPreferenceStore preferenceStore) {
            super(Messages.SecurityFilter, Images.FILTER_OFF, 0);
            this.sharesGreaterZero = record -> record.getSharesHeld() > 0L;
            this.sharesEqualZero = record -> record.getSharesHeld() == 0L;
            if (preferenceStore.getBoolean(String.valueOf(SecuritiesPerformanceView.class.getSimpleName()) + "-sharesGreaterZero")) {
                SecuritiesPerformanceView.this.recordFilter.add(this.sharesGreaterZero);
            }
            if (preferenceStore.getBoolean(String.valueOf(SecuritiesPerformanceView.class.getSimpleName()) + "-sharesEqualZero")) {
                SecuritiesPerformanceView.this.recordFilter.add(this.sharesEqualZero);
            }
            this.clientFilterMenu = new ClientFilterMenu(SecuritiesPerformanceView.this.getClient(), preferenceStore, f -> {
                this.setImage(SecuritiesPerformanceView.this.recordFilter.isEmpty() && !this.clientFilterMenu.hasActiveFilter() ? Images.FILTER_OFF : Images.FILTER_ON);
                SecuritiesPerformanceView.this.clientFilter = f;
                SecuritiesPerformanceView.this.notifyModelUpdated();
            });
            this.loadPreselectedClientFilter(preferenceStore);
            SecuritiesPerformanceView.this.clientFilter = this.clientFilterMenu.getSelectedFilter();
            if (!SecuritiesPerformanceView.this.recordFilter.isEmpty() || this.clientFilterMenu.hasActiveFilter()) {
                this.setImage(Images.FILTER_ON);
            }
            this.setMenuListener(this);
            this.addDisposeListener(e -> {
                preferenceStore.setValue(String.valueOf(SecuritiesPerformanceView.class.getSimpleName()) + "-sharesGreaterZero", SecuritiesPerformanceView.this.recordFilter.contains(this.sharesGreaterZero));
                preferenceStore.setValue(String.valueOf(SecuritiesPerformanceView.class.getSimpleName()) + "-sharesEqualZero", SecuritiesPerformanceView.this.recordFilter.contains(this.sharesEqualZero));
            });
        }

        private void loadPreselectedClientFilter(IPreferenceStore preferenceStore) {
            String selection = preferenceStore.getString(String.valueOf(SecuritiesPerformanceView.class.getSimpleName()) + "-client-filter");
            if (selection != null) {
                this.clientFilterMenu.getAllItems().filter(item -> item.getUUIDs().equals(selection)).findAny().ifPresent(this.clientFilterMenu::select);
            }
            this.clientFilterMenu.addListener(filter -> preferenceStore.putValue(String.valueOf(SecuritiesPerformanceView.class.getSimpleName()) + "-client-filter", this.clientFilterMenu.getSelectedItem().getUUIDs()));
        }

        public void menuAboutToShow(IMenuManager manager) {
            manager.add((IAction)this.createAction(Messages.SecurityFilterSharesHeldGreaterZero, this.sharesGreaterZero));
            manager.add((IAction)this.createAction(Messages.SecurityFilterSharesHeldEqualZero, this.sharesEqualZero));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new LabelOnly(Messages.MenuChooseClientFilter));
            this.clientFilterMenu.menuAboutToShow(manager);
        }

        private Action createAction(String label, final Predicate<SecurityPerformanceRecord> predicate) {
            Action action = new Action(label, 2){

                public void run() {
                    boolean isChecked = ((FilterDropDown)FilterDropDown.this).SecuritiesPerformanceView.this.recordFilter.contains(predicate);
                    if (isChecked) {
                        ((FilterDropDown)FilterDropDown.this).SecuritiesPerformanceView.this.recordFilter.remove(predicate);
                    } else {
                        ((FilterDropDown)FilterDropDown.this).SecuritiesPerformanceView.this.recordFilter.add(predicate);
                    }
                    if (!isChecked) {
                        if (predicate == FilterDropDown.this.sharesGreaterZero) {
                            ((FilterDropDown)FilterDropDown.this).SecuritiesPerformanceView.this.recordFilter.remove(FilterDropDown.this.sharesEqualZero);
                        } else if (predicate == FilterDropDown.this.sharesEqualZero) {
                            ((FilterDropDown)FilterDropDown.this).SecuritiesPerformanceView.this.recordFilter.remove(FilterDropDown.this.sharesGreaterZero);
                        }
                    }
                    FilterDropDown.this.setImage(((FilterDropDown)FilterDropDown.this).SecuritiesPerformanceView.this.recordFilter.isEmpty() && !FilterDropDown.this.clientFilterMenu.hasActiveFilter() ? Images.FILTER_OFF : Images.FILTER_ON);
                    ((FilterDropDown)FilterDropDown.this).SecuritiesPerformanceView.this.records.refresh();
                }
            };
            action.setChecked(SecuritiesPerformanceView.this.recordFilter.contains(predicate));
            return action;
        }
    }
}

