/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import name.abuchen.portfolio.model.AccountTransaction;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.PortfolioTransaction;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.dialogs.transactions.AccountTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.InvestmentPlanDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.OpenDialogAction;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransactionDialog;
import name.abuchen.portfolio.ui.dialogs.transactions.SecurityTransferDialog;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.BookmarkMenu;
import name.abuchen.portfolio.ui.wizards.events.CustomEventWizard;
import name.abuchen.portfolio.ui.wizards.security.EditSecurityDialog;
import name.abuchen.portfolio.ui.wizards.splits.StockSplitWizard;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class SecurityContextMenu {
    private AbstractFinanceView owner;

    public SecurityContextMenu(AbstractFinanceView owner) {
        this.owner = owner;
    }

    public void menuAboutToShow(IMenuManager manager, Security security) {
        this.menuAboutToShow(manager, security, null);
    }

    public void menuAboutToShow(IMenuManager manager, final Security security, Portfolio portfolio) {
        if (this.owner.getClient().getSecurities().isEmpty()) {
            return;
        }
        if (security != null && security.getCurrencyCode() == null) {
            manager.add((IContributionItem)new BookmarkMenu(this.owner.getPart(), security));
            return;
        }
        new OpenDialogAction(this.owner, String.valueOf(Messages.SecurityMenuBuy) + "...").type(SecurityTransactionDialog.class).parameters(PortfolioTransaction.Type.BUY).with(portfolio).with(security).addTo(manager);
        new OpenDialogAction(this.owner, String.valueOf(Messages.SecurityMenuSell) + "...").type(SecurityTransactionDialog.class).parameters(PortfolioTransaction.Type.SELL).with(portfolio).with(security).addTo(manager);
        new OpenDialogAction(this.owner, String.valueOf(Messages.SecurityMenuDividends) + "...").type(AccountTransactionDialog.class).parameters(AccountTransaction.Type.DIVIDENDS).with(portfolio != null ? portfolio.getReferenceAccount() : null).with(security).addTo(manager);
        new OpenDialogAction(this.owner, AccountTransaction.Type.TAXES + "...").type(AccountTransactionDialog.class).parameters(AccountTransaction.Type.TAXES).with(portfolio != null ? portfolio.getReferenceAccount() : null).with(security).addTo(manager);
        new OpenDialogAction(this.owner, AccountTransaction.Type.TAX_REFUND + "...").type(AccountTransactionDialog.class).parameters(AccountTransaction.Type.TAX_REFUND).with(portfolio != null ? portfolio.getReferenceAccount() : null).with(security).addTo(manager);
        manager.add((IAction)new Action(Messages.SecurityMenuStockSplit){

            public void run() {
                StockSplitWizard wizard = new StockSplitWizard(SecurityContextMenu.this.owner.getClient(), security);
                WizardDialog dialog = new WizardDialog(SecurityContextMenu.this.owner.getActiveShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    SecurityContextMenu.this.owner.markDirty();
                    SecurityContextMenu.this.owner.notifyModelUpdated();
                }
            }
        });
        manager.add((IAction)new Action(Messages.SecurityMenuAddEvent){

            public void run() {
                CustomEventWizard wizard = new CustomEventWizard(SecurityContextMenu.this.owner.getClient(), security);
                WizardDialog dialog = new WizardDialog(SecurityContextMenu.this.owner.getActiveShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    SecurityContextMenu.this.owner.markDirty();
                    SecurityContextMenu.this.owner.notifyModelUpdated();
                }
            }
        });
        if (this.owner.getClient().getActivePortfolios().size() > 1) {
            manager.add((IContributionItem)new Separator());
            new OpenDialogAction(this.owner, Messages.SecurityMenuTransfer).type(SecurityTransferDialog.class).with(portfolio).with(security).addTo(manager);
        }
        manager.add((IContributionItem)new Separator());
        new OpenDialogAction(this.owner, String.valueOf(PortfolioTransaction.Type.DELIVERY_INBOUND.toString()) + "...").type(SecurityTransactionDialog.class).parameters(PortfolioTransaction.Type.DELIVERY_INBOUND).with(portfolio).with(security).addTo(manager);
        new OpenDialogAction(this.owner, String.valueOf(PortfolioTransaction.Type.DELIVERY_OUTBOUND.toString()) + "...").type(SecurityTransactionDialog.class).parameters(PortfolioTransaction.Type.DELIVERY_OUTBOUND).with(portfolio).with(security).addTo(manager);
        if (security != null) {
            manager.add((IAction)new OpenDialogAction(this.owner, Messages.InvestmentPlanMenuCreate).type(InvestmentPlanDialog.class).parameters(PortfolioTransaction.class).with(security));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action(Messages.SecurityMenuEditSecurity){

                public void run() {
                    Dialog dialog = SecurityContextMenu.this.owner.make(EditSecurityDialog.class, security);
                    if (dialog.open() == 0) {
                        SecurityContextMenu.this.owner.markDirty();
                        SecurityContextMenu.this.owner.notifyModelUpdated();
                    }
                }
            });
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new BookmarkMenu(this.owner.getPart(), security));
        }
    }
}

