/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.LatestSecurityPrice;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.SWTHelper;
import name.abuchen.portfolio.util.TextUtil;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SecurityDetailsViewer {
    private Composite container;
    private List<SecurityFacet> children = new ArrayList<SecurityFacet>();

    public SecurityDetailsViewer(Composite parent, int style, Client client) {
        this(parent, style, client, false);
    }

    public SecurityDetailsViewer(Composite parent, int style, Client client, boolean showMasterData) {
        this.container = new Composite(parent, style);
        this.container.setBackground(Colors.WHITE);
        this.container.setBackgroundMode(2);
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)this.container);
        Font boldFont = resources.createFont(FontDescriptor.createFrom((Font)this.container.getFont()).setStyle(1));
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.container);
        if (showMasterData) {
            this.children.add(new MasterDataFacet(boldFont, Colors.HEADINGS));
        }
        this.children.add(new LatestQuoteFacet(boldFont, Colors.HEADINGS));
        for (Taxonomy taxonomy : client.getTaxonomies()) {
            this.children.add(new TaxonomyFacet(taxonomy, boldFont, Colors.HEADINGS));
        }
        this.children.add(new NoteFacet(boldFont, Colors.HEADINGS));
        for (SecurityFacet child : this.children) {
            try {
                Control control = child.createViewControl(this.container, client);
                GridDataFactory.fillDefaults().grab(true, false).applyTo(control);
            }
            catch (Exception e) {
                PortfolioPlugin.log(e);
            }
        }
    }

    public Control getControl() {
        return this.container;
    }

    public void setInput(Security security) {
        for (SecurityFacet child : this.children) {
            child.setInput(security);
        }
    }

    private static class LatestQuoteFacet
    extends SecurityFacet {
        private Label valueLatestPrices;
        private Label valueLatestTrade;
        private Label valueDaysHigh;
        private Label valueDaysLow;
        private Label valueVolume;

        public LatestQuoteFacet(Font boldFont, Color color) {
            super(boldFont, color);
        }

        @Override
        public Control createViewControl(Composite parent, Client client) {
            Composite composite = new Composite(parent, 0);
            Label headingQuotes = this.createHeading(composite, Messages.ColumnLatestPrice);
            Label labelLatestPrice = new Label(composite, 0);
            labelLatestPrice.setText(Messages.ColumnLatestPrice);
            this.valueLatestPrices = new Label(composite, 131072);
            Label labelLatestTrade = new Label(composite, 0);
            labelLatestTrade.setText(Messages.ColumnLatestTrade);
            this.valueLatestTrade = new Label(composite, 131072);
            Label labelDaysHigh = new Label(composite, 0);
            labelDaysHigh.setText(Messages.ColumnDaysHigh);
            this.valueDaysHigh = new Label(composite, 131072);
            Label labelDaysLow = new Label(composite, 0);
            labelDaysLow.setText(Messages.ColumnDaysLow);
            this.valueDaysLow = new Label(composite, 131072);
            Label labelVolume = new Label(composite, 0);
            labelVolume.setText(Messages.ColumnVolume);
            this.valueVolume = new Label(composite, 131072);
            FormLayout layout = new FormLayout();
            layout.marginLeft = 5;
            layout.marginRight = 5;
            composite.setLayout((Layout)layout);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 5);
            headingQuotes.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)this.valueLatestPrices, 0, 0x1000000);
            labelLatestPrice.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)headingQuotes, 5);
            data.left = new FormAttachment(50, 5);
            data.right = new FormAttachment(100);
            data.width = SWTHelper.dateWidth((Drawable)composite);
            this.valueLatestPrices.setLayoutData((Object)data);
            SWTHelper.placeBelow((Control)this.valueLatestPrices, labelLatestTrade, (Control)this.valueLatestTrade);
            SWTHelper.placeBelow((Control)this.valueLatestTrade, labelDaysHigh, (Control)this.valueDaysHigh);
            SWTHelper.placeBelow((Control)this.valueDaysHigh, labelDaysLow, (Control)this.valueDaysLow);
            SWTHelper.placeBelow((Control)this.valueDaysLow, labelVolume, (Control)this.valueVolume);
            return composite;
        }

        @Override
        public void setInput(Security security) {
            if (this.valueLatestPrices.isDisposed()) {
                return;
            }
            if (security == null || security.getLatest() == null) {
                SWTHelper.clearLabel(this.valueLatestPrices, this.valueLatestTrade, this.valueDaysHigh, this.valueDaysLow, this.valueVolume);
            } else {
                LatestSecurityPrice p = security.getLatest();
                this.valueLatestPrices.setText(Values.Quote.format(Long.valueOf(p.getValue())));
                this.valueLatestTrade.setText(Values.Date.format((Object)p.getDate()));
                long daysHigh = p.getHigh();
                this.valueDaysHigh.setText(daysHigh == -1L ? Messages.LabelNotAvailable : Values.Quote.format(Long.valueOf(daysHigh)));
                long daysLow = p.getLow();
                this.valueDaysLow.setText(daysLow == -1L ? Messages.LabelNotAvailable : Values.Quote.format(Long.valueOf(daysLow)));
                long volume = p.getVolume();
                this.valueVolume.setText(volume == -1L ? Messages.LabelNotAvailable : String.format("%,d", volume));
            }
        }
    }

    private static class MasterDataFacet
    extends SecurityFacet {
        private Label valueName;
        private Label valueISIN;
        private Label valueTickerSymbol;

        public MasterDataFacet(Font boldFont, Color color) {
            super(boldFont, color);
        }

        @Override
        Control createViewControl(Composite parent, Client client) {
            Composite composite = new Composite(parent, 0);
            Label heading = this.createHeading(composite, Messages.ClientEditorLabelClientMasterData);
            this.valueName = new Label(composite, 0);
            this.valueISIN = new Label(composite, 0);
            this.valueTickerSymbol = new Label(composite, 0);
            FormLayout layout = new FormLayout();
            layout.marginLeft = 5;
            layout.marginRight = 5;
            composite.setLayout((Layout)layout);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 5);
            heading.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)heading, 5);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.valueName.setLayoutData((Object)data);
            this.below(this.valueName, this.valueISIN);
            this.below(this.valueISIN, this.valueTickerSymbol);
            return composite;
        }

        @Override
        void setInput(Security security) {
            if (security == null) {
                SWTHelper.clearLabel(this.valueName, this.valueISIN, this.valueTickerSymbol);
            } else {
                this.valueName.setText(security.getName());
                this.valueISIN.setText(this.nonNullString(security.getIsin()));
                this.valueTickerSymbol.setText(this.nonNullString(security.getTickerSymbol()));
            }
        }
    }

    private static class NoteFacet
    extends SecurityFacet {
        private Label valueNote;

        public NoteFacet(Font boldFont, Color color) {
            super(boldFont, color);
        }

        @Override
        Control createViewControl(Composite parent, Client client) {
            Composite composite = new Composite(parent, 0);
            Label heading = this.createHeading(composite, Messages.ColumnNote);
            this.valueNote = new Label(composite, 0);
            FormLayout layout = new FormLayout();
            layout.marginLeft = 5;
            layout.marginRight = 5;
            composite.setLayout((Layout)layout);
            FormData data = new FormData();
            data.top = new FormAttachment(0, 5);
            heading.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)heading, 5);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.valueNote.setLayoutData((Object)data);
            return composite;
        }

        @Override
        void setInput(Security security) {
            if (security == null || security.getNote() == null) {
                this.valueNote.setText("");
            } else {
                this.valueNote.setText(this.escape(security.getNote()));
            }
        }
    }

    private static abstract class SecurityFacet {
        private Font boldFont;
        private Color color;

        SecurityFacet(Font boldFont, Color color) {
            this.boldFont = boldFont;
            this.color = color;
        }

        abstract Control createViewControl(Composite var1, Client var2);

        abstract void setInput(Security var1);

        protected Label createHeading(Composite parent, String text) {
            Label heading = new Label(parent, 0);
            heading.setText(text);
            heading.setFont(this.boldFont);
            heading.setForeground(this.color);
            return heading;
        }

        protected void below(Label referenceItem, Label value) {
            FormData data = new FormData();
            data.top = new FormAttachment((Control)referenceItem, 5);
            data.left = new FormAttachment((Control)referenceItem, 0, 16384);
            data.right = new FormAttachment(100);
            value.setLayoutData((Object)data);
        }

        protected String escape(String label) {
            return label != null ? TextUtil.tooltip((String)label) : "";
        }

        protected String nonNullString(String label) {
            return label != null ? label : "";
        }
    }

    private static class TaxonomyFacet
    extends SecurityFacet {
        private Taxonomy taxonomy;
        private Label heading;
        private List<Label> labels = new ArrayList<Label>();

        public TaxonomyFacet(Taxonomy taxonomy, Font boldFont, Color color) {
            super(boldFont, color);
            this.taxonomy = taxonomy;
        }

        @Override
        Control createViewControl(Composite parent, Client client) {
            Composite composite = new Composite(parent, 0);
            FormLayout layout = new FormLayout();
            layout.marginLeft = 5;
            layout.marginRight = 5;
            composite.setLayout((Layout)layout);
            this.heading = this.createHeading(composite, this.taxonomy.getName());
            FormData data = new FormData();
            data.top = new FormAttachment(0, 5);
            data.left = new FormAttachment(0);
            data.right = new FormAttachment(100);
            this.heading.setLayoutData((Object)data);
            int ii = 0;
            while (ii < this.taxonomy.getHeigth() - 1) {
                Label label = new Label(composite, 0);
                this.labels.add(label);
                if (ii == 0) {
                    data = new FormData();
                    data.top = new FormAttachment((Control)this.heading, 5);
                    data.left = new FormAttachment(0);
                    data.right = new FormAttachment(100);
                    label.setLayoutData((Object)data);
                } else {
                    this.below(this.labels.get(ii - 1), label);
                }
                ++ii;
            }
            return composite;
        }

        @Override
        void setInput(final Security security) {
            final int[] count = new int[1];
            final int[] weight = new int[1];
            final Classification[] classification = new Classification[1];
            if (security != null) {
                this.taxonomy.foreach(new Taxonomy.Visitor(){

                    public void visit(Classification thisClassification, Classification.Assignment assignment) {
                        if (security.equals(assignment.getInvestmentVehicle())) {
                            count[0] = count[0] + 1;
                            if (assignment.getWeight() > weight[0]) {
                                weight[0] = assignment.getWeight();
                                classification[0] = thisClassification;
                            }
                        }
                    }
                });
            }
            if (count[0] > 1) {
                this.heading.setText(String.valueOf(this.taxonomy.getName()) + ' ' + MessageFormat.format(Messages.LabelOneOfX, count[0]));
            } else {
                this.heading.setText(this.taxonomy.getName());
            }
            List path = classification[0] != null ? classification[0].getPathToRoot() : new ArrayList();
            int ii = 0;
            while (ii < this.labels.size()) {
                this.labels.get(ii).setText(path.size() > ii + 1 ? this.escape(((Classification)path.get(ii + 1)).getName()) : "");
                ++ii;
            }
        }
    }
}

