/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import com.google.common.primitives.Doubles;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.SecurityPrice;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.views.ChartLineSeriesAxes;
import name.abuchen.portfolio.ui.views.SecuritiesChart;

public class SimpleMovingAverage {
    public static final int MIN_AVERAGE_PRICES_PER_WEEK = 2;
    private int rangeSMA;
    private Security security;
    private SecuritiesChart.ChartInterval interval;
    private ChartLineSeriesAxes result;

    public SimpleMovingAverage(int rangeSMA, Security security, SecuritiesChart.ChartInterval interval) {
        this.rangeSMA = rangeSMA;
        this.security = security;
        this.interval = Objects.requireNonNull(interval);
        this.result = new ChartLineSeriesAxes();
        this.calculateSMA();
    }

    public ChartLineSeriesAxes getSMA() {
        return this.result;
    }

    private void calculateSMA() {
        if (this.security == null) {
            return;
        }
        List prices = this.security.getPricesIncludingLatest();
        if (prices == null || prices.size() < this.rangeSMA) {
            return;
        }
        int index = Collections.binarySearch(prices, new SecurityPrice(this.interval.getStart(), 0L), new SecurityPrice.ByDate());
        if (index < 0) {
            index = -index - 1;
        }
        if (index >= prices.size()) {
            return;
        }
        ArrayList<LocalDate> datesSMA = new ArrayList<LocalDate>();
        ArrayList<Double> valuesSMA = new ArrayList<Double>();
        while (index < prices.size()) {
            if (index >= this.rangeSMA - 1) {
                LocalDate date = ((SecurityPrice)prices.get(index)).getDate();
                if (date.isAfter(this.interval.getEnd())) break;
                List filteredPrices = prices.subList(index - this.rangeSMA + 1, index + 1);
                long sum = filteredPrices.stream().mapToLong(SecurityPrice::getValue).sum();
                valuesSMA.add((double)sum / Values.Quote.divider() / (double)filteredPrices.size());
                datesSMA.add(date);
            }
            ++index;
        }
        this.result.setDates(TimelineChart.toJavaUtilDate(datesSMA.toArray(new LocalDate[0])));
        this.result.setValues(Doubles.toArray(valuesSMA));
    }
}

