/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.TransactionPair;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.trades.Trade;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.editor.AbstractFinanceView;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.viewers.Column;
import name.abuchen.portfolio.ui.util.viewers.ColumnViewerSorter;
import name.abuchen.portfolio.ui.util.viewers.MoneyColorLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.NumberColorLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.SharesLabelProvider;
import name.abuchen.portfolio.ui.util.viewers.ShowHideColumnHelper;
import name.abuchen.portfolio.ui.views.SecuritiesPerformanceView;
import name.abuchen.portfolio.ui.views.columns.NameColumn;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TradesTableViewer {
    private AbstractFinanceView view;
    private TableViewer trades;
    private ShowHideColumnHelper support;

    public TradesTableViewer(AbstractFinanceView view) {
        this.view = view;
    }

    public Control createViewControl(Composite parent, ViewMode viewMode) {
        Composite container = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        this.trades = new TableViewer(container, 65536);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.trades, (int)2);
        this.support = new ShowHideColumnHelper(String.valueOf(SecuritiesPerformanceView.class.getSimpleName()) + "@trades@" + viewMode.name(), this.view.getPreferenceStore(), this.trades, layout);
        this.createTradesColumns(this.support, viewMode);
        this.support.createColumns();
        this.trades.getTable().setHeaderVisible(true);
        this.trades.getTable().setLinesVisible(true);
        this.trades.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        return container;
    }

    private void createTradesColumns(ShowHideColumnHelper support, ViewMode viewMode) {
        if (viewMode == ViewMode.MULTIPLE_SECURITES) {
            support.addColumn(new NameColumn(this.view.getClient()));
        }
        Column column = new Column("start", Messages.ColumnStartDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Trade t = (Trade)e;
                return Values.DateTime.format((Object)t.getStart());
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((Trade)e).getStart()), 1024);
        support.addColumn(column);
        column = new Column("end", Messages.ColumnEndDate, 0, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Trade t = (Trade)e;
                return t.getEnd().isPresent() ? Values.DateTime.format((Object)((LocalDateTime)t.getEnd().get())) : Messages.LabelOpenTrade;
            }

            public Color getBackground(Object e) {
                return ((Trade)e).getEnd().isPresent() ? null : Colors.theme().warningBackground();
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> {
            Optional date = ((Trade)e).getEnd();
            return date.isPresent() ? (Comparable)date.get() : LocalDateTime.now().plusYears(1L);
        }));
        support.addColumn(column);
        column = new Column("tx", Messages.ColumnNumberOfTransactions, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Trade t = (Trade)e;
                return String.valueOf(t.getTransactions().size());
            }

            public Image getImage(Object element) {
                return Images.INFO.image();
            }

            public String getToolTipText(Object e) {
                return ((Trade)e).getTransactions().stream().map(TransactionPair::toString).collect(Collectors.joining("\n"));
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> Integer.valueOf(((Trade)e).getTransactions().size())));
        support.addColumn(column);
        column = new Column("shares", Messages.ColumnShares, 0, 80);
        column.setLabelProvider((CellLabelProvider)new SharesLabelProvider(){

            @Override
            public Long getValue(Object e) {
                Trade t = (Trade)e;
                return t.getShares();
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> Long.valueOf(((Trade)e).getShares())));
        support.addColumn(column);
        column = new Column("entryvalue", Messages.ColumnEntryValue, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Trade t = (Trade)e;
                return Values.Money.format(t.getEntryValue(), TradesTableViewer.this.view.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((Trade)e).getEntryValue()));
        support.addColumn(column);
        column = new Column("exitvalue", Messages.ColumnExitValue, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Trade t = (Trade)e;
                return Values.Money.format(t.getExitValue(), TradesTableViewer.this.view.getClient().getBaseCurrency());
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((Trade)e).getExitValue()));
        support.addColumn(column);
        column = new Column("pl", Messages.ColumnProfitLoss, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new MoneyColorLabelProvider(element -> ((Trade)element).getProfitLoss(), this.view.getClient()));
        column.setSorter(ColumnViewerSorter.create(e -> ((Trade)e).getProfitLoss()));
        support.addColumn(column);
        column = new Column("holdingperiod", Messages.ColumnHoldingPeriod, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                Trade t = (Trade)e;
                return Long.toString(t.getHoldingPeriod());
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> Long.valueOf(((Trade)e).getHoldingPeriod())));
        support.addColumn(column);
        column = new Column("irr", Messages.ColumnIRR, 131072, 80);
        column.setMenuLabel(Messages.ColumnIRR_MenuLabel);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Double>(Values.Percent2, t -> ((Trade)t).getIRR()));
        column.setSorter(ColumnViewerSorter.create(e -> Double.valueOf(((Trade)e).getIRR())));
        support.addColumn(column);
        column = new Column("return", Messages.ColumnReturn, 131072, 80);
        column.setLabelProvider((CellLabelProvider)new NumberColorLabelProvider<Double>(Values.Percent2, t -> ((Trade)t).getReturn()));
        column.setSorter(ColumnViewerSorter.create(e -> Double.valueOf(((Trade)e).getReturn())));
        column.setVisible(false);
        support.addColumn(column);
        column = new Column("portfolio", Messages.ColumnPortfolio, 16384, 100);
        column.setMenuLabel(Messages.ColumnPortfolio);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object e) {
                return ((Trade)e).getPortfolio().getName();
            }
        });
        column.setSorter(ColumnViewerSorter.create(e -> ((Trade)e).getPortfolio().getName()));
        column.setVisible(false);
        support.addColumn(column);
    }

    public void setInput(List<Trade> trades) {
        this.trades.setInput(trades);
    }

    public Object getInput() {
        return this.trades.getInput();
    }

    public TableViewer getTableViewer() {
        return this.trades;
    }

    public ShowHideColumnHelper getShowHideColumnHelper() {
        return this.support;
    }

    public static enum ViewMode {
        SINGLE_SECURITY,
        MULTIPLE_SECURITES;

    }
}

