/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesCache;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSet;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.jface.preference.IPreferenceStore;

public class DashboardData {
    public static final Object EMPTY_RESULT = new Object();
    private final Client client;
    private final IPreferenceStore preferences;
    private final IStylingEngine stylingEngine;
    private final ExchangeRateProviderFactory factory;
    private final CurrencyConverter converter;
    private final Map<Object, Object> cache = Collections.synchronizedMap(new HashMap());
    private List<ReportingPeriod> defaultReportingPeriods = new ArrayList<ReportingPeriod>();
    private ReportingPeriod defaultReportingPeriod;
    private DataSeriesSet dataSeriesSet;
    private DataSeriesCache dataSeriesCache;
    private Map<Dashboard.Widget, Object> resultCache = Collections.synchronizedMap(new HashMap());
    private Dashboard dashboard;

    @Inject
    public DashboardData(Client client, IPreferenceStore preferences, IStylingEngine stylingEngine, ExchangeRateProviderFactory factory, DataSeriesCache dataSeriesCache) {
        this.client = client;
        this.preferences = preferences;
        this.stylingEngine = stylingEngine;
        this.factory = factory;
        this.converter = new CurrencyConverterImpl(factory, client.getBaseCurrency());
        this.dataSeriesSet = new DataSeriesSet(client, preferences, DataSeries.UseCase.RETURN_VOLATILITY);
        this.dataSeriesCache = dataSeriesCache;
    }

    public Client getClient() {
        return this.client;
    }

    public IPreferenceStore getPreferences() {
        return this.preferences;
    }

    public IStylingEngine getStylingEngine() {
        return this.stylingEngine;
    }

    public Dashboard getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    public void setDefaultReportingPeriods(List<ReportingPeriod> defaultReportingPeriods) {
        this.defaultReportingPeriods = defaultReportingPeriods;
    }

    public List<ReportingPeriod> getDefaultReportingPeriods() {
        return this.defaultReportingPeriods;
    }

    public void setDefaultReportingPeriod(ReportingPeriod reportingPeriod) {
        this.defaultReportingPeriod = reportingPeriod;
    }

    public ReportingPeriod getDefaultReportingPeriod() {
        return this.defaultReportingPeriod;
    }

    public ExchangeRateProviderFactory getExchangeRateProviderFactory() {
        return this.factory;
    }

    public DataSeriesSet getDataSeriesSet() {
        return this.dataSeriesSet;
    }

    public synchronized void clearCache() {
        this.cache.clear();
        this.dataSeriesCache.clear();
        this.clearResultCache();
    }

    public DataSeriesCache getDataSeriesCache() {
        return this.dataSeriesCache;
    }

    public Map<Object, Object> getCache() {
        return this.cache;
    }

    public CurrencyConverter getCurrencyConverter() {
        return this.converter;
    }

    public PerformanceIndex calculate(DataSeries dataSeries, Interval reportingPeriod) {
        return this.dataSeriesCache.lookup(dataSeries, reportingPeriod);
    }

    public synchronized Map<Dashboard.Widget, Object> getResultCache() {
        return this.resultCache;
    }

    public synchronized void clearResultCache() {
        this.resultCache = Collections.synchronizedMap(new HashMap());
    }
}

