/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.util.List;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.LabelOnly;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.dashboard.WidgetConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.ui.views.dashboard.WidgetFactory;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesSelectionDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Display;

public class DataSeriesConfig
implements WidgetConfig {
    private final WidgetDelegate<?> delegate;
    private final boolean supportsBenchmarks;
    private final String label;
    private final Dashboard.Config configurationKey;
    private DataSeries dataSeries;

    public DataSeriesConfig(WidgetDelegate<?> delegate, boolean supportsBenchmarks) {
        this(delegate, supportsBenchmarks, false, Messages.LabelDataSeries, Dashboard.Config.DATA_SERIES);
    }

    protected DataSeriesConfig(WidgetDelegate<?> delegate, boolean supportsBenchmarks, boolean supportsEmptyDataSeries, String label, Dashboard.Config configurationKey) {
        this.delegate = delegate;
        this.supportsBenchmarks = supportsBenchmarks;
        this.label = label;
        this.configurationKey = configurationKey;
        String uuid = (String)delegate.getWidget().getConfiguration().get(configurationKey.name());
        if (uuid != null && !uuid.isEmpty()) {
            this.dataSeries = delegate.getDashboardData().getDataSeriesSet().lookup(uuid);
        }
        if (this.dataSeries == null && !supportsEmptyDataSeries) {
            this.dataSeries = delegate.getDashboardData().getDataSeriesSet().getAvailableSeries().stream().filter(ds -> ds.getType().equals((Object)DataSeries.Type.CLIENT)).findAny().orElseThrow(IllegalArgumentException::new);
        }
    }

    public DataSeries getDataSeries() {
        return this.dataSeries;
    }

    @Override
    public void menuAboutToShow(IMenuManager manager) {
        manager.appendToGroup("info", (IAction)new LabelOnly(this.getLabel()));
        MenuManager subMenu = new MenuManager(this.label, this.configurationKey.name());
        subMenu.add((IAction)new LabelOnly(this.dataSeries != null ? this.dataSeries.getLabel() : "-"));
        subMenu.add((IContributionItem)new Separator());
        subMenu.add((IAction)new SimpleAction(Messages.MenuSelectDataSeries, a -> this.doAddSeries(false)));
        if (this.supportsBenchmarks) {
            subMenu.add((IAction)new SimpleAction(Messages.MenuSelectBenchmarkDataSeries, a -> this.doAddSeries(true)));
        }
        manager.add((IContributionItem)subMenu);
    }

    private void doAddSeries(boolean showOnlyBenchmark) {
        List<DataSeries> list = this.delegate.getDashboardData().getDataSeriesSet().getAvailableSeries().stream().filter(ds -> ds.isBenchmark() == showOnlyBenchmark).collect(Collectors.toList());
        DataSeriesSelectionDialog dialog = new DataSeriesSelectionDialog(Display.getDefault().getActiveShell());
        dialog.setElements(list);
        dialog.setMultiSelection(false);
        if (dialog.open() != 0) {
            return;
        }
        List<DataSeries> result = dialog.getResult();
        if (result.isEmpty()) {
            return;
        }
        this.dataSeries = result.get(0);
        this.delegate.getWidget().getConfiguration().put(this.configurationKey.name(), this.dataSeries.getUUID());
        this.delegate.getWidget().setLabel(String.valueOf(WidgetFactory.valueOf(this.delegate.getWidget().getType()).getLabel()) + ", " + this.dataSeries.getLabel());
        this.delegate.update();
        this.delegate.getClient().touch();
    }

    @Override
    public String getLabel() {
        return String.valueOf(this.label) + ": " + (this.dataSeries != null ? this.dataSeries.getLabel() : "-");
    }
}

