/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import java.time.LocalDate;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.util.InfoToolTip;
import name.abuchen.portfolio.ui.views.dashboard.AbstractIndicatorWidget;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DashboardResources;
import name.abuchen.portfolio.ui.views.dashboard.DataSeriesConfig;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class IndicatorWidget<N extends Number>
extends AbstractIndicatorWidget<N> {
    private Values<N> formatter;
    private BiFunction<DataSeries, Interval, N> provider;
    private BiFunction<DataSeries, Interval, String> tooltip;
    private boolean isValueColored = true;

    public IndicatorWidget(Dashboard.Widget widget, DashboardData dashboardData, boolean supportsBenchmarks) {
        super(widget, dashboardData, supportsBenchmarks);
    }

    public static <N extends Number> Builder<N> create(Dashboard.Widget widget, DashboardData dashboardData) {
        return new Builder(widget, dashboardData);
    }

    void setFormatter(Values<N> formatter) {
        this.formatter = formatter;
    }

    void setProvider(BiFunction<DataSeries, Interval, N> provider) {
        this.provider = provider;
    }

    void setTooltip(BiFunction<DataSeries, Interval, String> tooltip) {
        this.tooltip = tooltip;
    }

    void setValueColored(boolean isValueColored) {
        this.isValueColored = isValueColored;
    }

    @Override
    public Composite createControl(Composite parent, DashboardResources resources) {
        Composite container = super.createControl(parent, resources);
        if (this.tooltip != null) {
            InfoToolTip.attach((Control)this.indicator, () -> this.tooltip.apply(this.get(DataSeriesConfig.class).getDataSeries(), this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now())));
        }
        return container;
    }

    @Override
    public Supplier<N> getUpdateTask() {
        return () -> (Number)this.provider.apply(this.get(DataSeriesConfig.class).getDataSeries(), this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now()));
    }

    @Override
    public void update(N value) {
        super.update(value);
        this.indicator.setText(this.formatter.format(value));
        if (this.isValueColored) {
            this.indicator.setTextColor(((Number)value).doubleValue() < 0.0 ? Colors.theme().redForeground() : Colors.theme().greenForeground());
        }
    }

    public static class Builder<N extends Number> {
        private Dashboard.Widget widget;
        private DashboardData dashboardData;
        private Values<N> formatter;
        private BiFunction<DataSeries, Interval, N> provider;
        private BiFunction<DataSeries, Interval, String> tooltip;
        private boolean supportsBenchmarks = true;
        private boolean isValueColored = true;

        public Builder(Dashboard.Widget widget, DashboardData dashboardData) {
            this.widget = widget;
            this.dashboardData = dashboardData;
        }

        Builder<N> with(Values<N> formatter) {
            this.formatter = formatter;
            return this;
        }

        Builder<N> with(BiFunction<DataSeries, Interval, N> provider) {
            this.provider = provider;
            return this;
        }

        Builder<N> withTooltip(BiFunction<DataSeries, Interval, String> tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        Builder<N> withBenchmarkDataSeries(boolean supportsBenchmarks) {
            this.supportsBenchmarks = supportsBenchmarks;
            return this;
        }

        Builder<N> withColoredValues(boolean isValueColored) {
            this.isValueColored = isValueColored;
            return this;
        }

        IndicatorWidget<N> build() {
            Objects.requireNonNull(this.formatter);
            Objects.requireNonNull(this.provider);
            IndicatorWidget<N> indicatorWidget = new IndicatorWidget<N>(this.widget, this.dashboardData, this.supportsBenchmarks);
            indicatorWidget.setFormatter(this.formatter);
            indicatorWidget.setProvider(this.provider);
            indicatorWidget.setTooltip(this.tooltip);
            indicatorWidget.setValueColored(this.isValueColored);
            return indicatorWidget;
        }
    }
}

