/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import com.ibm.icu.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.DoubleFunction;
import java.util.function.Predicate;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.snapshot.trades.Trade;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.views.dashboard.AbstractTradesWidget;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.EnumBasedConfig;
import name.abuchen.portfolio.ui.views.dashboard.WidgetDelegate;
import name.abuchen.portfolio.ui.views.trades.TradeDetailsView;
import name.abuchen.portfolio.util.Interval;
import name.abuchen.portfolio.util.TextUtil;

public class TradesAverageHoldingPeriodWidget
extends AbstractTradesWidget {
    private static final int DAYS_IN_YEAR = 365;

    public TradesAverageHoldingPeriodWidget(Dashboard.Widget widget, DashboardData dashboardData) {
        super(widget, dashboardData);
        this.addConfig(new MetricConfig(this));
    }

    @Override
    public void update(TradeDetailsView.Input input) {
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        List<Trade> trades = input.getTrades();
        double totalPurchasePrice = ((Money)trades.stream().map(Trade::getEntryValue).collect(MoneyCollectors.sum((String)this.getDashboardData().getCurrencyConverter().getTermCurrency()))).getAmount();
        double averageHoldingDays = trades.stream().mapToDouble(t -> (double)(t.getHoldingPeriod() * t.getEntryValue().getAmount()) / totalPurchasePrice).sum();
        this.indicator.setText(((Metric)((Object)this.get(MetricConfig.class).getValue())).format(averageHoldingDays));
        this.indicator.setToolTipText(Messages.TooltipAverageHoldingPeriod);
    }

    @Override
    protected Predicate<Trade> getFilter(Interval interval) {
        return t -> {
            LocalDate start = t.getStart().toLocalDate();
            LocalDate end = t.getEnd().map(LocalDateTime::toLocalDate).orElseGet(LocalDate::now);
            return !start.isAfter(interval.getEnd()) && end.isAfter(interval.getStart());
        };
    }

    public static enum Metric {
        DAY(Messages.LabelMetricDays, days -> MessageFormat.format((String)Messages.LabelMetricDaysFormatter, (Object[])new Object[]{Math.round(days)})),
        YEAR(Messages.LabelMetricYears, days -> MessageFormat.format((String)Messages.LabelMetricYearsFormatter, (Object[])new Object[]{days / 365.0}));

        private String label;
        private DoubleFunction<String> formatter;

        private Metric(String label, DoubleFunction<String> formatter) {
            this.label = label;
            this.formatter = formatter;
        }

        public String format(double days) {
            return this.formatter.apply(days);
        }

        public String toString() {
            return this.label;
        }
    }

    public static class MetricConfig
    extends EnumBasedConfig<Metric> {
        public MetricConfig(WidgetDelegate<?> delegate) {
            super(delegate, Messages.LabelMetric, Metric.class, Dashboard.Config.METRIC, EnumBasedConfig.Policy.EXACTLY_ONE);
        }
    }
}

