/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard;

import com.ibm.icu.text.MessageFormat;
import java.util.List;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.Money;
import name.abuchen.portfolio.money.MoneyCollectors;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.trades.Trade;
import name.abuchen.portfolio.ui.views.dashboard.AbstractTradesWidget;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.trades.TradeDetailsView;
import name.abuchen.portfolio.util.TextUtil;

public class TradesProfitLossWidget
extends AbstractTradesWidget {
    public TradesProfitLossWidget(Dashboard.Widget widget, DashboardData dashboardData) {
        super(widget, dashboardData);
    }

    @Override
    public void update(TradeDetailsView.Input input) {
        this.title.setText(TextUtil.tooltip((String)this.getWidget().getLabel()));
        List<Trade> trades = input.getTrades();
        Money profitLoss = (Money)trades.stream().map(Trade::getProfitLoss).collect(MoneyCollectors.sum((String)this.getDashboardData().getCurrencyConverter().getTermCurrency()));
        this.indicator.setText(MessageFormat.format((String)(profitLoss.isNegative() ? "<red>{0}</red>" : "<green>{0}</green>"), (Object[])new Object[]{Values.Money.format(profitLoss, this.getClient().getBaseCurrency())}));
    }
}

