/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard.heatmap;

import java.time.LocalDate;
import java.time.Year;
import java.util.Arrays;
import java.util.function.DoubleBinaryOperator;
import java.util.function.ToDoubleFunction;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.DataSeriesConfig;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.AbstractHeatmapWidget;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.ColorSchemaConfig;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.ExcessReturnDataSeriesConfig;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.ExcessReturnOperator;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.ExcessReturnOperatorConfig;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.HeatmapModel;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.HeatmapOrnament;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.HeatmapOrnamentConfig;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.util.Interval;

public class PerformanceHeatmapWidget
extends AbstractHeatmapWidget<Double> {
    public PerformanceHeatmapWidget(Dashboard.Widget widget, DashboardData data) {
        super(widget, data);
        this.addConfig(new ColorSchemaConfig(this));
        this.addConfig(new HeatmapOrnamentConfig(this));
        this.addConfig(new DataSeriesConfig(this, true));
        this.addConfig(new ExcessReturnDataSeriesConfig(this));
        this.addConfig(new ExcessReturnOperatorConfig(this));
    }

    @Override
    protected HeatmapModel<Double> build() {
        int numDashboardColumns = this.getDashboardData().getDashboard().getColumns().size();
        Interval interval = this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(LocalDate.now());
        Interval calcInterval = Interval.of((LocalDate)(interval.getStart().getDayOfMonth() == interval.getStart().lengthOfMonth() ? interval.getStart() : interval.getStart().withDayOfMonth(1).minusDays(1L)), (LocalDate)interval.getEnd().withDayOfMonth(interval.getEnd().lengthOfMonth()));
        DataSeries dataSeries = this.get(DataSeriesConfig.class).getDataSeries();
        PerformanceIndex performanceIndex = this.getDashboardData().calculate(dataSeries, calcInterval);
        ToDoubleFunction<LocalDate> calculatePerformance = month -> this.getPerformanceFor(performanceIndex, (LocalDate)month);
        ToDoubleFunction<LocalDate> calculateSum = year -> this.getSumPerformance(performanceIndex, (LocalDate)year);
        DataSeries benchmark = this.get(ExcessReturnDataSeriesConfig.class).getDataSeries();
        if (benchmark != null) {
            PerformanceIndex benchmarkIndex = this.getDashboardData().calculate(benchmark, calcInterval);
            DoubleBinaryOperator operator = ((ExcessReturnOperator)((Object)this.get(ExcessReturnOperatorConfig.class).getValue())).getOperator();
            calculatePerformance = month -> operator.applyAsDouble(this.getPerformanceFor(performanceIndex, (LocalDate)month), this.getPerformanceFor(benchmarkIndex, (LocalDate)month));
            calculateSum = year -> operator.applyAsDouble(this.getSumPerformance(performanceIndex, (LocalDate)year), this.getSumPerformance(benchmarkIndex, (LocalDate)year));
        }
        Interval actualInterval = performanceIndex.getActualInterval();
        boolean showSum = this.get(HeatmapOrnamentConfig.class).getValues().contains((Object)HeatmapOrnament.SUM);
        boolean showStandardDeviation = this.get(HeatmapOrnamentConfig.class).getValues().contains((Object)HeatmapOrnament.STANDARD_DEVIATION);
        HeatmapModel<Double> model = new HeatmapModel<Double>(numDashboardColumns == 1 ? Values.Percent : Values.PercentShort);
        model.setCellToolTip(v -> Messages.PerformanceHeatmapToolTip);
        this.addMonthlyHeader(model, numDashboardColumns, showSum, showStandardDeviation, false);
        for (Year year2 : actualInterval.getYears()) {
            String label = numDashboardColumns > 2 ? String.valueOf(year2.getValue() % 100) : String.valueOf(year2);
            HeatmapModel.Row<Double> row = new HeatmapModel.Row<Double>(label);
            LocalDate month2 = LocalDate.of(year2.getValue(), 1, 1);
            while (month2.getYear() == year2.getValue()) {
                if (actualInterval.contains(month2)) {
                    row.addData(calculatePerformance.applyAsDouble(month2));
                } else {
                    row.addData(null);
                }
                month2 = month2.plusMonths(1L);
            }
            if (showSum) {
                row.addData(calculateSum.applyAsDouble(LocalDate.of(year2.getValue(), 1, 1)));
            }
            if (showStandardDeviation) {
                row.addData(this.standardDeviation(row.getDataSubList(0, 12)));
            }
            model.addRow(row);
        }
        if (this.get(HeatmapOrnamentConfig.class).getValues().contains((Object)HeatmapOrnament.GEOMETRIC_MEAN)) {
            HeatmapModel.Row<Double> geometricMean = new HeatmapModel.Row<Double>("x\u0304 geom");
            int index = 0;
            while (index < model.getHeaderSize()) {
                geometricMean.addData(this.geometricMean(model.getColumnValues(index)));
                ++index;
            }
            model.addRow(geometricMean);
        }
        return model;
    }

    private double getPerformanceFor(PerformanceIndex index, LocalDate month) {
        int end;
        int start = Arrays.binarySearch(index.getDates(), month.minusDays(1L));
        if (start < 0) {
            start = 0;
        }
        if ((end = Arrays.binarySearch(index.getDates(), month.withDayOfMonth(month.lengthOfMonth()))) < 0) {
            end = index.getDates().length - 1;
        }
        return (index.getAccumulatedPercentage()[end] + 1.0) / (index.getAccumulatedPercentage()[start] + 1.0) - 1.0;
    }

    private double getSumPerformance(PerformanceIndex index, LocalDate year) {
        int end;
        int start = Arrays.binarySearch(index.getDates(), year.minusDays(1L));
        if (start < 0) {
            start = 0;
        }
        if ((end = Arrays.binarySearch(index.getDates(), year.withDayOfYear(year.lengthOfYear()))) < 0) {
            end = index.getDates().length - 1;
        }
        return (index.getAccumulatedPercentage()[end] + 1.0) / (index.getAccumulatedPercentage()[start] + 1.0) - 1.0;
    }
}

