/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dashboard.heatmap;

import java.time.LocalDate;
import java.time.Year;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import name.abuchen.portfolio.model.Dashboard;
import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.snapshot.ReportingPeriod;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.views.dashboard.DashboardData;
import name.abuchen.portfolio.ui.views.dashboard.MultiDataSeriesConfig;
import name.abuchen.portfolio.ui.views.dashboard.ReportingPeriodConfig;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.AbstractHeatmapWidget;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.ColorSchemaConfig;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.HeatmapModel;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.HeatmapOrnament;
import name.abuchen.portfolio.ui.views.dashboard.heatmap.HeatmapOrnamentConfig;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.util.Interval;

public class YearlyPerformanceHeatmapWidget
extends AbstractHeatmapWidget<Double> {
    public YearlyPerformanceHeatmapWidget(Dashboard.Widget widget, DashboardData data) {
        super(widget, data);
        this.addConfig(new ColorSchemaConfig(this));
        this.addConfig(new HeatmapOrnamentConfig(this));
        this.addConfig(new MultiDataSeriesConfig(this));
    }

    @Override
    protected HeatmapModel<Double> build() {
        int numDashboardColumns = this.getDashboardData().getDashboard().getColumns().size();
        LocalDate now = LocalDate.now();
        Interval interval = this.get(ReportingPeriodConfig.class).getReportingPeriod().toInterval(now);
        List<DataSeries> dataSeries = this.get(MultiDataSeriesConfig.class).getDataSeries();
        Interval calcInterval = Interval.of((LocalDate)(interval.getStart().getDayOfYear() == interval.getStart().lengthOfYear() ? interval.getStart() : interval.getStart().withDayOfYear(1).minusDays(1L)), (LocalDate)interval.getEnd().withDayOfYear(interval.getEnd().lengthOfYear()));
        HeatmapModel<Double> model = new HeatmapModel<Double>(numDashboardColumns == 1 ? Values.Percent : Values.PercentShort);
        model.setCellToolTip(v -> Messages.YearlyPerformanceHeatmapToolTip);
        for (DataSeries s : dataSeries) {
            model.addHeader(s.getLabel());
        }
        for (Year year : calcInterval.getYears()) {
            String label = numDashboardColumns > 2 ? String.valueOf(year.getValue() % 100) : String.valueOf(year);
            HeatmapModel.Row<Double> row = new HeatmapModel.Row<Double>(label);
            for (DataSeries series : dataSeries) {
                PerformanceIndex performanceIndex = this.getDashboardData().calculate(series, new ReportingPeriod.YearX(year.getValue()).toInterval(now));
                row.addData(performanceIndex.getFinalAccumulatedPercentage());
            }
            model.addRow(row);
        }
        HeatmapModel.Row<Double> sum = null;
        if (this.get(HeatmapOrnamentConfig.class).getValues().contains((Object)HeatmapOrnament.SUM)) {
            sum = new HeatmapModel.Row<Double>("\u03a3", HeatmapOrnament.SUM.toString());
            for (DataSeries series : dataSeries) {
                PerformanceIndex performanceIndex = this.getDashboardData().calculate(series, calcInterval);
                sum.addData(performanceIndex.getFinalAccumulatedPercentage());
            }
        }
        HeatmapModel.Row<Double> sd = null;
        if (this.get(HeatmapOrnamentConfig.class).getValues().contains((Object)HeatmapOrnament.STANDARD_DEVIATION)) {
            sd = new HeatmapModel.Row<Double>("s", HeatmapOrnament.STANDARD_DEVIATION.toString());
            int ii = 0;
            while (ii < dataSeries.size()) {
                sd.addData(this.standardDeviation(model.getColumnValues(ii)));
                ++ii;
            }
        }
        if (sum != null) {
            model.addRow(sum);
        }
        if (sd != null) {
            model.addRow(sd);
        }
        if (this.get(HeatmapOrnamentConfig.class).getValues().contains((Object)HeatmapOrnament.GEOMETRIC_MEAN)) {
            model.addHeader("x\u0304 geom");
            model.getRows().forEach(r -> r.addData(this.geometricMean(r.getData().filter(Objects::nonNull).collect(Collectors.toList()))));
        }
        return model;
    }
}

