/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesCache;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.swtchart.IBarSeries;
import org.swtchart.ILineSeries;

public abstract class AbstractChartSeriesBuilder {
    private final TimelineChart chart;
    private final DataSeriesCache cache;
    private final LocalResourceManager resources;

    public AbstractChartSeriesBuilder(TimelineChart chart, DataSeriesCache cache) {
        this.chart = chart;
        this.cache = cache;
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)chart);
    }

    public DataSeriesCache getCache() {
        return this.cache;
    }

    public TimelineChart getChart() {
        return this.chart;
    }

    protected void configure(DataSeries series, ILineSeries lineSeries) {
        Color color = this.resources.createColor(series.getColor());
        lineSeries.setLineColor(color);
        lineSeries.setSymbolColor(color);
        lineSeries.enableArea(series.isShowArea());
        lineSeries.setLineStyle(series.getLineStyle());
    }

    protected void configure(DataSeries series, IBarSeries barSeries) {
        barSeries.setBarPadding(50);
        barSeries.setBarColor(this.resources.createColor(series.getColor()));
    }
}

