/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import java.util.Iterator;
import org.eclipse.swt.graphics.RGB;

class ColorWheel
implements Iterator<RGB> {
    private static final float HUE = 262.3f;
    private static final float SATURATION = 0.464f;
    private static final float BRIGHTNESS = 0.886f;
    private int index;
    private float[][] hsbColors;

    ColorWheel(int size) {
        this.hsbColors = new float[size][];
        float step = 360.0f / (float)size;
        int ii = 0;
        while (ii < size) {
            this.hsbColors[ii] = new float[]{(262.3f + step * (float)ii) % 360.0f, 0.464f, 0.886f};
            ++ii;
        }
    }

    private RGB getRGB(int segment) {
        float[] hsb = this.hsbColors[segment % this.hsbColors.length];
        return new RGB(hsb[0], hsb[1], hsb[2]);
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public RGB next() {
        return this.getRGB(this.index++);
    }
}

