/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.money.CurrencyConverter;
import name.abuchen.portfolio.money.CurrencyConverterImpl;
import name.abuchen.portfolio.money.ExchangeRateProviderFactory;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyAccount;
import name.abuchen.portfolio.snapshot.filter.ReadOnlyPortfolio;
import name.abuchen.portfolio.snapshot.filter.WithoutTaxesFilter;
import name.abuchen.portfolio.ui.PortfolioPlugin;
import name.abuchen.portfolio.ui.util.CacheKey;
import name.abuchen.portfolio.ui.util.ClientFilterMenu;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.util.Interval;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class DataSeriesCache {
    private final Client client;
    private final Map<CacheKey, PerformanceIndex> cache = Collections.synchronizedMap(new HashMap());
    private CurrencyConverter converter;

    @Inject
    public DataSeriesCache(Client client, ExchangeRateProviderFactory factory) {
        this.client = client;
        this.converter = new CurrencyConverterImpl(factory, client.getBaseCurrency());
    }

    public void clear() {
        this.converter = this.converter.with(this.client.getBaseCurrency());
        this.cache.clear();
    }

    public PerformanceIndex lookup(DataSeries series, Interval reportingPeriod) {
        String uuid = series.getType() == DataSeries.Type.CLIENT ? "$client$" : series.getUUID();
        CacheKey key = new CacheKey(uuid, reportingPeriod);
        PerformanceIndex result = this.cache.get(key);
        if (result != null) {
            return result;
        }
        result = this.calculate(series, reportingPeriod);
        this.cache.put(key, result);
        return result;
    }

    private PerformanceIndex calculate(DataSeries series, Interval reportingPeriod) {
        ArrayList<Exception> warnings = new ArrayList<Exception>();
        try {
            switch (series.getType()) {
                case CLIENT: {
                    PerformanceIndex performanceIndex = PerformanceIndex.forClient((Client)this.client, (CurrencyConverter)this.converter, (Interval)reportingPeriod, warnings);
                    return performanceIndex;
                }
                case CLIENT_PRETAX: {
                    PerformanceIndex performanceIndex = PerformanceIndex.forClient((Client)new WithoutTaxesFilter().filter(this.client), (CurrencyConverter)this.converter, (Interval)reportingPeriod, warnings);
                    return performanceIndex;
                }
                case SECURITY: {
                    PerformanceIndex performanceIndex = PerformanceIndex.forInvestment((Client)this.client, (CurrencyConverter)this.converter, (Security)((Security)series.getInstance()), (Interval)reportingPeriod, warnings);
                    return performanceIndex;
                }
                case SECURITY_BENCHMARK: {
                    PerformanceIndex performanceIndex = PerformanceIndex.forSecurity((PerformanceIndex)this.lookup(new DataSeries(DataSeries.Type.CLIENT, null, null, null), reportingPeriod), (Security)((Security)series.getInstance()));
                    return performanceIndex;
                }
                case PORTFOLIO: {
                    PerformanceIndex performanceIndex = PerformanceIndex.forPortfolio((Client)this.client, (CurrencyConverter)this.converter, (Portfolio)((Portfolio)series.getInstance()), (Interval)reportingPeriod, warnings);
                    return performanceIndex;
                }
                case PORTFOLIO_PRETAX: {
                    PerformanceIndex performanceIndex = this.calculatePortfolioPretax(series, reportingPeriod, warnings);
                    return performanceIndex;
                }
                case PORTFOLIO_PLUS_ACCOUNT: {
                    PerformanceIndex performanceIndex = PerformanceIndex.forPortfolioPlusAccount((Client)this.client, (CurrencyConverter)this.converter, (Portfolio)((Portfolio)series.getInstance()), (Interval)reportingPeriod, warnings);
                    return performanceIndex;
                }
                case PORTFOLIO_PLUS_ACCOUNT_PRETAX: {
                    PerformanceIndex performanceIndex = this.calculatePortfolioPlusAccountPretax(series, reportingPeriod, warnings);
                    return performanceIndex;
                }
                case ACCOUNT: {
                    Account account = (Account)series.getInstance();
                    PerformanceIndex performanceIndex = PerformanceIndex.forAccount((Client)this.client, (CurrencyConverter)this.converter, (Account)account, (Interval)reportingPeriod, warnings);
                    return performanceIndex;
                }
                case ACCOUNT_PRETAX: {
                    PerformanceIndex performanceIndex = this.calculateAccountPretax(series, reportingPeriod, warnings);
                    return performanceIndex;
                }
                case CLASSIFICATION: {
                    Classification classification = (Classification)series.getInstance();
                    PerformanceIndex performanceIndex = PerformanceIndex.forClassification((Client)this.client, (CurrencyConverter)this.converter, (Classification)classification, (Interval)reportingPeriod, warnings);
                    return performanceIndex;
                }
                case CLIENT_FILTER: {
                    ClientFilterMenu.Item item = (ClientFilterMenu.Item)series.getInstance();
                    PerformanceIndex performanceIndex = PerformanceIndex.forClient((Client)item.getFilter().filter(this.client), (CurrencyConverter)this.converter, (Interval)reportingPeriod, warnings);
                    return performanceIndex;
                }
                case CLIENT_FILTER_PRETAX: {
                    ClientFilterMenu.Item pretax = (ClientFilterMenu.Item)series.getInstance();
                    PerformanceIndex performanceIndex = PerformanceIndex.forClient((Client)new WithoutTaxesFilter().filter(pretax.getFilter().filter(this.client)), (CurrencyConverter)this.converter, (Interval)reportingPeriod, warnings);
                    return performanceIndex;
                }
            }
            throw new IllegalArgumentException(series.getType().name());
        }
        finally {
            if (!warnings.isEmpty()) {
                PortfolioPlugin.log(warnings);
            }
        }
    }

    private PerformanceIndex calculatePortfolioPretax(DataSeries series, Interval reportingPeriod, List<Exception> warnings) {
        Client filteredClient = new WithoutTaxesFilter().filter(this.client);
        Portfolio portfolio = filteredClient.getPortfolios().stream().filter(p -> ((ReadOnlyPortfolio)p).getSource().equals(series.getInstance())).findAny().orElseThrow(IllegalArgumentException::new);
        return PerformanceIndex.forPortfolio((Client)filteredClient, (CurrencyConverter)this.converter, (Portfolio)portfolio, (Interval)reportingPeriod, warnings);
    }

    private PerformanceIndex calculatePortfolioPlusAccountPretax(DataSeries series, Interval reportingPeriod, List<Exception> warnings) {
        Client filteredClient = new WithoutTaxesFilter().filter(this.client);
        Portfolio portfolio = filteredClient.getPortfolios().stream().filter(p -> ((ReadOnlyPortfolio)p).getSource().equals(series.getInstance())).findAny().orElseThrow(IllegalArgumentException::new);
        return PerformanceIndex.forPortfolioPlusAccount((Client)this.client, (CurrencyConverter)this.converter, (Portfolio)portfolio, (Interval)reportingPeriod, warnings);
    }

    private PerformanceIndex calculateAccountPretax(DataSeries series, Interval reportingPeriod, List<Exception> warnings) {
        Client filteredClient = new WithoutTaxesFilter().filter(this.client);
        Account account = filteredClient.getAccounts().stream().filter(a -> ((ReadOnlyAccount)a).getSource().equals(series.getInstance())).findAny().orElseThrow(IllegalArgumentException::new);
        return PerformanceIndex.forAccount((Client)this.client, (CurrencyConverter)this.converter, (Account)account, (Interval)reportingPeriod, warnings);
    }
}

