/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import name.abuchen.portfolio.ui.Images;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.SimpleAction;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesConfigurator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.swtchart.LineStyle;

public class DataSeriesChartLegend
extends Composite {
    private final DataSeriesConfigurator configurator;
    private final LocalResourceManager resources;

    public DataSeriesChartLegend(Composite parent, DataSeriesConfigurator configurator) {
        super(parent, 0);
        this.configurator = configurator;
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.setLayout(new RowPlusChevronLayout(this));
        for (DataSeries series : configurator.getSelectedDataSeries()) {
            new PaintItem(this, series);
        }
        this.configurator.addListener(this::onUpdate);
    }

    private void onUpdate() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof PaintItem) {
                child.dispose();
            }
            ++n2;
        }
        for (DataSeries series : this.configurator.getSelectedDataSeries()) {
            new PaintItem(this, series);
        }
        this.layout();
        this.getParent().layout();
    }

    private static final class PaintItem
    extends Canvas
    implements Listener {
        private static final ResourceBundle LABELS = ResourceBundle.getBundle("name.abuchen.portfolio.ui.views.labels");
        private final DataSeries series;

        private PaintItem(Composite parent, DataSeries series) {
            super(parent, 0);
            this.series = series;
            this.addListener(9, this);
            this.addListener(11, this);
            MenuManager menuManager = new MenuManager();
            menuManager.setRemoveAllWhenShown(true);
            menuManager.addMenuListener(this::seriesMenuAboutToShow);
            this.setMenu(menuManager.createContextMenu((Control)this));
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 9: {
                    this.paintControl(event);
                    break;
                }
                case 11: {
                    this.redraw();
                    break;
                }
            }
        }

        private Color getColor() {
            DataSeriesChartLegend legend = (DataSeriesChartLegend)this.getParent();
            return legend.resources.createColor(this.series.getColor());
        }

        private void paintControl(Event e) {
            Color oldForeground = e.gc.getForeground();
            Color oldBackground = e.gc.getBackground();
            Point size = this.getSize();
            Rectangle r = new Rectangle(0, 0, size.y, size.y);
            GC gc = e.gc;
            gc.setBackground(this.getColor());
            gc.fillRectangle(r.x, r.y, r.width, r.height);
            gc.setForeground(this.getForeground());
            gc.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
            String text = this.series.getLabel();
            e.gc.setForeground(this.getForeground());
            e.gc.drawString(text, size.y + 2, 1, true);
            e.gc.setForeground(oldForeground);
            e.gc.setBackground(oldBackground);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            String text = this.series.getLabel();
            GC gc = new GC((Drawable)this);
            Point extentText = gc.stringExtent(text);
            gc.dispose();
            return new Point(extentText.x + extentText.y + 12, extentText.y + 2);
        }

        private void seriesMenuAboutToShow(IMenuManager manager) {
            final DataSeriesConfigurator configurator = ((DataSeriesChartLegend)this.getParent()).configurator;
            manager.add((IAction)new Action(Messages.ChartSeriesPickerColor){

                public void run() {
                    ColorDialog colorDialog = new ColorDialog(Display.getDefault().getActiveShell());
                    colorDialog.setRGB(series.getColor());
                    RGB newColor = colorDialog.open();
                    if (newColor != null) {
                        series.setColor(newColor);
                        configurator.fireUpdate();
                    }
                }
            });
            if (this.series.isLineChart()) {
                MenuManager lineStyle = new MenuManager(Messages.ChartSeriesPickerLineStyle);
                LineStyle[] lineStyleArray = LineStyle.values();
                int n = lineStyleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LineStyle style = lineStyleArray[n2];
                    if (style != LineStyle.NONE) {
                        SimpleAction action = new SimpleAction(LABELS.getString("lineStyle." + style.name()), a -> {
                            this.series.setLineStyle(style);
                            configurator.fireUpdate();
                        });
                        action.setChecked(style == this.series.getLineStyle());
                        lineStyle.add((IAction)action);
                    }
                    ++n2;
                }
                manager.add((IContributionItem)lineStyle);
                SimpleAction actionShowArea = new SimpleAction(Messages.ChartSeriesPickerShowArea, a -> {
                    this.series.setShowArea(!this.series.isShowArea());
                    configurator.fireUpdate();
                });
                actionShowArea.setChecked(this.series.isShowArea());
                manager.add((IAction)actionShowArea);
            }
            if (configurator.getSelectedDataSeries().size() > 1) {
                manager.add((IContributionItem)new Separator());
                MenuManager position = new MenuManager(Messages.ChartMenuPosition);
                manager.add((IContributionItem)position);
                int index = configurator.getSelectedDataSeries().indexOf(this.series);
                if (index > 0) {
                    position.add((IAction)new SimpleAction(Messages.ChartBringForward, a -> {
                        Collections.swap(configurator.getSelectedDataSeries(), index, index - 1);
                        configurator.fireUpdate();
                    }));
                    position.add((IAction)new SimpleAction(Messages.ChartBringToFront, a -> {
                        DataSeries s = configurator.getSelectedDataSeries().remove(index);
                        configurator.getSelectedDataSeries().add(0, s);
                        configurator.fireUpdate();
                    }));
                }
                if (index < configurator.getSelectedDataSeries().size() - 1) {
                    position.add((IAction)new SimpleAction(Messages.ChartSendBackwards, a -> {
                        Collections.swap(configurator.getSelectedDataSeries(), index, index + 1);
                        configurator.fireUpdate();
                    }));
                    position.add((IAction)new SimpleAction(Messages.ChartSendToBack, a -> {
                        DataSeries s = configurator.getSelectedDataSeries().remove(index);
                        configurator.getSelectedDataSeries().add(s);
                        configurator.fireUpdate();
                    }));
                }
                MenuManager sorting = new MenuManager(Messages.ChartMenuSorting);
                manager.add((IContributionItem)sorting);
                sorting.add((IAction)new SimpleAction(Messages.ChartSortAZ, a -> {
                    Collections.sort(configurator.getSelectedDataSeries(), (r, l) -> r.getLabel().compareTo(l.getLabel()));
                    configurator.fireUpdate();
                }));
                sorting.add((IAction)new SimpleAction(Messages.ChartSortZA, a -> {
                    Collections.sort(configurator.getSelectedDataSeries(), (r, l) -> l.getLabel().compareTo(r.getLabel()));
                    configurator.fireUpdate();
                }));
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new SimpleAction(Messages.ChartSeriesPickerRemove, a -> configurator.doDeleteSeries(this.series)));
        }
    }

    private class RowPlusChevronLayout
    extends Layout {
        private static final int LINES = 2;
        private static final int PADDING = 5;
        private static final int MARGIN = 5;
        private ImageHyperlink chevron;
        private Menu chevronMenu;
        private List<PaintItem> invisible = new ArrayList<PaintItem>();
        private Map<Color, Image> colorRectangles = new HashMap<Color, Image>();

        private RowPlusChevronLayout(Composite host) {
            this.chevron = new ImageHyperlink(host, 8);
            this.chevron.setImage(Images.CHEVRON.image());
            this.chevron.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ImageHyperlink item = (ImageHyperlink)e.widget;
                    if (RowPlusChevronLayout.this.chevronMenu == null) {
                        MenuManager menuMgr = new MenuManager("#PopupMenu");
                        menuMgr.setRemoveAllWhenShown(true);
                        menuMgr.addMenuListener(mgr -> RowPlusChevronLayout.this.overflowMenuAboutToShow(mgr));
                        RowPlusChevronLayout.this.chevronMenu = menuMgr.createContextMenu((Control)item.getParent());
                    }
                    Rectangle rect = item.getBounds();
                    Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                    RowPlusChevronLayout.this.chevronMenu.setLocation(pt.x, pt.y + rect.height);
                    RowPlusChevronLayout.this.chevronMenu.setVisible(true);
                    item.addDisposeListener(event -> RowPlusChevronLayout.this.chevronMenu.dispose());
                }
            });
            this.chevron.addDisposeListener(e -> this.colorRectangles.values().stream().forEach(image -> image.dispose()));
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return this.layout(composite, wHint);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            this.layout(composite, clientArea.width);
        }

        private Point layout(Composite composite, int wHint) {
            this.invisible.clear();
            Point chevronSize = this.chevron.computeSize(-1, -1);
            this.chevron.setVisible(false);
            PaintItem[] children = this.getChildren(composite);
            Point[] sizes = new Point[children.length];
            int ii = 0;
            while (ii < children.length) {
                sizes[ii] = children[ii].computeSize(-1, -1);
                ++ii;
            }
            int x = 0;
            int y = 0;
            int line = 0;
            int lineHeight = 0;
            int width = 0;
            int height = 0;
            int ii2 = 0;
            while (ii2 < sizes.length) {
                if (wHint == -1 || line < 1 && x + 5 + sizes[ii2].x <= wHint - 5 || line == 1 && x + 1 == children.length && x + 5 + sizes[ii2].x <= wHint - 5 || line == 1 && x + 5 + sizes[ii2].x + 5 + chevronSize.x <= wHint - 5) {
                    children[ii2].setBounds(x + 5, y + 5, sizes[ii2].x, sizes[ii2].y);
                    children[ii2].setVisible(true);
                    lineHeight = Math.max(lineHeight, sizes[ii2].y);
                    width = Math.max(x += 5 + sizes[ii2].x, width);
                    height = Math.max(y + 5 + sizes[ii2].y, height);
                } else {
                    if (line >= 1) {
                        this.invisible.add(children[ii2]);
                        children[ii2].setVisible(false);
                        this.chevron.setBounds(x + 5, y + 5, chevronSize.x, chevronSize.y);
                        this.chevron.setVisible(true);
                        lineHeight = Math.max(lineHeight, sizes[ii2].y);
                        width = Math.max(x += 5 + chevronSize.x, width);
                        height = Math.max(y + 5 + sizes[ii2].y, height);
                        int jj = ii2 + 1;
                        while (jj < children.length) {
                            this.invisible.add(children[jj]);
                            children[jj].setVisible(false);
                            ++jj;
                        }
                        break;
                    }
                    x = 0;
                    y += 5 + lineHeight;
                    ++line;
                    lineHeight = 0;
                    children[ii2].setBounds(x + 5, y + 5, sizes[ii2].x, sizes[ii2].y);
                    children[ii2].setVisible(true);
                    lineHeight = Math.max(lineHeight, sizes[ii2].y);
                    width = Math.max(x += 5 + sizes[ii2].x, width);
                    height = Math.max(y + 5 + sizes[ii2].y, height);
                }
                ++ii2;
            }
            return new Point(width + 5, height + 5);
        }

        private PaintItem[] getChildren(Composite composite) {
            Control[] children = composite.getChildren();
            PaintItem[] answer = new PaintItem[children.length - 1];
            int index = 0;
            int ii = 0;
            while (ii < children.length) {
                if (children[ii] instanceof PaintItem) {
                    answer[index++] = (PaintItem)children[ii];
                }
                ++ii;
            }
            return answer;
        }

        private void overflowMenuAboutToShow(IMenuManager manager) {
            for (PaintItem item : this.invisible) {
                Image image = this.colorRectangles.computeIfAbsent(item.getColor(), color -> {
                    Image i = new Image(null, 16, 16);
                    GC gc = new GC((Drawable)i);
                    gc.setBackground(color);
                    gc.fillRectangle(0, 0, 16, 16);
                    gc.dispose();
                    return i;
                });
                MenuManager mgr = new MenuManager(item.series.getLabel(), ImageDescriptor.createFromImage((Image)image), null);
                manager.add((IContributionItem)mgr);
                item.seriesMenuAboutToShow((IMenuManager)mgr);
            }
        }
    }
}

