/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import name.abuchen.portfolio.model.Account;
import name.abuchen.portfolio.model.Classification;
import name.abuchen.portfolio.model.Client;
import name.abuchen.portfolio.model.Portfolio;
import name.abuchen.portfolio.model.Security;
import name.abuchen.portfolio.model.Taxonomy;
import name.abuchen.portfolio.ui.Messages;
import name.abuchen.portfolio.ui.util.ClientFilterMenu;
import name.abuchen.portfolio.ui.util.Colors;
import name.abuchen.portfolio.ui.views.dataseries.ColorWheel;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;

public class DataSeriesSet {
    private DataSeries.UseCase useCase;
    private final List<DataSeries> availableSeries = new ArrayList<DataSeries>();

    public DataSeriesSet(Client client, IPreferenceStore preferences, DataSeries.UseCase useCase) {
        this.useCase = useCase;
        ColorWheel wheel = new ColorWheel(30);
        switch (useCase) {
            case STATEMENT_OF_ASSETS: {
                this.buildStatementOfAssetsDataSeries();
                break;
            }
            case PERFORMANCE: {
                this.buildPerformanceDataSeries(client, preferences, wheel);
                break;
            }
            case RETURN_VOLATILITY: {
                this.buildReturnVolatilitySeries(client, preferences, wheel);
                break;
            }
            default: {
                throw new IllegalArgumentException(useCase.name());
            }
        }
        this.buildCommonDataSeries(client, preferences, wheel);
    }

    public DataSeries.UseCase getUseCase() {
        return this.useCase;
    }

    public List<DataSeries> getAvailableSeries() {
        return this.availableSeries;
    }

    public DataSeries lookup(String uuid) {
        return this.availableSeries.stream().filter(d -> d.getUUID().equals(uuid)).findAny().orElse(null);
    }

    private void buildStatementOfAssetsDataSeries() {
        this.availableSeries.add(new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.TOTALS, Messages.LabelTotalSum, Colors.TOTALS.getRGB()));
        DataSeries series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.TRANSFERALS, Messages.LabelTransferals, Display.getDefault().getSystemColor(16).getRGB());
        series.setLineChart(false);
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.INVESTED_CAPITAL, Messages.LabelInvestedCapital, Display.getDefault().getSystemColor(15).getRGB());
        series.setShowArea(true);
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.ABSOLUTE_INVESTED_CAPITAL, Messages.LabelAbsoluteInvestedCapital, Display.getDefault().getSystemColor(15).getRGB());
        series.setShowArea(true);
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.ABSOLUTE_DELTA, Messages.LabelDelta, Display.getDefault().getSystemColor(15).getRGB());
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.ABSOLUTE_DELTA_ALL_RECORDS, Messages.LabelAbsoluteDelta, Display.getDefault().getSystemColor(15).getRGB());
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.TAXES, Messages.LabelAccumulatedTaxes, Display.getDefault().getSystemColor(3).getRGB());
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.DIVIDENDS, Messages.LabelDividends, Display.getDefault().getSystemColor(12).getRGB());
        series.setLineChart(false);
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.DIVIDENDS_ACCUMULATED, Messages.LabelAccumulatedDividends, Display.getDefault().getSystemColor(12).getRGB());
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.INTEREST, Messages.LabelInterest, Colors.DARK_GREEN.getRGB());
        series.setLineChart(false);
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.INTEREST_ACCUMULATED, Messages.LabelAccumulatedInterest, Colors.DARK_GREEN.getRGB());
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.INTEREST_CHARGE, Messages.LabelInterestCharge, Colors.DARK_GREEN.getRGB());
        series.setLineChart(false);
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.INTEREST_CHARGE_ACCUMULATED, Messages.LabelAccumulatedInterestCharge, Colors.DARK_GREEN.getRGB());
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.EARNINGS, Messages.LabelEarnings, Colors.DARK_GREEN.getRGB());
        series.setLineChart(false);
        this.availableSeries.add(series);
        series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.EARNINGS_ACCUMULATED, Messages.LabelAccumulatedEarnings, Colors.DARK_GREEN.getRGB());
        this.availableSeries.add(series);
    }

    private void buildPerformanceDataSeries(Client client, IPreferenceStore preferences, ColorWheel wheel) {
        this.availableSeries.add(new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.TOTALS, Messages.PerformanceChartLabelEntirePortfolio, Colors.TOTALS.getRGB()));
        DataSeries series = new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.DELTA_PERCENTAGE, Messages.LabelAggregationDaily, Display.getDefault().getSystemColor(16).getRGB());
        series.setLineChart(false);
        this.availableSeries.add(series);
        for (Security security : client.getSecurities()) {
            series = new DataSeries(DataSeries.Type.SECURITY_BENCHMARK, security, security.getName(), wheel.next());
            series.setBenchmark(true);
            this.availableSeries.add(series);
        }
        this.buildPreTaxDataSeries(client, preferences, wheel);
    }

    private void buildReturnVolatilitySeries(Client client, IPreferenceStore preferences, ColorWheel wheel) {
        this.availableSeries.add(new DataSeries(DataSeries.Type.CLIENT, (Object)DataSeries.ClientDataSeries.TOTALS, Messages.PerformanceChartLabelEntirePortfolio, Colors.TOTALS.getRGB()));
        for (Security security : client.getSecurities()) {
            DataSeries series = new DataSeries(DataSeries.Type.SECURITY_BENCHMARK, security, security.getName(), wheel.next());
            series.setBenchmark(true);
            this.availableSeries.add(series);
        }
        this.buildPreTaxDataSeries(client, preferences, wheel);
    }

    private void buildPreTaxDataSeries(Client client, IPreferenceStore preferences, ColorWheel wheel) {
        this.availableSeries.add(new DataSeries(DataSeries.Type.CLIENT_PRETAX, (Object)DataSeries.ClientDataSeries.TOTALS, String.valueOf(Messages.PerformanceChartLabelEntirePortfolio) + Messages.LabelSuffix_PreTax, wheel.next()));
        for (Portfolio portfolio : client.getPortfolios()) {
            this.availableSeries.add(new DataSeries(DataSeries.Type.PORTFOLIO_PRETAX, portfolio, String.valueOf(portfolio.getName()) + Messages.LabelSuffix_PreTax, wheel.next()));
        }
        for (Portfolio portfolio : client.getPortfolios()) {
            this.availableSeries.add(new DataSeries(DataSeries.Type.PORTFOLIO_PLUS_ACCOUNT_PRETAX, portfolio, String.valueOf(portfolio.getName()) + " + " + portfolio.getReferenceAccount().getName() + Messages.LabelSuffix_PreTax, wheel.next()));
        }
        for (Account account : client.getAccounts()) {
            this.availableSeries.add(new DataSeries(DataSeries.Type.ACCOUNT_PRETAX, account, String.valueOf(account.getName()) + Messages.LabelSuffix_PreTax, wheel.next()));
        }
        this.addCustomClientFilters(client, preferences, true, wheel);
    }

    private void addCustomClientFilters(Client client, IPreferenceStore preferences, boolean isPreTax, ColorWheel wheel) {
        ClientFilterMenu menu = new ClientFilterMenu(client, preferences);
        HashSet<String> addedSeries = new HashSet<String>();
        Iterator<ClientFilterMenu.Item> iterator = menu.getCustomItems().iterator();
        while (iterator.hasNext()) {
            ClientFilterMenu.Item item;
            DataSeries series = new DataSeries(isPreTax ? DataSeries.Type.CLIENT_FILTER_PRETAX : DataSeries.Type.CLIENT_FILTER, item = iterator.next(), isPreTax ? String.valueOf(item.getLabel()) + Messages.LabelSuffix_PreTax : item.getLabel(), wheel.next());
            if (!addedSeries.add(series.getUUID())) continue;
            this.availableSeries.add(series);
        }
    }

    private void buildCommonDataSeries(Client client, IPreferenceStore preferences, ColorWheel wheel) {
        for (Security security : client.getSecurities()) {
            if (security.getCurrencyCode() == null) continue;
            this.availableSeries.add(new DataSeries(DataSeries.Type.SECURITY, security, security.getName(), wheel.next()));
        }
        for (Portfolio portfolio : client.getPortfolios()) {
            this.availableSeries.add(new DataSeries(DataSeries.Type.PORTFOLIO, portfolio, portfolio.getName(), wheel.next()));
        }
        for (Portfolio portfolio : client.getPortfolios()) {
            DataSeries series = new DataSeries(DataSeries.Type.PORTFOLIO_PLUS_ACCOUNT, portfolio, String.valueOf(portfolio.getName()) + " + " + portfolio.getReferenceAccount().getName(), wheel.next());
            this.availableSeries.add(series);
        }
        this.addCustomClientFilters(client, preferences, false, wheel);
        for (Account account : client.getAccounts()) {
            this.availableSeries.add(new DataSeries(DataSeries.Type.ACCOUNT, account, account.getName(), wheel.next()));
        }
        for (final Taxonomy taxonomy : client.getTaxonomies()) {
            taxonomy.foreach(new Taxonomy.Visitor(){

                public void visit(Classification classification) {
                    if (classification.getParent() == null) {
                        return;
                    }
                    DataSeriesSet.this.availableSeries.add(new DataSeries(DataSeries.Type.CLASSIFICATION, taxonomy, classification, classification.getName(), Colors.toRGB(classification.getColor())));
                }
            });
        }
    }
}

