/*
 * Decompiled with CFR 0.152.
 */
package name.abuchen.portfolio.ui.views.dataseries;

import name.abuchen.portfolio.money.Values;
import name.abuchen.portfolio.snapshot.PerformanceIndex;
import name.abuchen.portfolio.ui.util.chart.TimelineChart;
import name.abuchen.portfolio.ui.views.dataseries.AbstractChartSeriesBuilder;
import name.abuchen.portfolio.ui.views.dataseries.DataSeries;
import name.abuchen.portfolio.ui.views.dataseries.DataSeriesCache;
import name.abuchen.portfolio.util.Interval;
import org.swtchart.IBarSeries;
import org.swtchart.ILineSeries;

public class StatementOfAssetsSeriesBuilder
extends AbstractChartSeriesBuilder {
    public StatementOfAssetsSeriesBuilder(TimelineChart chart, DataSeriesCache cache) {
        super(chart, cache);
    }

    public void build(DataSeries series, Interval reportingPeriod) {
        PerformanceIndex index = this.getCache().lookup(series, reportingPeriod);
        if (series.getType() == DataSeries.Type.CLIENT) {
            this.addClient(series, index);
        } else {
            ILineSeries lineSeries = this.getChart().addDateSeries(index.getDates(), this.toDouble(index.getTotals(), Values.Amount.divider()), series.getLabel());
            this.configure(series, lineSeries);
        }
    }

    private void addClient(DataSeries series, PerformanceIndex clientIndex) {
        double[] values;
        switch ((DataSeries.ClientDataSeries)((Object)series.getInstance())) {
            case TOTALS: {
                values = this.toDouble(clientIndex.getTotals(), Values.Amount.divider());
                break;
            }
            case TRANSFERALS: {
                values = this.toDouble(clientIndex.getTransferals(), Values.Amount.divider());
                break;
            }
            case INVESTED_CAPITAL: {
                values = this.toDouble(clientIndex.calculateInvestedCapital(), Values.Amount.divider());
                break;
            }
            case ABSOLUTE_INVESTED_CAPITAL: {
                values = this.toDouble(clientIndex.calculateAbsoluteInvestedCapital(), Values.Amount.divider());
                break;
            }
            case ABSOLUTE_DELTA: {
                values = this.toDouble(clientIndex.calculateDelta(), Values.Amount.divider());
                break;
            }
            case ABSOLUTE_DELTA_ALL_RECORDS: {
                values = this.toDouble(clientIndex.calculateAbsoluteDelta(), Values.Amount.divider());
                break;
            }
            case TAXES: {
                values = this.accumulateAndToDouble(clientIndex.getTaxes(), Values.Amount.divider());
                break;
            }
            case DIVIDENDS: {
                values = this.toDouble(clientIndex.getDividends(), Values.Amount.divider());
                break;
            }
            case DIVIDENDS_ACCUMULATED: {
                values = this.accumulateAndToDouble(clientIndex.getDividends(), Values.Amount.divider());
                break;
            }
            case INTEREST: {
                values = this.toDouble(clientIndex.getInterest(), Values.Amount.divider());
                break;
            }
            case INTEREST_ACCUMULATED: {
                values = this.accumulateAndToDouble(clientIndex.getInterest(), Values.Amount.divider());
                break;
            }
            case INTEREST_CHARGE: {
                values = this.toDouble(clientIndex.getInterestCharge(), Values.Amount.divider());
                break;
            }
            case INTEREST_CHARGE_ACCUMULATED: {
                values = this.accumulateAndToDouble(clientIndex.getInterestCharge(), Values.Amount.divider());
                break;
            }
            case EARNINGS: {
                values = this.toDouble(this.add(clientIndex.getDividends(), clientIndex.getInterest()), Values.Amount.divider());
                break;
            }
            case EARNINGS_ACCUMULATED: {
                values = this.accumulateAndToDouble(this.add(clientIndex.getDividends(), clientIndex.getInterest()), Values.Amount.divider());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(series.getInstance()));
            }
        }
        if (series.isLineChart()) {
            ILineSeries lineSeries = this.getChart().addDateSeries(clientIndex.getDates(), values, series.getLabel());
            this.configure(series, lineSeries);
        } else {
            IBarSeries barSeries = this.getChart().addDateBarSeries(clientIndex.getDates(), values, series.getLabel());
            this.configure(series, barSeries);
        }
    }

    private long[] add(long[] a, long[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException();
        }
        long[] result = new long[a.length];
        int ii = 0;
        while (ii < result.length) {
            result[ii] = a[ii] + b[ii];
            ++ii;
        }
        return result;
    }

    private double[] toDouble(long[] input, double divider) {
        double[] answer = new double[input.length];
        int ii = 0;
        while (ii < answer.length) {
            answer[ii] = (double)input[ii] / divider;
            ++ii;
        }
        return answer;
    }

    private double[] accumulateAndToDouble(long[] input, double divider) {
        double[] answer = new double[input.length];
        long current = 0L;
        int ii = 0;
        while (ii < answer.length) {
            answer[ii] = (double)(current += input[ii]) / divider;
            ++ii;
        }
        return answer;
    }
}

